/*
 * Decompiled with CFR 0.152.
 */
package filius.software.www;

import filius.Main;
import filius.software.clientserver.ServerMitarbeiter;
import filius.software.system.Datei;
import filius.software.transportschicht.TCPSocket;
import filius.software.www.HTTPNachricht;
import filius.software.www.WebServer;
import filius.software.www.WebServerPlugIn;

public class WebServerMitarbeiter
extends ServerMitarbeiter {
    public WebServerMitarbeiter(WebServer server, TCPSocket socket) {
        super(server, socket);
    }

    private HTTPNachricht verarbeiteAnfrage(HTTPNachricht anfrage) {
        WebServerPlugIn plugin;
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebServerMitarbeiter), verarbeiteAnfrage(" + anfrage + ")");
        String tmp = null;
        HTTPNachricht antwort = new HTTPNachricht(0);
        String dateipfad = anfrage.getPfad().equals("/") ? "index.html" : (anfrage.getPfad().startsWith("/") ? anfrage.getPfad().substring(1) : anfrage.getPfad());
        String vHostRelPath = ((WebServer)this.server).vhostPrefix(anfrage.getHost());
        if (!vHostRelPath.endsWith("/")) {
            vHostRelPath = vHostRelPath + "/";
        }
        if ((dateipfad = vHostRelPath + dateipfad).startsWith("/")) {
            dateipfad = dateipfad.substring(1);
        }
        if ((plugin = ((WebServer)this.server).holePlugin(dateipfad)) != null) {
            tmp = anfrage.getMethod().equals("POST") ? plugin.holeHtmlSeite(anfrage.getDaten()) : plugin.holeHtmlSeite(null);
            if (tmp != null) {
                antwort.setDaten(tmp);
                antwort.setContentType("text/html");
                antwort.setStatusCode(200);
            } else {
                antwort.setStatusCode(500);
            }
        } else {
            Datei datei = ((WebServer)this.server).dateiLiefern(dateipfad);
            if (datei != null) {
                antwort.setDaten(datei.getDateiInhalt());
                if (datei.getName().endsWith("html") || datei.getName().endsWith("htm")) {
                    antwort.setContentType("text/html");
                    antwort.setStatusCode(200);
                } else if (datei.getName().endsWith("png")) {
                    antwort.setContentType("image/png");
                    antwort.setStatusCode(200);
                } else if (datei.getName().endsWith("bmp")) {
                    antwort.setContentType("image/bmp");
                    antwort.setStatusCode(200);
                } else if (datei.getName().endsWith("gif")) {
                    antwort.setContentType("image/gif");
                    antwort.setStatusCode(200);
                } else if (datei.getName().endsWith("jpg")) {
                    antwort.setContentType("image/jpg");
                    antwort.setStatusCode(200);
                } else {
                    antwort.setContentType("text/plain");
                    antwort.setStatusCode(200);
                }
            } else {
                antwort.setStatusCode(404);
            }
        }
        return antwort;
    }

    @Override
    protected void verarbeiteNachricht(String nachricht) {
        HTTPNachricht antwort;
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebServerMitarbeiter), verarbeiteNachricht(" + nachricht + ")");
        HTTPNachricht anfrage = new HTTPNachricht(nachricht);
        if (anfrage.getMethod().equals("GET") || anfrage.getMethod().equals("POST")) {
            antwort = this.verarbeiteAnfrage(anfrage);
        } else {
            antwort = new HTTPNachricht(0);
            antwort.setStatusCode(501);
        }
        this.sendeNachricht(antwort.toString());
    }
}

