/*
 * Decompiled with CFR 0.152.
 */
package filius.software.vermittlungsschicht;

import filius.Main;
import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.software.Protokoll;
import filius.software.system.SystemSoftware;
import java.util.List;
import java.util.StringTokenizer;

public abstract class VermittlungsProtokoll
extends Protokoll {
    public VermittlungsProtokoll(SystemSoftware systemSoftware) {
        super(systemSoftware);
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (VermittlungsProtokoll), constr: VermittlungsProtokoll(" + systemSoftware + ")");
    }

    public static boolean gleichesRechnernetz(String adresseEins, String adresseZwei, String netzmaske) {
        Main.debug.println("INVOKED (static) filius.software.vermittlungsschicht.VermittlungsProtokoll, gleichesRechnernetz(" + adresseEins + "," + adresseZwei + "," + netzmaske + ")");
        int addressOneAsInt = VermittlungsProtokoll.ipAddressToInt(adresseEins);
        int addressTwoAsInt = VermittlungsProtokoll.ipAddressToInt(adresseZwei);
        int netmaskAsInt = VermittlungsProtokoll.ipAddressToInt(netzmaske);
        return (addressOneAsInt & netmaskAsInt) == (addressTwoAsInt & netmaskAsInt);
    }

    static int ipAddressToInt(String address) {
        int addressAsInt = 0;
        StringTokenizer tokenizer = new StringTokenizer(address, ".");
        while (tokenizer.hasMoreTokens()) {
            addressAsInt = (addressAsInt << 8) + Integer.parseInt(tokenizer.nextToken());
        }
        return addressAsInt;
    }

    public static boolean isBroadcast(String zielIpAdresse, String sendeIpAdresse, String netzmaske) {
        int addressAsInt = VermittlungsProtokoll.ipAddressToInt(zielIpAdresse);
        int netmaskAsInt = VermittlungsProtokoll.ipAddressToInt(netzmaske);
        boolean isGenericBroadcast = addressAsInt == -1;
        boolean isNetworkBroadcast = (addressAsInt & ~netmaskAsInt) == (0xFFFFFFFF & ~netmaskAsInt) && VermittlungsProtokoll.gleichesRechnernetz(zielIpAdresse, sendeIpAdresse, netzmaske);
        return isGenericBroadcast || isNetworkBroadcast;
    }

    public static String getSubnetForIp(String ip, String mask) {
        int i;
        Main.debug.println("INVOKED (static) filius.software.vermittlungsschicht.VermittlungsProtokoll, getSubnetForIp(" + ip + "," + mask + ")");
        int[] res = new int[4];
        StringTokenizer tokenizer = new StringTokenizer(ip, ".");
        int[] a1 = new int[4];
        for (i = 0; i < a1.length && tokenizer.hasMoreTokens(); ++i) {
            a1[i] = Integer.parseInt(tokenizer.nextToken());
        }
        tokenizer = new StringTokenizer(mask, ".");
        int[] m = new int[4];
        for (i = 0; i < m.length && tokenizer.hasMoreTokens(); ++i) {
            m[i] = Integer.parseInt(tokenizer.nextToken());
        }
        for (i = 0; i < 4; ++i) {
            res[i] = a1[i] & m[i];
        }
        return res[0] + "." + res[1] + "." + res[2] + "." + res[3];
    }

    public boolean isLocalAddress(String ip) {
        if (VermittlungsProtokoll.gleichesRechnernetz(ip, "127.0.0.0", "255.0.0.0")) {
            return true;
        }
        InternetKnoten knoten = (InternetKnoten)this.holeSystemSoftware().getKnoten();
        for (NetzwerkInterface nic : knoten.getNetzwerkInterfaces()) {
            if (!ip.equals(nic.getIp())) continue;
            return true;
        }
        return false;
    }

    public boolean isApplicableBroadcast(String zielIp) {
        List<NetzwerkInterface> nics = ((InternetKnoten)this.holeSystemSoftware().getKnoten()).getNetzwerkInterfaces();
        for (NetzwerkInterface nic : nics) {
            if (!VermittlungsProtokoll.isBroadcast(zielIp, nic.getIp(), nic.getSubnetzMaske())) continue;
            return true;
        }
        return false;
    }
}

