/*
 * Decompiled with CFR 0.152.
 */
package filius.software.vermittlungsschicht;

import filius.Main;
import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.I18n;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.system.SystemSoftware;
import filius.software.vermittlungsschicht.ICMPThread;
import filius.software.vermittlungsschicht.IcmpPaket;
import filius.software.vermittlungsschicht.Route;
import filius.software.vermittlungsschicht.RouteNotFoundException;
import filius.software.vermittlungsschicht.VermittlungsProtokoll;
import java.util.LinkedList;
import java.util.concurrent.TimeoutException;

public class ICMP
extends VermittlungsProtokoll
implements I18n {
    public static final int TYPE_ECHO_REPLY = 0;
    public static final int TYPE_ECHO_REQUEST = 8;
    public static final int TYPE_DESTINATION_UNREACHABLE = 3;
    public static final int TYPE_TIME_EXCEEDED = 11;
    public static final int CODE_ECHO = 0;
    public static final int CODE_DEST_NETWORK_UNREACHABLE = 0;
    public static final int CODE_DEST_HOST_UNREACHABLE = 1;
    public static final int CODE_TTL_EXPIRED = 0;
    private ICMPThread thread;

    public ICMP(SystemSoftware systemAnwendung) {
        super(systemAnwendung);
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (ICMP), constr: ICMP(" + systemAnwendung + ")");
    }

    @Override
    public void starten() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ICMP), starten()");
        this.thread = new ICMPThread(this);
        this.thread.starten();
    }

    @Override
    public void beenden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ICMP), beenden()");
        if (this.thread != null) {
            this.thread.beenden();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void placeLocalICMPPacket(IcmpPaket icmpPacket) {
        LinkedList<IcmpPaket> icmpPakete;
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ICMP), placeLocalICMPPacket(" + icmpPacket.toString() + ")");
        LinkedList<IcmpPaket> linkedList = icmpPakete = ((InternetKnotenBetriebssystem)this.holeSystemSoftware()).holeEthernet().holeICMPPuffer();
        synchronized (linkedList) {
            icmpPakete.add(icmpPacket);
            icmpPakete.notify();
        }
    }

    public void sendEchoRequest(String destIp, int seqNr) {
        this.sendeICMP(8, 0, seqNr, null, destIp);
    }

    public void sendEchoReply(IcmpPaket rcvPacket) {
        this.sendeICMP(0, 0, rcvPacket.getSeqNr(), rcvPacket.getZielIp(), rcvPacket.getQuellIp());
    }

    public void sendeICMP(int typ, int code, String zielIP) {
        this.sendeICMP(typ, code, 0, null, zielIP);
    }

    public void sendeICMP(int typ, int code, int seqNr, String quellIP, String zielIP) {
        this.sendeICMP(typ, code, 64, seqNr, quellIP, zielIP);
    }

    private void sendeICMP(int typ, int code, int ttl, int seqNr, String quellIP, String zielIP) {
        block4: {
            IcmpPaket icmpPaket = new IcmpPaket();
            icmpPaket.setProtokollTyp("0x800");
            icmpPaket.setZielIp(zielIP);
            icmpPaket.setIcmpType(typ);
            icmpPaket.setIcmpCode(code);
            icmpPaket.setSeqNr(seqNr);
            icmpPaket.setTtl(ttl);
            try {
                InternetKnotenBetriebssystem bs = (InternetKnotenBetriebssystem)this.holeSystemSoftware();
                Route route = bs.determineRoute(zielIP);
                if (quellIP == null) {
                    icmpPaket.setQuellIp(route.getInterfaceIpAddress());
                } else {
                    icmpPaket.setQuellIp(quellIP);
                }
                this.dispatch(icmpPaket, zielIP, route);
            }
            catch (RouteNotFoundException e) {
                if (!icmpPaket.isEchoRequest()) break block4;
                this.sendeICMP(3, 0, seqNr, null, quellIP);
            }
        }
    }

    private void dispatch(IcmpPaket paket, String zielIp, Route route) throws RouteNotFoundException {
        NetzwerkInterface nic = ((InternetKnoten)this.holeSystemSoftware().getKnoten()).getNetzwerkInterfaceByIp(route.getInterfaceIpAddress());
        if (ICMP.isBroadcast(zielIp, route.getInterfaceIpAddress(), nic.getSubnetzMaske())) {
            this.sendBroadcast(paket, zielIp, nic.getMac());
        } else if (ICMP.gleichesRechnernetz(zielIp, route.getInterfaceIpAddress(), nic.getSubnetzMaske())) {
            this.sendUnicastToNextHop(paket, paket.getZielIp(), nic.getMac());
        } else {
            this.sendUnicastToNextHop(paket, route.getGateway(), nic.getMac());
        }
    }

    private void sendUnicastToNextHop(IcmpPaket paket, String ziel, String macOfNicToUse) {
        InternetKnotenBetriebssystem bs = (InternetKnotenBetriebssystem)this.holeSystemSoftware();
        String zielMacAdresse = bs.holeARP().holeARPTabellenEintrag(ziel);
        if (this.isLocalAddress(ziel)) {
            this.placeLocalICMPPacket(paket);
        } else if (zielMacAdresse != null) {
            bs.holeEthernet().senden(paket, macOfNicToUse, zielMacAdresse, "0x800");
        } else if (paket.isEchoRequest()) {
            this.sendeICMP(3, 1, paket.getSeqNr(), null, paket.getQuellIp());
        }
    }

    private void sendBroadcast(IcmpPaket paket, String ziel, String macOfNicToUse) {
        paket.setTtl(1);
        InternetKnotenBetriebssystem bs = (InternetKnotenBetriebssystem)this.holeSystemSoftware();
        bs.holeEthernet().senden(paket, macOfNicToUse, "FF:FF:FF:FF:FF:FF", "0x800");
    }

    public void weiterleitenPaket(IcmpPaket icmpPaket) {
        if (icmpPaket.getTtl() <= 0) {
            this.sendeICMP(11, 0, icmpPaket.getSeqNr(), null, icmpPaket.getQuellIp());
        } else {
            this.sendeICMP(icmpPaket.getIcmpType(), icmpPaket.getIcmpCode(), icmpPaket.getTtl(), icmpPaket.getSeqNr(), icmpPaket.getQuellIp(), icmpPaket.getZielIp());
        }
    }

    public int startSinglePing(String destIp, int seqNr) throws TimeoutException {
        int resultTTL = -1;
        this.thread.resetIcmpResponseQueue();
        this.sendEchoRequest(destIp, seqNr);
        IcmpPaket response = this.thread.waitForIcmpResponse();
        if (response == null) {
            throw new TimeoutException("Destination Host Unreachable");
        }
        if (!destIp.equals(response.getQuellIp()) || seqNr != response.getSeqNr() || !response.isEchoResponse()) {
            throw new TimeoutException("Destination Host Unreachable");
        }
        resultTTL = response.getTtl();
        return resultTTL;
    }

    public IcmpPaket sendProbe(String destIp, int ttl, int seqNr) {
        this.thread.resetIcmpResponseQueue();
        this.sendeICMP(8, 0, ttl, seqNr, null, destIp);
        return this.thread.waitForIcmpResponse();
    }

    public ICMPThread getICMPThread() {
        return this.thread;
    }
}

