/*
 * Decompiled with CFR 0.152.
 */
package filius.software.vermittlungsschicht;

import filius.Main;
import filius.hardware.NetzwerkInterface;
import filius.software.ProtokollThread;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.vermittlungsschicht.ARP;
import filius.software.vermittlungsschicht.ArpPaket;

public class ARPThread
extends ProtokollThread {
    private ARP vermittlung;

    public ARPThread(ARP vermittlung) {
        super(((InternetKnotenBetriebssystem)vermittlung.holeSystemSoftware()).holeEthernet().holeARPPuffer());
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ARPThread), constr: ARPThread(" + vermittlung + ")");
        this.vermittlung = vermittlung;
    }

    @Override
    protected void verarbeiteDatenEinheit(Object datenEinheit) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ARPThread), verarbeiteDatenEinheit(" + datenEinheit.toString() + ")");
        ArpPaket arpPaket = (ArpPaket)datenEinheit;
        if (!arpPaket.getQuellIp().equalsIgnoreCase("0.0.0.0")) {
            this.vermittlung.hinzuARPTabellenEintrag(arpPaket.getQuellIp(), arpPaket.getQuellMacAdresse());
        }
        InternetKnotenBetriebssystem bs = (InternetKnotenBetriebssystem)this.vermittlung.holeSystemSoftware();
        NetzwerkInterface nic = this.vermittlung.getBroadcastNic(arpPaket.getQuellIp());
        if (nic != null && arpPaket.getZielMacAdresse().equalsIgnoreCase("ff:ff:ff:ff:ff:ff") && arpPaket.getZielIp().equalsIgnoreCase(nic.getIp())) {
            ArpPaket antwortArp = new ArpPaket();
            antwortArp.setProtokollTyp(arpPaket.getProtokollTyp());
            antwortArp.setQuellIp(nic.getIp());
            antwortArp.setQuellMacAdresse(nic.getMac());
            if (arpPaket.getQuellIp().equalsIgnoreCase("0.0.0.0")) {
                antwortArp.setZielIp("255.255.255.255");
                antwortArp.setZielMacAdresse("ff:ff:ff:ff:ff:ff");
            } else {
                antwortArp.setZielIp(arpPaket.getQuellIp());
                antwortArp.setZielMacAdresse(arpPaket.getQuellMacAdresse());
            }
            bs.holeEthernet().senden(antwortArp, nic.getMac(), antwortArp.getZielMacAdresse(), "0x806");
        }
    }
}

