/*
 * Decompiled with CFR 0.152.
 */
package filius.software.vermittlungsschicht;

import filius.Main;
import filius.hardware.NetzwerkInterface;
import filius.hardware.Verbindung;
import filius.hardware.knoten.InternetKnoten;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.system.SystemSoftware;
import filius.software.vermittlungsschicht.ARPThread;
import filius.software.vermittlungsschicht.ArpPaket;
import filius.software.vermittlungsschicht.IP;
import filius.software.vermittlungsschicht.VermittlungsProtokoll;
import java.util.HashMap;
import java.util.Map;

public class ARP
extends VermittlungsProtokoll {
    private HashMap<String, String[]> arpTabelle = new HashMap();
    private ARPThread thread;

    public ARP(SystemSoftware systemAnwendung) {
        super(systemAnwendung);
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (ARP), constr: ARP(" + systemAnwendung + ")");
    }

    @Override
    public void starten() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ARP), starten()");
        this.arpTabelle = new HashMap();
        this.hinzuARPTabellenEintrag("255.255.255.255", "FF:FF:FF:FF:FF:FF");
        this.thread = new ARPThread(this);
        this.thread.starten();
    }

    @Override
    public void beenden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ARP), beenden()");
        if (this.thread != null) {
            this.thread.beenden();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hinzuARPTabellenEintrag(String ipAdresse, String macAdresse) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ARP), hinzuARPTabellenEintrag(" + ipAdresse + "," + macAdresse + ")");
        String tmpTime = "" + System.currentTimeMillis();
        String[] tmpString = new String[]{macAdresse, tmpTime};
        HashMap<String, String[]> hashMap = this.arpTabelle;
        synchronized (hashMap) {
            this.arpTabelle.put(ipAdresse, tmpString);
            this.arpTabelle.notify();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String[]> entry : this.arpTabelle.entrySet()) {
            builder.append("\t").append(entry.getKey()).append(" \t ").append(entry.getValue()[0]).append("\n");
        }
        return builder.toString();
    }

    public Map<String, String> holeARPTabelle() {
        HashMap<String, String> table = new HashMap<String, String>();
        for (String ipAddress : this.arpTabelle.keySet()) {
            table.put(ipAddress, this.arpTabelle.get(ipAddress)[0]);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String holeARPTabellenEintrag(String zielIp) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ARP), holeARPTabellenEintrag(" + zielIp + ")");
        if (zielIp.equals("127.0.0.1")) {
            return ((InternetKnotenBetriebssystem)this.holeSystemSoftware()).holeMACAdresse();
        }
        if (this.holeSystemSoftware() instanceof InternetKnotenBetriebssystem && zielIp.equals(((InternetKnotenBetriebssystem)this.holeSystemSoftware()).holeIPAdresse())) {
            return ((InternetKnotenBetriebssystem)this.holeSystemSoftware()).holeMACAdresse();
        }
        if (this.arpTabelle.get(zielIp) != null) {
            return this.arpTabelle.get(zielIp)[0];
        }
        for (int i = 0; this.arpTabelle.get(zielIp) == null && i < 2; ++i) {
            this.sendeARPBroadcast(zielIp);
            HashMap<String, String[]> hashMap = this.arpTabelle;
            synchronized (hashMap) {
                try {
                    this.arpTabelle.wait(Verbindung.holeRTT() / 2);
                }
                catch (InterruptedException e) {
                    Main.debug.println("EXCEPTION (" + this.hashCode() + "): keine Anwort auf ARP-Broadcast fuer IP-Adresse " + zielIp + " eingegangen!");
                    e.printStackTrace(Main.debug);
                }
                continue;
            }
        }
        if (this.arpTabelle.get(zielIp) != null) {
            return this.arpTabelle.get(zielIp)[0];
        }
        Main.debug.println("ERROR (" + this.hashCode() + "): kein ARP-Tabellen-Eintrag fuer " + zielIp);
        return null;
    }

    private void sendeARPBroadcast(String suchIp) {
        NetzwerkInterface nic = this.getBroadcastNic(suchIp);
        if (nic == null) {
            return;
        }
        ArpPaket arpPaket = new ArpPaket();
        arpPaket.setProtokollTyp("0x806");
        arpPaket.setZielIp(suchIp);
        arpPaket.setZielMacAdresse("FF:FF:FF:FF:FF:FF");
        arpPaket.setQuellIp(nic.getIp());
        arpPaket.setQuellMacAdresse(nic.getMac());
        ((InternetKnotenBetriebssystem)this.holeSystemSoftware()).holeEthernet().senden(arpPaket, nic.getMac(), "FF:FF:FF:FF:FF:FF", "0x806");
    }

    public NetzwerkInterface getBroadcastNic(String zielStr) {
        long zielAddr = IP.inetAton(zielStr);
        long bestMask = -1L;
        NetzwerkInterface bestNic = null;
        for (NetzwerkInterface nic : ((InternetKnoten)this.holeSystemSoftware().getKnoten()).getNetzwerkInterfaces()) {
            long netAddr;
            long maskAddr = IP.inetAton(nic.getSubnetzMaske());
            if (maskAddr <= bestMask || (netAddr = IP.inetAton(nic.getIp()) & maskAddr) != (maskAddr & zielAddr)) continue;
            bestMask = maskAddr;
            bestNic = nic;
        }
        if (null == bestNic) {
            bestMask = IP.inetAton(((InternetKnotenBetriebssystem)this.holeSystemSoftware()).holeNetzmaske());
            bestNic = ((InternetKnoten)this.holeSystemSoftware().getKnoten()).getNetzwerkInterfaces().get(0);
        }
        return bestNic;
    }

    public ARPThread getARPThread() {
        return this.thread;
    }
}

