/*
 * Decompiled with CFR 0.152.
 */
package filius.software.transportschicht;

import filius.Main;
import filius.exception.SocketException;
import filius.exception.VerbindungsException;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.Socket;
import filius.software.transportschicht.UdpSegment;
import java.util.LinkedList;

public class UDPSocket
extends Socket {
    private LinkedList<UdpSegment> puffer = new LinkedList();
    private boolean verbunden = false;

    public UDPSocket(InternetKnotenBetriebssystem betriebssystem, String zielAdresse, int zielPort) throws VerbindungsException {
        super(betriebssystem, zielAdresse, zielPort, 17);
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), constr: UDPSocket(" + betriebssystem + "," + zielAdresse + "," + zielPort + ")");
    }

    public UDPSocket(InternetKnotenBetriebssystem betriebssystem, String zielAdresse, int zielPort, int lokalerPort) throws VerbindungsException {
        super(betriebssystem, zielAdresse, zielPort, 17, lokalerPort);
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), constr: UDPSocket(" + betriebssystem + "," + zielAdresse + "," + zielPort + "," + lokalerPort + ")");
    }

    public UDPSocket(InternetKnotenBetriebssystem betriebssystem, int lokalerPort) throws VerbindungsException {
        super(betriebssystem, lokalerPort, 17);
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), constr: UDPSocket(" + betriebssystem + "," + lokalerPort + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hinzufuegen(String startIp, int startPort, Object segment) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), hinzufuegen(" + startIp + "," + startPort + "," + segment + ")");
        this.zielIp = startIp;
        this.zielPort = startPort;
        LinkedList<UdpSegment> linkedList = this.puffer;
        synchronized (linkedList) {
            this.puffer.add((UdpSegment)segment);
            this.puffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String empfangen(long millis) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), empfangen(" + millis + ")");
        LinkedList<UdpSegment> linkedList = this.puffer;
        synchronized (linkedList) {
            if (this.puffer.size() < 1) {
                try {
                    this.puffer.wait(millis);
                }
                catch (InterruptedException e) {
                    e.printStackTrace(Main.debug);
                }
            }
            if (this.puffer.size() >= 1) {
                UdpSegment segment = this.puffer.removeFirst();
                return segment.getDaten();
            }
            return null;
        }
    }

    @Override
    public synchronized String empfangen() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), empfangen()");
        return this.empfangen(0L);
    }

    @Override
    public synchronized void senden(String nachricht) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), senden(" + nachricht + ")");
        UdpSegment segment = new UdpSegment();
        segment.setDaten(nachricht);
        segment.setQuellPort(this.lokalerPort);
        segment.setZielPort(this.zielPort);
        super.sende(segment);
    }

    public synchronized void sendeBroadcast(String nachricht) {
        this.sendeBroadcast(null, nachricht);
    }

    public synchronized void sendeBroadcast(String quellIp, String nachricht) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), sendeBroadcast(" + nachricht + ")");
        UdpSegment segment = new UdpSegment();
        segment.setDaten(nachricht);
        segment.setQuellPort(this.lokalerPort);
        segment.setZielPort(this.zielPort);
        this.protokoll.senden("255.255.255.255", quellIp, segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schliessen() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), schliessen()");
        LinkedList<UdpSegment> linkedList = this.puffer;
        synchronized (linkedList) {
            this.puffer.notifyAll();
        }
        this.austragenPort();
        this.verbunden = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beenden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), beenden()");
        LinkedList<UdpSegment> linkedList = this.puffer;
        synchronized (linkedList) {
            this.puffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verbinden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), verbinden()");
        if (!this.verbunden) {
            if (this.modus == 2) {
                LinkedList<UdpSegment> linkedList = this.puffer;
                synchronized (linkedList) {
                    if (this.puffer.size() <= 0) {
                        try {
                            this.puffer.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            try {
                this.eintragenPort();
                this.verbunden = true;
            }
            catch (SocketException e) {
                Main.debug.println("EXCEPTION (" + this.hashCode() + "): verbinden() NICHT erfolgreich");
                e.printStackTrace(Main.debug);
            }
        }
    }

    @Override
    public boolean istVerbunden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), istVerbunden()");
        return this.verbunden;
    }

    @Override
    public String getStateAsString() {
        if (this.istVerbunden()) {
            return "CONNECTED";
        }
        return "DISCONNECTED";
    }
}

