/*
 * Decompiled with CFR 0.152.
 */
package filius.software.transportschicht;

import filius.Main;
import filius.exception.ServerSocketException;
import filius.exception.TimeOutException;
import filius.exception.VerbindungsException;
import filius.rahmenprogramm.I18n;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.Socket;
import filius.software.transportschicht.SocketSchnittstelle;
import filius.software.transportschicht.TCP;
import filius.software.transportschicht.TCPSocket;
import filius.software.transportschicht.TransportProtokoll;
import filius.software.transportschicht.UDPSocket;
import java.util.Hashtable;

public class ServerSocket
implements SocketSchnittstelle,
I18n {
    private Hashtable<String, Socket> socketListe = new Hashtable();
    private Socket aktuellerSocket;
    private InternetKnotenBetriebssystem betriebssystem;
    private TransportProtokoll protokoll;
    private int lokalerPort;

    public ServerSocket(InternetKnotenBetriebssystem betriebssystem, int lokalerPort, int transportProtokoll) throws ServerSocketException {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ServerSocket), constr: ServerSocket(" + betriebssystem + "," + lokalerPort + "," + transportProtokoll + ")");
        this.betriebssystem = betriebssystem;
        this.lokalerPort = lokalerPort;
        this.protokoll = transportProtokoll == 6 ? betriebssystem.holeTcp() : betriebssystem.holeUdp();
        if (!this.protokoll.reservierePort(lokalerPort, this)) {
            throw new ServerSocketException(messages.getString("sw_serversocket_msg1") + " " + lokalerPort + " " + messages.getString("sw_serversocket_msg2"));
        }
    }

    public int getLocalPort() {
        return this.lokalerPort;
    }

    public Hashtable<String, Socket> getSockets() {
        return this.socketListe;
    }

    public void eintragenSocket(Socket socket) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ServerSocket), eintragenSocket(" + socket + ")");
        String ziel = socket.holeZielIPAdresse() + ":" + socket.holeZielPort();
        this.socketListe.put(ziel, socket);
    }

    public void austragenSocket(Socket socket) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ServerSocket), austragenSocket(" + socket + ")");
        String ziel = socket.holeZielIPAdresse() + ":" + socket.holeZielPort();
        this.socketListe.remove(ziel);
        if (this.socketListe.isEmpty() && this.aktuellerSocket == null) {
            this.protokoll.gibPortFrei(this.lokalerPort);
        }
    }

    public synchronized Socket oeffnen() throws VerbindungsException {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ServerSocket), oeffnen()");
        Socket socket = null;
        socket = this.protokoll instanceof TCP ? new TCPSocket(this.betriebssystem, this.lokalerPort) : new UDPSocket(this.betriebssystem, this.lokalerPort);
        this.aktuellerSocket = socket;
        try {
            socket.verbinden();
        }
        catch (TimeOutException e) {
            socket = null;
            this.aktuellerSocket = null;
            e.printStackTrace(Main.debug);
        }
        if (socket != null && socket.istVerbunden()) {
            return socket;
        }
        return null;
    }

    @Override
    public void hinzufuegen(String startIp, int startPort, Object segment) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ServerSocket), hinzufuegen(" + startIp + "," + startPort + "," + segment + ")");
        String start = startIp + ":" + startPort;
        if (this.socketListe.containsKey(start)) {
            Socket socket = this.socketListe.get(start);
            socket.hinzufuegen(startIp, startPort, segment);
        } else if (this.aktuellerSocket != null) {
            this.aktuellerSocket.hinzufuegen(startIp, startPort, segment);
        }
    }

    @Override
    public void schliessen() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ServerSocket), schliessen()");
        if (this.aktuellerSocket != null) {
            this.aktuellerSocket.schliessen();
        }
        this.protokoll.gibPortFrei(this.lokalerPort);
    }

    @Override
    public void beenden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ServerSocket), beenden()");
        if (this.aktuellerSocket != null) {
            this.aktuellerSocket.beenden();
        }
    }
}

