/*
 * Decompiled with CFR 0.152.
 */
package filius.software.system;

import filius.Main;
import filius.hardware.knoten.Modem;
import filius.rahmenprogramm.I18n;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.netzzugangsschicht.ModemEmpfaenger;
import filius.software.netzzugangsschicht.ModemSender;
import filius.software.system.SystemSoftware;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class ModemFirmware
extends SystemSoftware
implements Runnable,
I18n {
    public static final int SERVER = 1;
    public static final int CLIENT = 2;
    private int port = 12345;
    private String ipAdresse = "localhost";
    private ServerSocket serverSocket;
    private Socket socket = null;
    private ModemEmpfaenger empfaenger = null;
    private ModemSender sender = null;
    private int mode = 2;

    public synchronized void starteServer() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ModemFirmware), starteServer()");
        new Thread(this).start();
    }

    public void starteClient() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ModemFirmware), starteClient()");
        try {
            this.socket = new Socket(this.ipAdresse, this.port);
            this.aktiviereModemVerbindung();
        }
        catch (UnknownHostException e) {
            e.printStackTrace(Main.debug);
            this.benachrichtigeBeobacher(messages.getString("modemfirmware_msg1"));
            ((Modem)this.getKnoten()).setzeModemVerbindungAktiv(false);
        }
        catch (IOException e) {
            e.printStackTrace(Main.debug);
            this.benachrichtigeBeobacher(messages.getString("modemfirmware_msg2"));
            ((Modem)this.getKnoten()).setzeModemVerbindungAktiv(false);
        }
        catch (InterruptedException e) {
            e.printStackTrace(Main.debug);
            this.benachrichtigeBeobacher(null);
            ((Modem)this.getKnoten()).setzeModemVerbindungAktiv(false);
        }
    }

    private synchronized void aktiviereModemVerbindung() throws IOException, InterruptedException {
        OutputStream out = null;
        InputStream in = null;
        while (!this.socket.isConnected()) {
            Thread.sleep(100L);
        }
        this.benachrichtigeBeobacher(null);
        in = this.socket.getInputStream();
        out = this.socket.getOutputStream();
        ((Modem)this.getKnoten()).setzeModemVerbindungAktiv(true);
        if (in != null && out != null) {
            this.leerePortPuffer();
            this.empfaenger = new ModemEmpfaenger(this, in);
            this.sender = new ModemSender(this, out);
            this.empfaenger.starten();
            this.sender.starten();
        }
    }

    private synchronized void deaktiviereModemVerbindung() {
        if (this.empfaenger != null) {
            this.empfaenger.beenden();
            this.empfaenger = null;
        }
        if (this.sender != null) {
            this.sender.beenden();
            this.sender = null;
        }
    }

    public void setMode(int mode) {
        this.trennen();
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean istServerBereit() {
        return this.serverSocket != null && this.serverSocket.isBound();
    }

    public void trennen() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ModemFirmware), trennen()");
        this.deaktiviereModemVerbindung();
        if (this.mode == 1 && this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace(Main.debug);
            }
            this.socket = null;
        }
        this.benachrichtigeBeobacher(null);
        ((Modem)this.getKnoten()).setzeModemVerbindungAktiv(false);
    }

    public void verbindungZuruecksetzen() {
        this.trennen();
        if (this.mode == 1) {
            this.starteServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leerePortPuffer() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ModemFirmware), leerePortPuffer()");
        LinkedList<EthernetFrame> linkedList = ((Modem)this.getKnoten()).getErstenAnschluss().holeEingangsPuffer();
        synchronized (linkedList) {
            ((Modem)this.getKnoten()).getErstenAnschluss().holeEingangsPuffer().clear();
        }
    }

    @Override
    public void run() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ModemFirmware), run()");
        try {
            this.serverSocket = new ServerSocket(this.port);
            this.benachrichtigeBeobacher(null);
            this.socket = this.serverSocket.accept();
            this.aktiviereModemVerbindung();
            this.serverSocket.close();
        }
        catch (Exception e) {
            Main.debug.println("EXCEPTION (" + this.hashCode() + "): Modemverbindung beendet.");
            ((Modem)this.getKnoten()).setzeModemVerbindungAktiv(false);
        }
        finally {
            this.benachrichtigeBeobacher(null);
        }
    }

    public String getIpAdresse() {
        return this.ipAdresse;
    }

    public void setIpAdresse(String ipAdresse) {
        this.ipAdresse = ipAdresse;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

