/*
 * Decompiled with CFR 0.152.
 */
package filius.software.system;

import filius.Main;
import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.hardware.knoten.Notebook;
import filius.hardware.knoten.Rechner;
import filius.hardware.knoten.Vermittlungsrechner;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.FiliusClassLoader;
import filius.rahmenprogramm.Information;
import filius.software.Anwendung;
import filius.software.dns.Resolver;
import filius.software.netzzugangsschicht.Ethernet;
import filius.software.netzzugangsschicht.EthernetThread;
import filius.software.rip.RIPTable;
import filius.software.system.Dateisystem;
import filius.software.system.SystemSoftware;
import filius.software.transportschicht.TCP;
import filius.software.transportschicht.UDP;
import filius.software.vermittlungsschicht.ARP;
import filius.software.vermittlungsschicht.ARPThread;
import filius.software.vermittlungsschicht.ICMP;
import filius.software.vermittlungsschicht.ICMPThread;
import filius.software.vermittlungsschicht.IP;
import filius.software.vermittlungsschicht.IPThread;
import filius.software.vermittlungsschicht.Route;
import filius.software.vermittlungsschicht.RouteNotFoundException;
import filius.software.vermittlungsschicht.Weiterleitungstabelle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class InternetKnotenBetriebssystem
extends SystemSoftware {
    private static final long serialVersionUID = 1L;
    private Dateisystem dateisystem;
    private HashMap<String, Anwendung> installierteAnwendung;
    private Resolver dnsclient;
    private TCP tcp;
    private UDP udp;
    private ARP arpVermittlung;
    private IP vermittlung;
    private ICMP icmpVermittlung;
    private Weiterleitungstabelle weiterleitungstabelle;
    private Ethernet ethernet;

    public InternetKnotenBetriebssystem() {
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), constr: InternetKnotenBetriebssystem()");
        this.installierteAnwendung = new HashMap();
        this.weiterleitungstabelle = new Weiterleitungstabelle();
        this.weiterleitungstabelle.setInternetKnotenBetriebssystem(this);
        this.arpVermittlung = new ARP(this);
        this.vermittlung = new IP(this);
        this.icmpVermittlung = new ICMP(this);
        this.ethernet = new Ethernet(this);
        this.tcp = new TCP(this);
        this.udp = new UDP(this);
        this.dateisystem = new Dateisystem();
        this.dnsclient = new Resolver();
        this.dnsclient.setSystemSoftware(this);
        Main.debug.println("DEBUG: InternetKnotenBetriebssystem (" + this.hashCode() + ")\n\tEthernet: " + this.ethernet.hashCode() + "\n\tARP: " + this.arpVermittlung.hashCode() + "\n\tIP: " + this.vermittlung.hashCode() + "\n\tICMP: " + this.icmpVermittlung.hashCode() + "\n\tTCP: " + this.tcp.hashCode() + "\n\tUDP: " + this.udp.hashCode());
    }

    @Override
    public void beenden() {
        super.beenden();
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), beenden()");
        this.ethernet.beenden();
        this.arpVermittlung.beenden();
        this.vermittlung.beenden();
        this.icmpVermittlung.beenden();
        this.tcp.beenden();
        this.udp.beenden();
        this.dnsclient.beenden();
        for (Anwendung anwendung : this.installierteAnwendung.values()) {
            anwendung.beenden();
        }
    }

    private void printDebugInfo() {
        Main.debug.println("DEBUG (" + this.hashCode() + "): start InternetKnotenBetriebssystem");
        if (this.getKnoten() != null) {
            Main.debug.println("DEBUG (" + this.hashCode() + ") - Hostname = " + this.getKnoten().holeAnzeigeName());
            Main.debug.print("DEBUG (" + this.hashCode() + ") - Hardwaretyp = '");
            if (this.getKnoten() instanceof Notebook) {
                Main.debug.println("Notebook'");
            } else if (this.getKnoten() instanceof Rechner) {
                Main.debug.println("Rechner'");
            } else if (this.getKnoten() instanceof Vermittlungsrechner) {
                Main.debug.println("Vermittlungsrechner'");
            } else {
                Main.debug.println("<unknown>'");
            }
        } else {
            Main.debug.println("DEBUG (" + this.hashCode() + ") - Hostname = <unknown>");
            Main.debug.println("DEBUG (" + this.hashCode() + ") - Hardwaretyp = <unknown>");
        }
        Main.debug.println("DEBUG (" + this.hashCode() + ") - ETHER = " + this.ethernet.hashCode());
        LinkedList<EthernetThread> threads = this.ethernet.getEthernetThreads();
        if (threads != null) {
            for (int i = 0; i < threads.size(); ++i) {
                Main.debug.println("DEBUG (" + this.hashCode() + ")      - ETHER T-" + i + " = " + ((EthernetThread)threads.get(i)).hashCode());
            }
        }
        Main.debug.println("DEBUG (" + this.hashCode() + ") - ARP = " + this.arpVermittlung.hashCode());
        ARPThread thread = this.arpVermittlung.getARPThread();
        if (thread != null) {
            Main.debug.println("DEBUG (" + this.hashCode() + ")      - ARP T = " + thread.hashCode());
        }
        Main.debug.println("DEBUG (" + this.hashCode() + ") - IP = " + this.vermittlung.hashCode());
        IPThread IPthread = this.vermittlung.getIPThread();
        if (IPthread != null) {
            Main.debug.println("DEBUG (" + this.hashCode() + ")      - IP T = " + IPthread.hashCode());
        }
        Main.debug.println("DEBUG (" + this.hashCode() + ") - ICMP = " + this.icmpVermittlung.hashCode());
        ICMPThread ICMPthread = this.icmpVermittlung.getICMPThread();
        if (IPthread != null) {
            Main.debug.println("DEBUG (" + this.hashCode() + ")      - ICMP T = " + ICMPthread.hashCode());
        }
        Main.debug.println("DEBUG (" + this.hashCode() + ") - TCP = " + this.tcp.hashCode());
        Main.debug.println("DEBUG (" + this.hashCode() + ") - UDP = " + this.udp.hashCode());
        if (this.getKnoten() != null) {
            if (this.getKnoten() instanceof Notebook) {
                NetzwerkInterface nic = ((Notebook)this.getKnoten()).getNetzwerkInterfaces().get(0);
                Main.debug.println("DEBUG (" + this.hashCode() + ") - NIC: {IP=" + nic.getIp() + "/" + nic.getSubnetzMaske() + ", MAC=" + nic.getMac() + ", DNS=" + nic.getDns() + ", GW=" + nic.getGateway() + "}");
            } else if (this.getKnoten() instanceof Rechner) {
                NetzwerkInterface nic = ((Rechner)this.getKnoten()).getNetzwerkInterfaces().get(0);
                Main.debug.println("DEBUG (" + this.hashCode() + ") - NIC: {IP=" + nic.getIp() + "/" + nic.getSubnetzMaske() + ", MAC=" + nic.getMac() + ", DNS=" + nic.getDns() + ", GW=" + nic.getGateway() + "}");
            } else if (this.getKnoten() instanceof Vermittlungsrechner) {
                int nicNr = 0;
                for (NetzwerkInterface nic : ((Vermittlungsrechner)this.getKnoten()).getNetzwerkInterfaces()) {
                    Main.debug.println("DEBUG (" + this.hashCode() + ") - NIC" + nicNr + ": {IP=" + nic.getIp() + "/" + nic.getSubnetzMaske() + ", MAC=" + nic.getMac() + ", DNS=" + nic.getDns() + ", GW=" + nic.getGateway() + "}");
                    ++nicNr;
                }
            }
        } else {
            Main.debug.println("DEBUG (" + this.hashCode() + ") - NIC=<unknown>");
        }
        this.getWeiterleitungstabelle().printTabelle(Integer.toString(this.hashCode()));
    }

    @Override
    public synchronized void starten() {
        super.starten();
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), starten()");
        this.dateisystem.fixDirectory(this.dateisystem.getRoot());
        this.ethernet.starten();
        this.arpVermittlung.starten();
        this.vermittlung.starten();
        this.icmpVermittlung.starten();
        this.tcp.starten();
        this.udp.starten();
        this.printDebugInfo();
        for (Anwendung anwendung : this.installierteAnwendung.values()) {
            if (anwendung == null) continue;
            anwendung.starten();
        }
    }

    public Resolver holeDNSClient() {
        return this.dnsclient;
    }

    public TCP holeTcp() {
        return this.tcp;
    }

    public UDP holeUdp() {
        return this.udp;
    }

    public ARP holeARP() {
        return this.arpVermittlung;
    }

    public ICMP holeICMP() {
        return this.icmpVermittlung;
    }

    public IP holeIP() {
        return this.vermittlung;
    }

    public Ethernet holeEthernet() {
        return this.ethernet;
    }

    public Dateisystem getDateisystem() {
        return this.dateisystem;
    }

    public void setDateisystem(Dateisystem dateisystem) {
        this.dateisystem = dateisystem;
    }

    public abstract RIPTable getRIPTable();

    public abstract boolean isRipEnabled();

    public void setInstallierteAnwendungen(HashMap<String, Anwendung> anwendungen) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), setInstallierteAnwendungen()");
        this.installierteAnwendung = anwendungen;
    }

    private void printInstallierteAnwendungen() {
        Iterator<Map.Entry<String, Anwendung>> it = this.installierteAnwendung.entrySet().iterator();
        Main.debug.println("\tInternetKnotenBetriebssystem: installierte Anwendungen:");
        while (it.hasNext()) {
            Main.debug.println("\t  - " + it.next().getKey().toString());
        }
        Main.debug.println("\t  ges: " + this.installierteAnwendung.toString());
    }

    public HashMap<String, Anwendung> getInstallierteAnwendungen() {
        return this.installierteAnwendung;
    }

    public Anwendung holeSoftware(String anwendungsklasse) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), holeSoftware(" + anwendungsklasse + ")");
        if (anwendungsklasse == null) {
            return null;
        }
        Anwendung anwendung = this.installierteAnwendung.get(anwendungsklasse);
        if (anwendung == null) {
            return null;
        }
        return anwendung;
    }

    public boolean entferneSoftware(String awKlasse) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), entferneSoftware(" + awKlasse + ")");
        this.printInstallierteAnwendungen();
        boolean entfernt = false;
        Iterator<Map.Entry<String, Anwendung>> it = this.installierteAnwendung.entrySet().iterator();
        while (it.hasNext() && !entfernt) {
            if (!awKlasse.equals(it.next().getKey())) continue;
            it.remove();
            entfernt = true;
        }
        return entfernt;
    }

    public boolean installiereSoftware(String klassenname) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), installiereSoftware(" + klassenname + ")");
        this.printInstallierteAnwendungen();
        Anwendung neueAnwendung = null;
        boolean erfolg = false;
        List<Map<String, String>> liste = null;
        if (this.holeSoftware(klassenname) != null) {
            return false;
        }
        try {
            liste = Information.getInformation().ladeProgrammListe();
        }
        catch (Exception e) {
            e.printStackTrace(Main.debug);
            return false;
        }
        ListIterator<Map<String, String>> it = liste.listIterator();
        while (it.hasNext() && !erfolg) {
            Map<String, String> tmpMap = it.next();
            if (!klassenname.equals(tmpMap.get("Klasse"))) continue;
            try {
                Class<?> cl = Class.forName(klassenname, true, FiliusClassLoader.getInstance(Thread.currentThread().getContextClassLoader()));
                try {
                    neueAnwendung = (Anwendung)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
                    neueAnwendung.setSystemSoftware(this);
                }
                catch (Exception e) {
                    e.printStackTrace(Main.debug);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace(Main.debug);
            }
            if (neueAnwendung == null) continue;
            this.installierteAnwendung.put(klassenname, neueAnwendung);
            erfolg = true;
        }
        return erfolg;
    }

    public boolean deinstalliereAnwendung(String anwendungsName) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), deinstalliereAnwendung(" + anwendungsName + ")");
        this.printInstallierteAnwendungen();
        if (anwendungsName == null) {
            return false;
        }
        Anwendung anwendung = this.installierteAnwendung.get(anwendungsName);
        if (anwendung == null) {
            return false;
        }
        this.installierteAnwendung.remove(anwendung.holeAnwendungsName());
        return true;
    }

    public Anwendung[] holeArrayInstallierteSoftware() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), holeArrayInstallierteSoftware()");
        Iterator<Map.Entry<String, Anwendung>> it = this.installierteAnwendung.entrySet().iterator();
        Anwendung[] anwendungen = new Anwendung[this.installierteAnwendung.size()];
        for (int i = 0; it.hasNext() && i < anwendungen.length; ++i) {
            anwendungen[i] = it.next().getValue();
        }
        return anwendungen;
    }

    public Weiterleitungstabelle getWeiterleitungstabelle() {
        return this.weiterleitungstabelle;
    }

    public Route determineRoute(String ipAddress) throws RouteNotFoundException {
        return this.weiterleitungstabelle.holeWeiterleitungsEintrag(ipAddress);
    }

    public void setWeiterleitungstabelle(Weiterleitungstabelle tabelle) {
        this.weiterleitungstabelle = tabelle;
    }

    public String getStandardGateway() {
        InternetKnoten knoten;
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), getStandardGateway()");
        if (this.getKnoten() instanceof InternetKnoten && (knoten = (InternetKnoten)this.getKnoten()).getNetzwerkInterfaces().size() > 0) {
            NetzwerkInterface nic = knoten.getNetzwerkInterfaces().get(0);
            return nic.getGateway();
        }
        return null;
    }

    public void setStandardGateway(String gateway) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), setStandardGateway(" + gateway + ")");
        String string = gateway = gateway != null && gateway.trim().equals("") ? gateway.trim() : IP.ipCheck(gateway);
        if (gateway != null && EingabenUeberpruefung.isGueltig(gateway, EingabenUeberpruefung.musterIpAdresseAuchLeer) && this.getKnoten() instanceof InternetKnoten) {
            InternetKnoten knoten = (InternetKnoten)this.getKnoten();
            ListIterator<NetzwerkInterface> it = knoten.getNetzwerkInterfaces().listIterator();
            while (it.hasNext()) {
                NetzwerkInterface nic = (NetzwerkInterface)it.next();
                nic.setGateway(gateway);
            }
        }
    }

    public void setzeIPAdresse(String ip) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), setzeIPAdresse(" + ip + ")");
        ip = IP.ipCheck(ip);
        if (ip != null && EingabenUeberpruefung.isGueltig(ip, EingabenUeberpruefung.musterIpAdresse) && this.getKnoten() instanceof InternetKnoten) {
            InternetKnoten knoten = (InternetKnoten)this.getKnoten();
            knoten.getNetzwerkInterfaces().get(0).setIp(ip);
        }
    }

    public String holeIPAdresse() {
        NetzwerkInterface nic;
        if (!(this.getKnoten() instanceof InternetKnoten)) {
            return null;
        }
        InternetKnoten knoten = (InternetKnoten)this.getKnoten();
        String ip = null;
        ListIterator<NetzwerkInterface> it = knoten.getNetzwerkInterfaces().listIterator();
        while (it.hasNext() && ((ip = (nic = it.next()).getIp()).startsWith("10.") || ip.startsWith("192.168.") || ip.startsWith("0.") || ip.startsWith("127."))) {
        }
        return ip;
    }

    public String holeMACAdresse() {
        InternetKnoten knoten;
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), holeMACAdresse()");
        if (this.getKnoten() instanceof InternetKnoten && (knoten = (InternetKnoten)this.getKnoten()).getNetzwerkInterfaces().size() > 0) {
            NetzwerkInterface nic = knoten.getNetzwerkInterfaces().get(0);
            return nic.getMac();
        }
        return null;
    }

    public String getDNSServer() {
        InternetKnoten knoten;
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), getDNSServer()");
        if (this.getKnoten() instanceof InternetKnoten && (knoten = (InternetKnoten)this.getKnoten()).getNetzwerkInterfaces().size() > 0) {
            NetzwerkInterface nic = knoten.getNetzwerkInterfaces().get(0);
            return nic.getDns();
        }
        return null;
    }

    public void setDNSServer(String dns) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), setDNSServer(" + dns + ")");
        String string = dns = dns != null && dns.trim().equals("") ? dns.trim() : IP.ipCheck(dns);
        if (dns != null && EingabenUeberpruefung.isGueltig(dns, EingabenUeberpruefung.musterIpAdresseAuchLeer) && this.getKnoten() instanceof InternetKnoten) {
            InternetKnoten knoten = (InternetKnoten)this.getKnoten();
            ListIterator<NetzwerkInterface> it = knoten.getNetzwerkInterfaces().listIterator();
            while (it.hasNext()) {
                NetzwerkInterface nic = (NetzwerkInterface)it.next();
                nic.setDns(dns);
            }
        }
    }

    public void setzeNetzmaske(String mask) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), setzeNetzmaske(" + mask + ")");
        mask = IP.ipCheck(mask);
        if (mask != null && EingabenUeberpruefung.isGueltig(mask, EingabenUeberpruefung.musterSubNetz) && this.getKnoten() instanceof InternetKnoten) {
            InternetKnoten knoten = (InternetKnoten)this.getKnoten();
            knoten.getNetzwerkInterfaces().get(0).setSubnetzMaske(mask);
        }
    }

    public String holeNetzmaske() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnotenBetriebssystem), holeNetzmaske()");
        if (this.getKnoten() instanceof InternetKnoten) {
            InternetKnoten knoten = (InternetKnoten)this.getKnoten();
            return knoten.getNetzwerkInterfaces().get(0).getSubnetzMaske();
        }
        return null;
    }
}

