/*
 * Decompiled with CFR 0.152.
 */
package filius.software.rip;

import filius.software.rip.RIPUtil;
import filius.software.vermittlungsschicht.Route;

public class RIPRoute
extends Route {
    public long expires;
    public long created = RIPUtil.getTime();
    public int hops;
    public String hopPublicIp;

    public RIPRoute(int timeout, String netAddr, String netMask, String nextHop, String hopPublicIp, String nic, int hops) {
        super(netAddr, netMask, nextHop, nic);
        this.refresh(timeout);
        this.hopPublicIp = hopPublicIp;
        this.hops = hops;
    }

    public void refresh(int timeout) {
        this.expires = timeout > 0 ? RIPUtil.getTime() + (long)timeout : 0L;
    }

    public boolean isExpired() {
        return this.expires > 0L && this.expires < RIPUtil.getTime();
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public void setInterfaceIpAddress(String interfaceIpAddress) {
        this.interfaceIpAddress = interfaceIpAddress;
    }
}

