/*
 * Decompiled with CFR 0.152.
 */
package filius.software.netzzugangsschicht;

import filius.Main;
import filius.hardware.knoten.Modem;
import filius.software.ProtokollThread;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.system.ModemFirmware;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.LinkedList;

public class ModemEmpfaenger
extends ProtokollThread {
    private ModemFirmware firmware;
    private InputStream in;

    public ModemEmpfaenger(ModemFirmware firmware, InputStream in) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ModemAnschlussBeobachterExtern), constr: ModemAnschlussBeobachterExtern(" + firmware + "," + in + ")");
        this.firmware = firmware;
        this.in = in;
    }

    @Override
    public void run() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ModemAnschlussBeobachterExtern), run()");
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(this.in);
        }
        catch (IOException e) {
            e.printStackTrace(Main.debug);
        }
        while (this.running) {
            try {
                Object object = in.readObject();
                this.verarbeiteDatenEinheit(object);
            }
            catch (Exception e) {
                e.printStackTrace(Main.debug);
                if (!this.running) continue;
                this.firmware.verbindungZuruecksetzen();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void verarbeiteDatenEinheit(Object datenEinheit) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ModemAnschlussBeobachterExtern), verarbeiteDatenEinheit(" + datenEinheit.toString() + ")");
        if (this.firmware.isStarted()) {
            EthernetFrame frame = (EthernetFrame)datenEinheit;
            LinkedList<EthernetFrame> linkedList = ((Modem)this.firmware.getKnoten()).getErstenAnschluss().holeAusgangsPuffer();
            synchronized (linkedList) {
                ((Modem)this.firmware.getKnoten()).getErstenAnschluss().holeAusgangsPuffer().add(frame);
                ((Modem)this.firmware.getKnoten()).getErstenAnschluss().holeAusgangsPuffer().notify();
            }
        }
    }

    @Override
    public void starten() {
        super.starten();
    }

    @Override
    public void beenden() {
        super.beenden();
    }
}

