/*
 * Decompiled with CFR 0.152.
 */
package filius.software.netzzugangsschicht;

import filius.Main;
import filius.hardware.NetzwerkInterface;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.software.ProtokollThread;
import filius.software.netzzugangsschicht.Ethernet;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.vermittlungsschicht.ArpPaket;
import filius.software.vermittlungsschicht.IcmpPaket;
import filius.software.vermittlungsschicht.IpPaket;
import java.util.LinkedList;

public class EthernetThread
extends ProtokollThread {
    private NetzwerkInterface netzwerkInterface;
    private Ethernet ethernet;

    public EthernetThread(Ethernet ethernet, NetzwerkInterface nic) {
        super(nic.getPort().holeEingangsPuffer());
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (EthernetThread), constr: EthernetThread(" + ethernet + "," + nic + ")");
        this.ethernet = ethernet;
        this.netzwerkInterface = nic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void verarbeiteDatenEinheit(Object datenEinheit) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (EthernetThread), verarbeiteDateneinheit(" + datenEinheit.toString() + ")");
        EthernetFrame etp = (EthernetFrame)datenEinheit;
        Lauscher.getLauscher().addDatenEinheit(this.netzwerkInterface.getMac(), etp);
        if (!etp.getZielMacAdresse().equalsIgnoreCase("FF:FF:FF:FF:FF:FF") && !etp.getZielMacAdresse().equals(this.netzwerkInterface.getMac())) {
            return;
        }
        if (etp.getTyp().equals("0x800")) {
            if (etp.isICMP()) {
                LinkedList<IcmpPaket> linkedList = this.ethernet.holeICMPPuffer();
                synchronized (linkedList) {
                    this.ethernet.holeICMPPuffer().add((IcmpPaket)etp.getDaten());
                    this.ethernet.holeICMPPuffer().notifyAll();
                }
            } else {
                LinkedList<IpPaket> linkedList = this.ethernet.holeIPPuffer();
                synchronized (linkedList) {
                    this.ethernet.holeIPPuffer().add((IpPaket)etp.getDaten());
                    this.ethernet.holeIPPuffer().notify();
                }
            }
        } else if (etp.getTyp().equals("0x806")) {
            String zielIp = ((ArpPaket)etp.getDaten()).getZielIp();
            if (!zielIp.equals(this.netzwerkInterface.getIp()) && !"0.0.0.0".equals(this.netzwerkInterface.getIp())) {
                Main.debug.println("ERROR (" + this.hashCode() + "):  ARP packet seems to be sent from a NIC (" + ((ArpPaket)etp.getDaten()).getQuellIp() + "," + ((ArpPaket)etp.getDaten()).getQuellMacAdresse() + ") not connected to the currently considered NIC (" + this.netzwerkInterface.getIp() + "," + this.netzwerkInterface.getMac() + ")");
                return;
            }
            LinkedList<ArpPaket> linkedList = this.ethernet.holeARPPuffer();
            synchronized (linkedList) {
                this.ethernet.holeARPPuffer().add((ArpPaket)etp.getDaten());
                this.ethernet.holeARPPuffer().notify();
            }
        } else {
            Main.debug.println("ERROR (" + this.hashCode() + "): Paket konnte nicht zugeordnet werden");
        }
    }
}

