/*
 * Decompiled with CFR 0.152.
 */
package filius.software.firewall;

import filius.hardware.NetzwerkInterface;
import filius.rahmenprogramm.I18n;
import filius.software.vermittlungsschicht.VermittlungsProtokoll;
import java.util.List;
import java.util.Vector;

public class FirewallRule
implements I18n {
    public static String SAME_NETWORK = "999.999.999.999";
    public static final short ALL_PROTOCOLS = -1;
    public static final short ICMP = 1;
    public static final short TCP = 6;
    public static final short UDP = 17;
    public static final int ALL_PORTS = -1;
    public static final short DROP = 0;
    public static final short ACCEPT = 1;
    public String srcIP = "";
    public String srcMask = "";
    public String destIP = "";
    public String destMask = "";
    public int port = -1;
    public short protocol = (short)6;
    public short action = 0;

    public FirewallRule(String srcIP, String srcMask, String destIP, String destMask, int port, short protocol, short action) {
        this.srcIP = srcIP;
        this.srcMask = srcMask;
        this.destIP = destIP;
        this.destMask = destMask;
        this.port = port;
        this.protocol = protocol;
        this.action = action;
    }

    public FirewallRule() {
    }

    public Vector<String> getVector(int id) {
        Vector<String> resultVec = new Vector<String>();
        resultVec.addElement(Integer.toString(id));
        resultVec.addElement(this.srcIP);
        resultVec.addElement(this.srcMask);
        resultVec.addElement(this.destIP);
        resultVec.addElement(this.destMask);
        if (this.protocol == 6) {
            resultVec.addElement("TCP");
        } else if (this.protocol == 17) {
            resultVec.addElement("UDP");
        } else if (this.protocol == 1) {
            resultVec.addElement("ICMP");
        } else {
            resultVec.addElement("");
        }
        if (this.port >= 0) {
            resultVec.addElement(Integer.toString(this.port));
        } else {
            resultVec.addElement("");
        }
        if (this.action == 1) {
            resultVec.addElement(messages.getString("jfirewalldialog_msg33"));
        } else if (this.action == 0) {
            resultVec.addElement(messages.getString("jfirewalldialog_msg34"));
        } else {
            resultVec.addElement("");
        }
        return resultVec;
    }

    public Vector<String> getVectorPFW() {
        Vector<String> resultVec = new Vector<String>();
        if (this.port >= 0) {
            resultVec.addElement(Integer.toString(this.port));
        } else {
            resultVec.addElement("");
        }
        if (this.srcIP.equals(SAME_NETWORK)) {
            resultVec.addElement(messages.getString("firewall_msg12"));
        } else {
            resultVec.addElement(messages.getString("firewall_msg4"));
        }
        return resultVec;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(List<NetzwerkInterface> nics) {
        String ip = null;
        String mask = null;
        String result = "";
        boolean sameNet = false;
        if (nics != null) {
            ip = nics.get(0).getIp();
            mask = nics.get(0).getSubnetzMaske();
            if (this.srcIP.equals(SAME_NETWORK) && ip != null && mask != null) {
                sameNet = true;
            }
        }
        result = this.srcIP.isEmpty() ? result + "*/" : (sameNet ? result + VermittlungsProtokoll.getSubnetForIp(ip, mask) + "/" + mask + " -> " : result + this.srcIP + "/");
        if (!sameNet) {
            result = this.srcMask.isEmpty() ? result + "* -> " : result + this.srcMask + " -> ";
        }
        result = this.destIP.isEmpty() ? result + "*/" : result + this.destIP + "/";
        result = this.destMask.isEmpty() ? result + "*; " : result + this.destMask + "; ";
        result = this.protocol >= 0 ? (this.protocol == 6 ? result + "TCP:" : (this.protocol == 17 ? result + "UDP:" : result + "?:")) : result + "*:";
        result = this.port >= 0 ? result + this.port + "  => " : result + "*  => ";
        result = this.action == 1 ? result + "ACCEPT" : (this.action == 0 ? result + "DROP" : result + this.action);
        return result;
    }
}

