/*
 * Decompiled with CFR 0.152.
 */
package filius.software.email;

import java.io.Serializable;

public class AddressEntry
implements Serializable {
    private String name;
    private String mailAddress;

    public AddressEntry() {
    }

    public AddressEntry(String entry) {
        this.initFromString(entry);
    }

    private void initFromString(String entry) {
        String trimmedEntry = entry.trim();
        int addressStartPos = trimmedEntry.indexOf("<");
        int addressEndPos = trimmedEntry.indexOf(">");
        if (addressStartPos >= 0 && addressEndPos > addressStartPos) {
            this.mailAddress = trimmedEntry.substring(addressStartPos + 1, addressEndPos).trim();
            if (addressStartPos > 0) {
                this.name = trimmedEntry.substring(0, addressStartPos).trim();
            }
        } else if (!trimmedEntry.contains("<") && !trimmedEntry.contains(">") && trimmedEntry.contains("@")) {
            this.mailAddress = trimmedEntry;
        } else {
            this.name = trimmedEntry;
        }
    }

    public AddressEntry(Object address) {
        if (address instanceof String) {
            this.initFromString((String)address);
        } else if (address instanceof AddressEntry) {
            AddressEntry addressEntry = (AddressEntry)address;
            this.name = addressEntry.name;
            this.mailAddress = addressEntry.mailAddress;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMailAddress() {
        return this.mailAddress;
    }

    public void setMailAddress(String mailAddress) {
        this.mailAddress = mailAddress;
    }

    public String toString() {
        if (this.name == null && this.mailAddress == null) {
            return null;
        }
        if (this.name == null) {
            return "<" + this.mailAddress + ">";
        }
        if (this.mailAddress == null) {
            return this.name;
        }
        return this.name + " <" + this.mailAddress + ">";
    }
}

