/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dns;

import filius.Main;
import filius.exception.VerbindungsException;
import filius.hardware.Verbindung;
import filius.software.clientserver.ClientAnwendung;
import filius.software.dns.DNSNachricht;
import filius.software.dns.ResourceRecord;
import filius.software.transportschicht.UDPSocket;
import filius.software.vermittlungsschicht.IP;
import java.util.LinkedList;
import java.util.concurrent.TimeoutException;

public class Resolver
extends ClientAnwendung {
    private DNSNachricht holeResourceRecord(String typ, String domainname, String dnsServer) throws TimeoutException {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Resolver), holeResourceRecord(" + typ + "," + domainname + ")");
        DNSNachricht antwort = null;
        UDPSocket socket = null;
        if (dnsServer != null && !dnsServer.equals("")) {
            if (socket == null) {
                try {
                    socket = new UDPSocket(this.getSystemSoftware(), dnsServer, 53);
                    if (!domainname.matches(".*\\.$")) {
                        domainname = domainname + ".";
                    }
                    DNSNachricht anfrage = new DNSNachricht(0);
                    anfrage.hinzuQuery(domainname + " " + typ + " IN");
                    socket.verbinden();
                    socket.senden(anfrage.toString());
                    String tmp = socket.empfangen(10 * Verbindung.holeRTT());
                    if (tmp == null) {
                        Main.debug.println("ERROR (" + this.hashCode() + "): keine Antwort auf Query empfangen");
                        throw new TimeoutException();
                    }
                    antwort = new DNSNachricht(tmp);
                    if (antwort.getId() != anfrage.getId()) {
                        return null;
                    }
                    socket.schliessen();
                    socket = null;
                }
                catch (VerbindungsException e) {
                    e.printStackTrace(Main.debug);
                    return null;
                }
            }
        } else {
            return null;
        }
        return antwort;
    }

    public String holeIPAdresse(String domainname) throws TimeoutException {
        return this.holeIPAdresse(domainname, this.getSystemSoftware().getDNSServer());
    }

    public String holeIPAdresse(String domainname, String dnsServer) throws TimeoutException {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Resolver), holeIPAdresse(" + domainname + ")");
        if (domainname.equalsIgnoreCase("localhost")) {
            return "127.0.0.1";
        }
        String adresse = IP.ipCheck(domainname);
        if (adresse != null) {
            return adresse;
        }
        if (!domainname.matches(".*\\.$")) {
            domainname = domainname + ".";
        }
        while (dnsServer != null) {
            DNSNachricht antwort = this.holeResourceRecord("A", domainname, dnsServer);
            if (antwort == null) {
                return null;
            }
            adresse = this.durchsucheRecordListe("A", domainname, antwort.holeAntwortResourceRecords());
            if (adresse != null) {
                return adresse;
            }
            adresse = this.durchsucheRecordListe("A", domainname, antwort.holeAuthoritativeResourceRecords());
            if (adresse != null) {
                return adresse;
            }
            adresse = this.durchsucheRecordListe("A", domainname, antwort.holeZusatzResourceRecords());
            if (adresse != null) {
                return adresse;
            }
            String dnsServerDomain = this.durchsucheRecordListe("NS", antwort.holeAntwortResourceRecords());
            if (dnsServerDomain != null && !dnsServerDomain.matches(".*\\.$")) {
                dnsServerDomain = dnsServerDomain + ".";
            }
            dnsServer = this.durchsucheRecordListe("A", dnsServerDomain, antwort.holeAntwortResourceRecords());
        }
        return null;
    }

    public String holeIPAdresseMailServer(String domainname) throws TimeoutException {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Resolver), holeIPAdressMailServer(" + domainname + ")");
        DNSNachricht antwort = null;
        String mailserver = null;
        String dnsServer = this.getSystemSoftware().getDNSServer();
        if (!domainname.matches(".*\\.$")) {
            domainname = domainname + ".";
        }
        while (dnsServer != null && mailserver == null) {
            antwort = this.holeResourceRecord("MX", domainname, dnsServer);
            if (antwort == null) {
                return null;
            }
            mailserver = this.durchsucheRecordListe("MX", domainname, antwort.holeAntwortResourceRecords());
            if (mailserver == null) {
                mailserver = this.durchsucheRecordListe("MX", domainname, antwort.holeAntwortResourceRecords());
            }
            if (mailserver == null) {
                mailserver = this.durchsucheRecordListe("MX", domainname, antwort.holeAntwortResourceRecords());
            }
            String dnsServerDomain = this.durchsucheRecordListe("NS", antwort.holeAntwortResourceRecords());
            dnsServer = this.durchsucheRecordListe("A", dnsServerDomain, antwort.holeAntwortResourceRecords());
        }
        if (mailserver == null) {
            return null;
        }
        String adresse = this.durchsucheRecordListe("A", mailserver, antwort.holeAntwortResourceRecords());
        if (adresse != null) {
            return adresse;
        }
        adresse = this.durchsucheRecordListe("A", mailserver, antwort.holeAuthoritativeResourceRecords());
        if (adresse != null) {
            return adresse;
        }
        adresse = this.durchsucheRecordListe("A", mailserver, antwort.holeZusatzResourceRecords());
        if (adresse != null) {
            return adresse;
        }
        return this.holeIPAdresse(mailserver);
    }

    private String durchsucheRecordListe(String typ, LinkedList<ResourceRecord> liste) {
        for (ResourceRecord rr : liste) {
            if (!rr.getType().equals(typ)) continue;
            return rr.getRdata();
        }
        return null;
    }

    private String durchsucheRecordListe(String typ, String domainname, LinkedList<ResourceRecord> liste) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Resolver), durchsucheRecordListe(" + typ + "," + domainname + "," + liste + ")");
        for (ResourceRecord rr : liste) {
            if (!rr.getDomainname().equalsIgnoreCase(domainname) || !rr.getType().equals(typ)) continue;
            return rr.getRdata();
        }
        return null;
    }
}

