/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dhcp;

import filius.Main;
import filius.exception.AddressRequestNotAcceptedException;
import filius.exception.NoAvailableAddressException;
import filius.hardware.Verbindung;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.software.clientserver.UDPServerAnwendung;
import filius.software.dhcp.DHCPAddressAssignment;
import filius.software.dhcp.DHCPServerMitarbeiter;
import filius.software.transportschicht.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class DHCPServer
extends UDPServerAnwendung {
    private static final String DEFAULT_IP_ADDRESS = "0.0.0.0";
    private static final long DEFAULT_LEASE_TIME_MILLIS = 86400000L;
    private static final int DHCP_SERVER_PORT = 67;
    private String untergrenze = "0.0.0.0";
    private String obergrenze = "0.0.0.0";
    private String dhcpGateway = "0.0.0.0";
    private String dhcpDNS = "0.0.0.0";
    private boolean useDhcpSettings = false;
    String lastOfferedAddress = null;
    List<DHCPAddressAssignment> dynamicAssignedAddresses = new ArrayList<DHCPAddressAssignment>();
    List<DHCPAddressAssignment> staticAssignedAddresses = new ArrayList<DHCPAddressAssignment>();
    List<DHCPAddressAssignment> offeredAddresses = new ArrayList<DHCPAddressAssignment>();
    List<DHCPAddressAssignment> blacklist = new ArrayList<DHCPAddressAssignment>();

    public DHCPServer() {
        this.port = 67;
    }

    String nextAddress() {
        long upperLimit;
        long address;
        String nextAddress = StringUtils.isBlank(this.lastOfferedAddress) ? this.untergrenze : ((address = DHCPServer.ipToLong(this.lastOfferedAddress) + 1L) <= (upperLimit = DHCPServer.ipToLong(this.obergrenze)) ? DHCPServer.longToIp(address) : this.untergrenze);
        this.lastOfferedAddress = nextAddress;
        return nextAddress;
    }

    public synchronized String offerAddress(String mac) throws NoAvailableAddressException {
        String addressToOffer = this.findStaticOffer(mac);
        if (addressToOffer == null) {
            addressToOffer = this.findDynamicOffer(mac);
        }
        return addressToOffer;
    }

    private String findDynamicOffer(String mac) throws NoAvailableAddressException {
        String addressToOffer;
        String firstOffer = addressToOffer = this.nextAddress();
        while (!this.checkAddressAvailable(addressToOffer)) {
            addressToOffer = this.nextAddress();
            if (!StringUtils.equals(firstOffer, addressToOffer)) continue;
            throw new NoAvailableAddressException();
        }
        long leaseTime = System.currentTimeMillis() + (long)(4 * Verbindung.holeRTT());
        this.offeredAddresses.add(new DHCPAddressAssignment(mac, addressToOffer, leaseTime));
        return addressToOffer;
    }

    private String findStaticOffer(String mac) {
        String addressToOffer = null;
        for (DHCPAddressAssignment entry : this.staticAssignedAddresses) {
            if (!StringUtils.equalsIgnoreCase(mac, entry.getMAC())) continue;
            addressToOffer = entry.getIp();
            break;
        }
        return addressToOffer;
    }

    public synchronized void blacklistAddress(String ip) {
        long leaseTime = System.currentTimeMillis() + (long)(4 * Verbindung.holeRTT());
        this.blacklist.add(new DHCPAddressAssignment("", ip, leaseTime));
    }

    public synchronized DHCPAddressAssignment requestAddress(String mac, String ip) throws AddressRequestNotAcceptedException {
        if (this.assignmentListContains(this.blacklist, ip)) {
            throw new AddressRequestNotAcceptedException();
        }
        DHCPAddressAssignment assignment = this.requestStaticAssignment(mac, ip);
        if (assignment == null) {
            assignment = this.requestDynamicAssignment(mac, ip);
        }
        return assignment;
    }

    private DHCPAddressAssignment requestStaticAssignment(String mac, String ip) {
        DHCPAddressAssignment assignment = null;
        for (DHCPAddressAssignment entry : this.staticAssignedAddresses) {
            if (!StringUtils.equalsIgnoreCase(mac, entry.getMAC()) || !StringUtils.equalsIgnoreCase(ip, entry.getIp())) continue;
            assignment = entry;
            break;
        }
        return assignment;
    }

    private DHCPAddressAssignment requestDynamicAssignment(String mac, String ip) throws AddressRequestNotAcceptedException {
        boolean success = false;
        for (DHCPAddressAssignment assignment : this.offeredAddresses) {
            if (!StringUtils.equalsIgnoreCase(ip, assignment.getIp())) continue;
            if (StringUtils.equalsIgnoreCase(mac, assignment.getMAC())) {
                success = true;
                this.offeredAddresses.remove(assignment);
                break;
            }
            success = false;
            break;
        }
        if (!success && this.checkAddressAvailable(ip)) {
            success = true;
        }
        if (!success) {
            throw new AddressRequestNotAcceptedException();
        }
        DHCPAddressAssignment assignment = new DHCPAddressAssignment(mac, ip, System.currentTimeMillis() + 86400000L);
        this.dynamicAssignedAddresses.add(assignment);
        return assignment;
    }

    public String holeServerIpAddress() {
        return this.getSystemSoftware().holeIPAdresse();
    }

    synchronized boolean checkAddressAvailable(String ip) {
        this.cleanUpAssignments();
        boolean available = true;
        if (this.assignmentListContains(this.dynamicAssignedAddresses, ip)) {
            available = false;
        } else if (this.assignmentListContains(this.staticAssignedAddresses, ip)) {
            available = false;
        } else if (this.assignmentListContains(this.offeredAddresses, ip)) {
            available = false;
        } else if (this.assignmentListContains(this.blacklist, ip)) {
            available = false;
        }
        return available;
    }

    private boolean assignmentListContains(List<DHCPAddressAssignment> assignmentList, String ip) {
        boolean contains = false;
        for (DHCPAddressAssignment assignment : assignmentList) {
            if (!assignment.getIp().equalsIgnoreCase(ip)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public void setOwnSettings(boolean val) {
        this.useDhcpSettings = val;
    }

    synchronized void cleanUpAssignments() {
        this.cleanUpAssignmentList(this.dynamicAssignedAddresses);
        this.cleanUpAssignmentList(this.staticAssignedAddresses);
        this.cleanUpAssignmentList(this.offeredAddresses);
        this.cleanUpAssignmentList(this.blacklist);
    }

    private void cleanUpAssignmentList(List<DHCPAddressAssignment> assignments) {
        LinkedList<DHCPAddressAssignment> expiredAssignments = new LinkedList<DHCPAddressAssignment>();
        for (DHCPAddressAssignment assignment : assignments) {
            if (!assignment.isExpired()) continue;
            expiredAssignments.add(assignment);
        }
        for (DHCPAddressAssignment expired : expiredAssignments) {
            assignments.remove(expired);
        }
    }

    @Override
    public void starten() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DHCPServer), starten()");
        this.dynamicAssignedAddresses.clear();
        this.lastOfferedAddress = null;
        super.starten();
    }

    @Override
    protected void neuerMitarbeiter(Socket socket) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DHCPServer), neuerMitarbeiter(" + socket + ")");
        DHCPServerMitarbeiter dhcpMitarbeiter = new DHCPServerMitarbeiter(this, socket);
        dhcpMitarbeiter.starten();
        this.mitarbeiter.add(dhcpMitarbeiter);
    }

    public boolean isOwnSettings() {
        return this.useDhcpSettings;
    }

    boolean inRange(String ipAddress) {
        long lowerLimit = DHCPServer.ipToLong(this.untergrenze);
        long upperLimit = DHCPServer.ipToLong(this.obergrenze);
        long ip = DHCPServer.ipToLong(ipAddress);
        return ip <= upperLimit && ip >= lowerLimit;
    }

    static int[] ipToIntArray(String ipAddress) {
        if (!EingabenUeberpruefung.isGueltig(ipAddress, EingabenUeberpruefung.musterIpAdresse)) {
            throw new NumberFormatException("Not a valid IP address");
        }
        int[] ipAsArray = new int[4];
        StringTokenizer tokenizer = new StringTokenizer(ipAddress, ".");
        for (int i = 0; i < ipAsArray.length; ++i) {
            ipAsArray[i] = Integer.parseInt(tokenizer.nextToken());
        }
        return ipAsArray;
    }

    static long ipToLong(String ipAddress) {
        int[] ipIntArray = DHCPServer.ipToIntArray(ipAddress);
        long number = 0L;
        for (int value : ipIntArray) {
            number = 256L * number + (long)value;
        }
        return number;
    }

    static String longToIp(long ipAsLong) {
        long firstByte = (ipAsLong & 0xFFFFFFFFFF000000L) >> 24;
        long secondByte = (ipAsLong & 0xFF0000L) >> 16;
        long thirdByte = (ipAsLong & 0xFF00L) >> 8;
        long fourthByte = ipAsLong & 0xFFL;
        return String.format("%d.%d.%d.%d", firstByte, secondByte, thirdByte, fourthByte);
    }

    public String getObergrenze() {
        return this.obergrenze;
    }

    public void setObergrenze(String obergrenze) {
        this.obergrenze = obergrenze;
    }

    public String getUntergrenze() {
        return this.untergrenze;
    }

    public void setUntergrenze(String untergrenze) {
        this.untergrenze = untergrenze;
    }

    public String getDnsserverip() {
        return this.dhcpDNS;
    }

    public String determineDnsserverip() {
        String dns;
        if (this.useDhcpSettings) {
            dns = this.dhcpDNS;
        } else {
            dns = this.getSystemSoftware().getDNSServer();
            if (StringUtils.isEmpty(dns)) {
                dns = DEFAULT_IP_ADDRESS;
            }
        }
        return dns;
    }

    public void setDnsserverip(String ip) {
        this.dhcpDNS = ip;
    }

    public String getGatewayip() {
        return this.dhcpGateway;
    }

    public String determineGatewayip() {
        String gateway;
        if (this.useDhcpSettings) {
            gateway = this.dhcpGateway;
        } else {
            gateway = this.getSystemSoftware().getStandardGateway();
            if (StringUtils.isEmpty(gateway)) {
                gateway = DEFAULT_IP_ADDRESS;
            }
        }
        return gateway;
    }

    public void setGatewayip(String ip) {
        this.dhcpGateway = ip;
    }

    public String getSubnetzmaske() {
        return this.getSystemSoftware().holeNetzmaske();
    }

    public List<DHCPAddressAssignment> holeStaticAssignedAddresses() {
        return Collections.unmodifiableList(this.staticAssignedAddresses);
    }

    public List<String> getStaticAssignedAddresses() {
        ArrayList<String> entries = new ArrayList<String>();
        for (DHCPAddressAssignment entry : this.staticAssignedAddresses) {
            entries.add(String.format("%s %s", entry.getMAC(), entry.getIp()));
        }
        return entries;
    }

    public void setStaticAssignedAddresses(List<String> assignedAddresses) {
        this.staticAssignedAddresses.clear();
        for (String entry : assignedAddresses) {
            String[] pair = StringUtils.split(entry);
            this.staticAssignedAddresses.add(new DHCPAddressAssignment(pair[0], pair[1], 0L));
        }
    }

    public void addStaticAssignment(String mac, String ip) {
        boolean alreadyExisting = false;
        for (DHCPAddressAssignment entry : this.staticAssignedAddresses) {
            if (!StringUtils.equalsIgnoreCase(entry.getMAC(), mac)) continue;
            alreadyExisting = true;
            break;
        }
        if (!alreadyExisting && EingabenUeberpruefung.isGueltig(mac, EingabenUeberpruefung.musterMacAddress) && EingabenUeberpruefung.isGueltig(ip, EingabenUeberpruefung.musterIpAdresse)) {
            this.staticAssignedAddresses.add(new DHCPAddressAssignment(mac, ip, 0L));
        }
    }

    public void clearStaticAssignments() {
        this.staticAssignedAddresses.clear();
    }
}

