/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dateiaustausch;

import filius.Main;
import filius.software.clientserver.ServerMitarbeiter;
import filius.software.dateiaustausch.PeerToPeerAnwendung;
import filius.software.dateiaustausch.PeerToPeerPaket;
import filius.software.dateiaustausch.PeerToPeerServer;
import filius.software.dateiaustausch.PingPaket;
import filius.software.dateiaustausch.QueryHitPaket;
import filius.software.dateiaustausch.QueryPaket;
import filius.software.system.Betriebssystem;
import filius.software.system.Datei;
import filius.software.transportschicht.Socket;
import filius.software.www.HTTPNachricht;
import java.util.LinkedList;

public class PeerToPeerServerMitarbeiter
extends ServerMitarbeiter {
    private PeerToPeerAnwendung peerToPeerAnwendung;
    private int guid;

    PeerToPeerServerMitarbeiter(PeerToPeerServer server, Socket socket, PeerToPeerAnwendung peerToPeerAnwendung) {
        super(server, socket);
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerServerMitarbeiter), constr: PeerToPeerServerMitarbeiter(" + server + "," + socket + "," + peerToPeerAnwendung + ")");
        this.peerToPeerAnwendung = peerToPeerAnwendung;
    }

    void senden(String nachricht) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerServerMitarbeiter), senden(" + nachricht + ")");
        if (this.socket != null && this.socket.istVerbunden()) {
            try {
                this.socket.senden(nachricht);
            }
            catch (Exception e) {
                e.printStackTrace(Main.debug);
            }
        }
    }

    int holeGuid() {
        return this.guid;
    }

    private void httpAnfrageVerarbeiten(String nachricht) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerServerMitarbeiter), httpAnfrageVerarbeiten(" + nachricht + ")");
        HTTPNachricht http = new HTTPNachricht(nachricht);
        HTTPNachricht antwort = new HTTPNachricht(0);
        Datei datei = this.peerToPeerAnwendung.holeDatei(http.getPfad());
        if (datei != null) {
            antwort.setStatusCode(200);
            antwort.setContentType(datei.getDateiTyp());
            antwort.setDaten(datei.getDateiInhalt());
        } else {
            antwort.setStatusCode(404);
        }
        try {
            this.socket.senden(antwort.toString());
        }
        catch (Exception e) {
            e.printStackTrace(Main.debug);
        }
    }

    private void verarbeitePing(PingPaket pingPaket) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerServerMitarbeiter), verarbeitePing(" + pingPaket + ")");
        this.peerToPeerAnwendung.hinzuTeilnehmer(pingPaket.getIp());
        String pongNachricht = this.peerToPeerAnwendung.erstellePong(pingPaket).toString();
        if (pongNachricht != null) {
            try {
                this.socket.senden(pongNachricht);
            }
            catch (Exception e) {
                e.printStackTrace(Main.debug);
            }
        }
        pingPaket.setHops(pingPaket.getHops() + 1);
        pingPaket.setTtl(pingPaket.getTtl() - 1);
        this.guid = pingPaket.getGuid();
        this.peerToPeerAnwendung.sendePing(pingPaket, this.socket.holeZielIPAdresse());
    }

    private void verarbeiteQuery(QueryPaket queryPaket) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerServerMitarbeiter), verarbeiteQuery(" + queryPaket + ")");
        this.guid = queryPaket.getGuid();
        LinkedList<Datei> dateien = this.peerToPeerAnwendung.verarbeiteAnfrage(this.socket.holeZielIPAdresse(), queryPaket);
        if (dateien != null && dateien.size() > 0) {
            Betriebssystem bs = (Betriebssystem)this.peerToPeerAnwendung.getSystemSoftware();
            for (Datei aktuelleDatei : dateien) {
                QueryHitPaket antwortPaket = new QueryHitPaket(dateien.size(), 6346, bs.holeIPAdresse(), "2", "", " ");
                antwortPaket.setGuid(queryPaket.getGuid());
                antwortPaket.setHops(0);
                antwortPaket.setTtl(8);
                antwortPaket.setErgebnis(aktuelleDatei.getName() + ": " + aktuelleDatei.holeGroesse() + " B");
                try {
                    this.socket.senden(antwortPaket.toString());
                }
                catch (Exception e) {
                    e.printStackTrace(Main.debug);
                }
            }
            this.socket.schliessen();
        }
    }

    @Override
    protected void verarbeiteNachricht(String nachricht) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerServerMitarbeiter), verarbeiteNachricht(" + nachricht + ")");
        if (nachricht != null) {
            if (nachricht.startsWith("GET")) {
                this.httpAnfrageVerarbeiten(nachricht);
            } else {
                PeerToPeerPaket paket = new PeerToPeerPaket(nachricht);
                this.guid = paket.getGuid();
                if (paket.getPayload().equals("0x00")) {
                    PingPaket pingPaket = new PingPaket(nachricht);
                    this.verarbeitePing(pingPaket);
                } else if (paket.getPayload().equals("0x80")) {
                    QueryPaket queryPaket = new QueryPaket(nachricht);
                    this.verarbeiteQuery(queryPaket);
                }
            }
        }
    }
}

