/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dateiaustausch;

import filius.Main;
import filius.software.dateiaustausch.PeerToPeerAnwendung;
import filius.software.dateiaustausch.PeerToPeerPaket;
import filius.software.dateiaustausch.PingPaket;
import filius.software.dateiaustausch.PongPaket;
import filius.software.dateiaustausch.QueryHitPaket;
import filius.software.system.Datei;
import filius.software.transportschicht.TCPSocket;
import filius.software.www.HTTPNachricht;

class PeerToPeerClientMitarbeiter
extends Thread {
    private static final int PING = 1;
    private static final int QUERY = 3;
    private static final int HTTP = 4;
    private PeerToPeerAnwendung peerToPeerAnwendung;
    private String ip;
    private String nachricht;
    private boolean running;
    private TCPSocket socket;
    private int modus;

    public PeerToPeerClientMitarbeiter(PeerToPeerAnwendung peerToPeerAnwendung, String ip, PeerToPeerPaket paket) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerClientMitarbeiter), constr: PeerToPeerClientMitarbeiter(" + peerToPeerAnwendung + "," + ip + "," + paket + ")");
        this.peerToPeerAnwendung = peerToPeerAnwendung;
        this.ip = ip;
        this.nachricht = paket.toString();
        this.modus = paket instanceof PingPaket ? 1 : 3;
        this.running = true;
    }

    public PeerToPeerClientMitarbeiter(PeerToPeerAnwendung anwendung, String ip, String dateiname) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerClientMitarbeiter), constr: PeerToPeerClientMitarbeiter(" + anwendung + "," + ip + "," + dateiname + ")");
        this.ip = ip;
        this.peerToPeerAnwendung = anwendung;
        this.modus = 4;
        HTTPNachricht nachricht = new HTTPNachricht(1);
        nachricht.setPfad(dateiname);
        nachricht.setHost(ip);
        nachricht.setMethod("GET");
        this.nachricht = nachricht.toString();
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerClientMitarbeiter), run()");
        try {
            this.socket = new TCPSocket(this.peerToPeerAnwendung.getSystemSoftware(), this.ip, 6346);
            this.socket.verbinden();
            this.socket.senden(this.nachricht);
            if (this.modus == 4) {
                String antwort = this.socket.empfangen();
                HTTPNachricht http = new HTTPNachricht(antwort);
                if (http.getStatusCode() == 200) {
                    HTTPNachricht abfrage = new HTTPNachricht(this.nachricht);
                    Datei datei = new Datei();
                    datei.setDateiTyp(http.getContentType());
                    datei.setName(abfrage.getPfad());
                    datei.setDateiInhalt(http.getDaten());
                    this.peerToPeerAnwendung.speicherDatei(datei);
                }
            } else if (this.modus == 3) {
                while (this.running) {
                    String antwort = this.socket.empfangen();
                    if (antwort == null) continue;
                    QueryHitPaket queryHitPaket = new QueryHitPaket(antwort);
                    this.peerToPeerAnwendung.verarbeiteQueryHit(queryHitPaket);
                }
            } else if (this.modus == 1) {
                while (this.running) {
                    String antwort = this.socket.empfangen();
                    if (antwort == null) continue;
                    PongPaket pongPaket = new PongPaket(antwort);
                    this.peerToPeerAnwendung.verarbeitePong(pongPaket);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(Main.debug);
        }
        finally {
            this.socket.schliessen();
        }
    }

    public void beenden() {
        this.running = false;
        this.socket.beenden();
    }
}

