/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dateiaustausch;

import filius.Main;
import filius.software.Anwendung;
import filius.software.dateiaustausch.PeerToPeerClient;
import filius.software.dateiaustausch.PeerToPeerServer;
import filius.software.dateiaustausch.PingPaket;
import filius.software.dateiaustausch.PongPaket;
import filius.software.dateiaustausch.QueryHitPaket;
import filius.software.dateiaustausch.QueryPaket;
import filius.software.system.Betriebssystem;
import filius.software.system.Datei;
import filius.software.system.Dateisystem;
import filius.software.system.InternetKnotenBetriebssystem;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;

public class PeerToPeerAnwendung
extends Anwendung {
    private LinkedList<String> bekanntePeerToPeerTeilnehmer = new LinkedList();
    private LinkedList<Integer> eigeneAnfragen = new LinkedList();
    private LinkedList<Integer> fremdeAnfragen = new LinkedList();
    private LinkedList<Integer> schonmalVerschicktListe = new LinkedList();
    private LinkedList<String> erwarteteDateien = new LinkedList();
    private LinkedList<String> ergebnisse = new LinkedList();
    private PeerToPeerServer peerToPeerServer;
    private PeerToPeerClient peerToPeerClient;
    private DefaultMutableTreeNode verzeichnis;
    private int maxTeilnehmerZahl;

    public PeerToPeerAnwendung() {
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), constr: PeerToPeerAnwendung()");
        this.setMaxTeilnehmerZahl(Math.round((float)Math.random() * 2.0f) + 3);
    }

    @Override
    public void setSystemSoftware(InternetKnotenBetriebssystem betriebssystem) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), setSystemSoftware(" + betriebssystem + ")");
        super.setSystemSoftware(betriebssystem);
        Dateisystem dateisystem = betriebssystem.getDateisystem();
        dateisystem.erstelleVerzeichnis(betriebssystem.getDateisystem().getRoot(), "peer2peer");
        this.verzeichnis = dateisystem.verzeichnisKnoten(dateisystem.holeRootPfad() + "/" + "peer2peer");
    }

    @Override
    public void starten() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), starten()");
        super.starten();
        this.eigeneAnfragen = new LinkedList();
        this.fremdeAnfragen = new LinkedList();
        this.schonmalVerschicktListe = new LinkedList();
        this.peerToPeerServer = new PeerToPeerServer(this);
        this.peerToPeerServer.setSystemSoftware(this.getSystemSoftware());
        this.peerToPeerServer.starten();
        this.peerToPeerClient = new PeerToPeerClient(this);
        this.peerToPeerClient.setSystemSoftware(this.getSystemSoftware());
        this.peerToPeerClient.starten();
    }

    @Override
    public void beenden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), beenden()");
        super.beenden();
        this.peerToPeerServer.beenden();
        this.peerToPeerClient.beenden();
    }

    PongPaket erstellePong(PingPaket ping) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), erstellePong(" + ping + ")");
        long anzahlBytes = 0L;
        if (this.schonmalVerschicktListe.contains(ping.getGuid())) {
            return null;
        }
        Betriebssystem bs = (Betriebssystem)this.getSystemSoftware();
        List<Datei> dateien = bs.getDateisystem().holeDateien(this.verzeichnis);
        for (int i = 0; i < dateien.size(); ++i) {
            Datei aktuelle = dateien.get(i);
            anzahlBytes += aktuelle.holeGroesse();
        }
        PongPaket pong = new PongPaket(bs.holeIPAdresse(), 6346, dateien.size(), anzahlBytes);
        pong.setGuid(ping.getGuid());
        pong.setIpAdresse(bs.holeIPAdresse());
        return pong;
    }

    void sendePing(PingPaket ping, String absender) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), sendePing(" + ping + "," + absender + ")");
        if (ping.getTtl() > 0 && !this.schonmalVerschicktListe.contains(ping.getGuid())) {
            this.schonmalVerschicktListe.add(ping.getGuid());
            this.fremdeAnfragen.add(ping.getGuid());
            this.peerToPeerClient.sendePing("", ping, absender);
        }
    }

    LinkedList<Datei> verarbeiteAnfrage(String absender, QueryPaket anfrage) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), verarbeiteAnfrage(" + absender + "," + anfrage + ")");
        Datei ergebnis = null;
        if (!this.schonmalVerschicktListe.contains(anfrage.getGuid())) {
            this.fremdeAnfragen.add(anfrage.getGuid());
            this.schonmalVerschicktListe.add(anfrage.getGuid());
            List<Datei> dateien = this.getSystemSoftware().getDateisystem().holeDateien(this.verzeichnis);
            LinkedList<Datei> ergebnisListe = new LinkedList<Datei>();
            for (int i = 0; i < dateien.size(); ++i) {
                String gesuchte;
                ergebnis = dateien.get(i);
                String aktuellerName = ergebnis.getName().toLowerCase();
                if (!aktuellerName.contains(gesuchte = anfrage.getSuchKriterien().toLowerCase())) continue;
                ergebnisListe.add(ergebnis);
            }
            if (anfrage.getTtl() > 0) {
                anfrage.setTtl(anfrage.getTtl() - 1);
                anfrage.setHops(anfrage.getHops() + 1);
                this.peerToPeerClient.sendeAnfrage(anfrage, absender);
            }
            return ergebnisListe;
        }
        return null;
    }

    public void beitretenNetzwerk(String teilnehmerIP) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), beitretenNetzwerk(" + teilnehmerIP + ")");
        Betriebssystem bs = (Betriebssystem)this.getSystemSoftware();
        if (!bs.holeIPAdresse().equals(teilnehmerIP)) {
            PingPaket pingPaket = new PingPaket();
            pingPaket.setIp(bs.holeIPAdresse());
            this.eigeneAnfragen.add(pingPaket.getGuid());
            this.peerToPeerClient.sendePing(teilnehmerIP, pingPaket, bs.holeIPAdresse());
        }
    }

    public void resetNetwork() {
        this.bekanntePeerToPeerTeilnehmer.clear();
        this.benachrichtigeBeobachter(this.bekanntePeerToPeerTeilnehmer);
    }

    public void herunterladenDatei(int ergebnisIndex) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), herunterladenDatei(" + ergebnisIndex + ")");
        StringTokenizer tempTokenizer = new StringTokenizer(this.ergebnisse.get(ergebnisIndex), "/");
        String tmpBesitzer = tempTokenizer.nextToken();
        StringTokenizer tempTokenizerDatei = new StringTokenizer(tempTokenizer.nextToken(), ":");
        String tmpDateiname = tempTokenizerDatei.nextToken();
        this.erwarteteDateien.add(tmpDateiname);
        this.peerToPeerClient.dateiVomTeilnehmerAnfordern(tmpBesitzer, tmpDateiname);
        this.benachrichtigeBeobachter();
    }

    public void sucheDatei(String datei) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), sucheDatei(" + datei + ")");
        this.ergebnisse.clear();
        QueryPaket anfragePaket = new QueryPaket("1", datei);
        this.eigeneAnfragen.add(anfragePaket.getGuid());
        Betriebssystem bs = (Betriebssystem)this.getSystemSoftware();
        this.peerToPeerClient.sendeAnfrage(anfragePaket, bs.holeIPAdresse());
    }

    public void abbrechenSuche() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), abbrechenSuche()");
        this.peerToPeerClient.abbrechenSuche();
    }

    public void loescheSuchergebnisse() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), loescheSuchergebnisse()");
        this.ergebnisse.clear();
    }

    Datei holeDatei(String dateiName) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), holeDatei()");
        Datei datei = this.getSystemSoftware().getDateisystem().holeDatei(this.verzeichnis, dateiName);
        return datei;
    }

    void speicherDatei(Datei datei) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), speicherDatei(" + datei + ")");
        this.getSystemSoftware().getDateisystem().speicherDatei(this.verzeichnis, datei);
    }

    void verarbeiteQueryHit(QueryHitPaket antwortPaket) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), verarbeiteQueryHit(" + antwortPaket + ")");
        if (this.eigeneAnfragen.contains(antwortPaket.getGuid())) {
            this.hinzuErgebnis(antwortPaket);
            this.benachrichtigeBeobachter();
        } else if (this.fremdeAnfragen.contains(antwortPaket.getGuid()) && antwortPaket.getTtl() > 0) {
            antwortPaket.setTtl(antwortPaket.getTtl() - 1);
            antwortPaket.setHops(antwortPaket.getHops() + 1);
            this.peerToPeerServer.sendePaket(antwortPaket);
        }
    }

    void verarbeitePong(PongPaket pongPaket) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), verarbeitePong(" + pongPaket + ")\n\tPong-Nachricht bei '" + this.getSystemSoftware().getKnoten().holeAnzeigeName() + "' eingetroffen: " + pongPaket.toString());
        if (this.eigeneAnfragen.contains(pongPaket.getGuid())) {
            this.hinzuTeilnehmer(pongPaket.getIpAdresse());
        } else {
            pongPaket.setTtl(pongPaket.getTtl() - 1);
            pongPaket.setHops(pongPaket.getHops() + 1);
            this.peerToPeerServer.sendePaket(pongPaket);
        }
    }

    public LinkedList<String> holeBekanntePeerToPeerTeilnehmer() {
        return this.bekanntePeerToPeerTeilnehmer;
    }

    public LinkedList<String> holeErgebnisse() {
        return this.ergebnisse;
    }

    public DefaultMutableTreeNode holeVerzeichnis() {
        return this.verzeichnis;
    }

    void hinzuErgebnis(QueryHitPaket ergebnis) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), hinzuErgebnis(" + ergebnis + ")");
        String neuesErgebnis = ergebnis.getIpAdresse() + "/" + ergebnis.getErgebnis();
        if (!this.ergebnisse.contains(neuesErgebnis)) {
            this.ergebnisse.add(neuesErgebnis);
            this.benachrichtigeBeobachter();
        }
    }

    void hinzuTeilnehmer(String ipAdresse) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerAnwendung), hinzuTeilnehmer(" + ipAdresse + ")");
        if (!this.bekanntePeerToPeerTeilnehmer.contains(ipAdresse) && this.bekanntePeerToPeerTeilnehmer.size() < this.maxTeilnehmerZahl) {
            this.bekanntePeerToPeerTeilnehmer.add(ipAdresse);
            this.benachrichtigeBeobachter();
        }
    }

    LinkedList<Integer> holeEigeneAnfragen() {
        return this.eigeneAnfragen;
    }

    public int getMaxTeilnehmerZahl() {
        return this.maxTeilnehmerZahl;
    }

    public void setMaxTeilnehmerZahl(int maxTeilnehmerZahl) {
        this.maxTeilnehmerZahl = maxTeilnehmerZahl;
    }
}

