/*
 * Decompiled with CFR 0.152.
 */
package filius.rahmenprogramm.nachrichten;

import filius.Main;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.nachrichten.LauscherBeobachter;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.transportschicht.TcpSegment;
import filius.software.transportschicht.UdpSegment;
import filius.software.vermittlungsschicht.ArpPaket;
import filius.software.vermittlungsschicht.IcmpPaket;
import filius.software.vermittlungsschicht.IpPaket;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;

public class Lauscher
implements I18n {
    public static final String ETHERNET = "";
    public static final String ARP = "ARP";
    public static final String IP = "IP";
    public static final String ICMP = "ICMP";
    public static final String TCP = "TCP";
    public static final String UDP = "UDP";
    public static final String HTTP = "HTTP";
    public static final String SMTP = "SMTP";
    public static final String POP = "POP3";
    public static final String DNS = "DNS";
    public static final String DHCP = "DHCP";
    public static final String[] SPALTEN = new String[]{messages.getString("rp_lauscher_msg1"), messages.getString("rp_lauscher_msg2"), messages.getString("rp_lauscher_msg3"), messages.getString("rp_lauscher_msg4"), messages.getString("rp_lauscher_msg5"), messages.getString("rp_lauscher_msg6"), messages.getString("rp_lauscher_msg7")};
    public static final String[] PROTOKOLL_SCHICHTEN = new String[]{messages.getString("rp_lauscher_msg8"), messages.getString("rp_lauscher_msg9"), messages.getString("rp_lauscher_msg10"), messages.getString("rp_lauscher_msg11")};
    private static Lauscher lauscher = null;
    private HashMap<String, LinkedList<LauscherBeobachter>> beobachter;
    private HashMap<String, LinkedList<Object[]>> datenEinheiten;

    private Lauscher() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", constr: Lauscher()");
        this.beobachter = new HashMap();
        this.reset();
    }

    public void reset() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", reset()");
        this.datenEinheiten = new HashMap();
        this.benachrichtigeBeobachter(null);
    }

    public Collection<String> getInterfaceIDs() {
        return this.datenEinheiten.keySet();
    }

    public static Lauscher getLauscher() {
        if (lauscher == null) {
            lauscher = new Lauscher();
        }
        return lauscher;
    }

    public void removeIdentifier(String identifier) {
        this.datenEinheiten.remove(identifier);
        this.beobachter.remove(identifier);
    }

    public void addBeobachter(String rechnerId, LauscherBeobachter newObserver) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", addBeobachter(" + rechnerId + "," + newObserver + ")");
        LinkedList<LauscherBeobachter> liste = this.beobachter.get(rechnerId);
        if (liste == null) {
            liste = new LinkedList();
            this.beobachter.put(rechnerId, liste);
        }
        liste.add(newObserver);
    }

    private void benachrichtigeBeobachter(String rechnerId) {
        LinkedList<LauscherBeobachter> liste;
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", benachrichtigeBeobachter(" + rechnerId + ")");
        if (rechnerId == null) {
            Collection<LinkedList<LauscherBeobachter>> collection = this.beobachter.values();
            liste = new LinkedList();
            Iterator<LinkedList<LauscherBeobachter>> valueIt = collection.iterator();
            while (valueIt.hasNext()) {
                liste.addAll(valueIt.next());
            }
        } else {
            liste = this.beobachter.get(rechnerId);
        }
        if (liste != null) {
            ListIterator it = liste.listIterator();
            while (it.hasNext()) {
                ((LauscherBeobachter)it.next()).update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDatenEinheit(String interfaceId, EthernetFrame frame) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", addDatenEinheit(" + interfaceId + "," + frame + ")");
        Object[] frameMitZeitstempel = new Object[]{System.currentTimeMillis(), frame};
        LinkedList<Object> liste = this.datenEinheiten.get(interfaceId);
        if (liste == null) {
            liste = new LinkedList();
        }
        LinkedList<Object[]> linkedList = liste;
        synchronized (linkedList) {
            liste.addLast(frameMitZeitstempel);
        }
        this.datenEinheiten.put(interfaceId, liste);
        this.benachrichtigeBeobachter(interfaceId);
    }

    public Object[][] getDaten(String interfaceId, boolean inheritAddress) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", getDaten(" + interfaceId + ")");
        Vector<Object[]> vector = this.datenVorbereiten(interfaceId, inheritAddress);
        if (vector == null) {
            Object[][] daten = new Object[0][SPALTEN.length];
            return daten;
        }
        Object[][] daten = new Object[vector.size()][SPALTEN.length];
        for (int i = 0; i < vector.size(); ++i) {
            daten[i] = vector.elementAt(i);
        }
        return daten;
    }

    public void print(String interfaceId) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", print(" + interfaceId + ")");
        Object[][] daten = this.getDaten(interfaceId, false);
        for (int i = 0; i < daten.length; ++i) {
            for (int j = 0; j < daten[i].length; ++j) {
                Main.debug.print("\t" + daten[i][j]);
            }
            Main.debug.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<Object[]> datenVorbereiten(String interfaceId, boolean inheritAddress) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", datenVorbereiten(" + interfaceId + ")");
        TcpSegment tcpSeg = null;
        UdpSegment udpSeg = null;
        String timestampStr = ETHERNET;
        LinkedList<Object[]> liste = this.datenEinheiten.get(interfaceId);
        if (liste == null) {
            return null;
        }
        Vector<Object[]> daten = new Vector<Object[]>();
        LinkedList<Object[]> linkedList = liste;
        synchronized (linkedList) {
            ListIterator it = liste.listIterator();
            int i = 1;
            while (it.hasNext()) {
                Object[] frameMitZeitstempel = (Object[])it.next();
                Object[] neuerEintrag = new Object[SPALTEN.length];
                neuerEintrag[0] = ETHERNET + i;
                GregorianCalendar zeit = new GregorianCalendar();
                zeit.setTimeInMillis((Long)frameMitZeitstempel[0]);
                timestampStr = (zeit.get(11) < 10 ? "0" + zeit.get(11) : Integer.valueOf(zeit.get(11))) + ":" + (zeit.get(12) < 10 ? "0" + zeit.get(12) : Integer.valueOf(zeit.get(12))) + ":" + (zeit.get(13) < 10 ? "0" + zeit.get(13) : Integer.valueOf(zeit.get(13))) + "." + (zeit.get(14) < 10 ? "00" + zeit.get(14) : (zeit.get(14) < 100 ? "0" + zeit.get(14) : Integer.valueOf(zeit.get(14))));
                neuerEintrag[1] = timestampStr;
                EthernetFrame frame = (EthernetFrame)frameMitZeitstempel[1];
                neuerEintrag[2] = frame.getQuellMacAdresse();
                neuerEintrag[3] = frame.getZielMacAdresse();
                neuerEintrag[4] = ETHERNET;
                neuerEintrag[5] = PROTOKOLL_SCHICHTEN[0];
                neuerEintrag[6] = frame.getTyp();
                daten.addElement(neuerEintrag);
                neuerEintrag = new Object[SPALTEN.length];
                neuerEintrag[0] = ETHERNET + i;
                neuerEintrag[1] = timestampStr;
                if (frame.getTyp().equals("0x800") && !frame.isICMP()) {
                    IpPaket ipPaket = (IpPaket)frame.getDaten();
                    neuerEintrag[2] = ipPaket.getSender();
                    neuerEintrag[3] = ipPaket.getEmpfaenger();
                    neuerEintrag[4] = IP;
                    neuerEintrag[5] = PROTOKOLL_SCHICHTEN[1];
                    neuerEintrag[6] = messages.getString("rp_lauscher_msg12") + ipPaket.getProtocol() + ", TTL: " + ipPaket.getTtl();
                    daten.addElement(neuerEintrag);
                    neuerEintrag = new Object[SPALTEN.length];
                    neuerEintrag[0] = ETHERNET + i;
                    neuerEintrag[1] = timestampStr;
                    String source = null;
                    String dest = null;
                    if (ipPaket.getProtocol() == 6) {
                        tcpSeg = (TcpSegment)ipPaket.getSegment();
                        if (inheritAddress) {
                            source = ipPaket.getSender() + ":" + tcpSeg.getQuellPort();
                            neuerEintrag[2] = source;
                            dest = ipPaket.getEmpfaenger() + ":" + tcpSeg.getZielPort();
                            neuerEintrag[3] = dest;
                        } else {
                            neuerEintrag[2] = tcpSeg.getQuellPort();
                            neuerEintrag[3] = tcpSeg.getZielPort();
                        }
                        neuerEintrag[4] = TCP;
                        neuerEintrag[5] = PROTOKOLL_SCHICHTEN[2];
                        if (tcpSeg.isSyn()) {
                            neuerEintrag[6] = "SYN";
                        } else if (tcpSeg.isFin()) {
                            neuerEintrag[6] = "FIN";
                        }
                        neuerEintrag[6] = (neuerEintrag[6] == null ? ETHERNET : neuerEintrag[6] + ", ") + "SEQ: " + tcpSeg.getSeqNummer();
                        if (tcpSeg.isAck()) {
                            neuerEintrag[6] = neuerEintrag[6] + ", ACK:" + tcpSeg.getAckNummer();
                        }
                    } else if (ipPaket.getProtocol() == 17) {
                        udpSeg = (UdpSegment)ipPaket.getSegment();
                        if (inheritAddress) {
                            source = ipPaket.getSender() + ":" + udpSeg.getQuellPort();
                            neuerEintrag[2] = source;
                            dest = ipPaket.getEmpfaenger() + ":" + udpSeg.getZielPort();
                            neuerEintrag[3] = dest;
                        } else {
                            neuerEintrag[2] = udpSeg.getQuellPort();
                            neuerEintrag[3] = udpSeg.getZielPort();
                        }
                        neuerEintrag[4] = UDP;
                        neuerEintrag[5] = PROTOKOLL_SCHICHTEN[2];
                        neuerEintrag[6] = ETHERNET;
                    } else {
                        Main.debug.println("ERROR (" + this.hashCode() + "): Protokoll der Transportschicht (" + ipPaket.getProtocol() + ") nicht bekannt.");
                    }
                    daten.addElement(neuerEintrag);
                    neuerEintrag = new Object[SPALTEN.length];
                    neuerEintrag[0] = ETHERNET + i;
                    neuerEintrag[1] = timestampStr;
                    neuerEintrag[2] = source;
                    neuerEintrag[3] = dest;
                    neuerEintrag[4] = ETHERNET;
                    neuerEintrag[5] = PROTOKOLL_SCHICHTEN[3];
                    if (ipPaket.getProtocol() == 6) {
                        neuerEintrag[6] = tcpSeg.getDaten();
                    } else if (ipPaket.getProtocol() == 17) {
                        neuerEintrag[6] = udpSeg.getDaten();
                    }
                    if (neuerEintrag[6] != null && !((String)neuerEintrag[6]).trim().equals(ETHERNET)) {
                        daten.addElement(neuerEintrag);
                    }
                } else if (frame.getTyp().equals("0x806")) {
                    ArpPaket arpPaket = (ArpPaket)frame.getDaten();
                    neuerEintrag[2] = arpPaket.getQuellIp();
                    neuerEintrag[3] = arpPaket.getZielIp();
                    neuerEintrag[4] = ARP;
                    neuerEintrag[5] = PROTOKOLL_SCHICHTEN[1];
                    neuerEintrag[6] = arpPaket.getZielMacAdresse().equalsIgnoreCase("ff:ff:ff:ff:ff:ff") ? messages.getString("rp_lauscher_msg13") + " " + arpPaket.getZielIp() + ", " : ETHERNET;
                    neuerEintrag[6] = neuerEintrag[6] + arpPaket.getQuellIp() + ": " + arpPaket.getQuellMacAdresse();
                    daten.addElement(neuerEintrag);
                } else if (frame.getTyp().equals("0x800") && frame.isICMP()) {
                    IcmpPaket icmpPaket = (IcmpPaket)frame.getDaten();
                    neuerEintrag[2] = icmpPaket.getQuellIp();
                    neuerEintrag[3] = icmpPaket.getZielIp();
                    neuerEintrag[4] = ICMP;
                    neuerEintrag[5] = PROTOKOLL_SCHICHTEN[1];
                    block2 : switch (icmpPaket.getIcmpType()) {
                        case 0: {
                            neuerEintrag[6] = "ICMP Echo Reply (pong)";
                            break;
                        }
                        case 3: {
                            switch (icmpPaket.getIcmpCode()) {
                                case 0: {
                                    neuerEintrag[6] = "ICMP Network Unreachable";
                                    break block2;
                                }
                                case 1: {
                                    neuerEintrag[6] = "ICMP Host Unreachable";
                                    break block2;
                                }
                            }
                            neuerEintrag[6] = "ICMP Destination Unreachable (code " + icmpPaket.getIcmpCode() + ")";
                            break;
                        }
                        case 8: {
                            neuerEintrag[6] = "ICMP Echo Request (ping)";
                            break;
                        }
                        case 11: {
                            neuerEintrag[6] = "ICMP Time Exeeded (poof)";
                            break;
                        }
                        default: {
                            neuerEintrag[6] = "ICMP unknown: " + icmpPaket.getIcmpType() + " / " + icmpPaket.getIcmpCode();
                        }
                    }
                    neuerEintrag[6] = neuerEintrag[6] + ", TTL: " + icmpPaket.getTtl() + ", Seq.-Nr.: " + icmpPaket.getSeqNr();
                    daten.addElement(neuerEintrag);
                }
                ++i;
            }
        }
        return daten;
    }

    public String[] getHeader() {
        return SPALTEN;
    }
}

