/*
 * Decompiled with CFR 0.152.
 */
package filius.hardware.knoten;

import filius.Main;
import filius.hardware.NetzwerkInterface;
import filius.hardware.Port;
import filius.hardware.Verbindung;
import filius.hardware.knoten.Knoten;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class InternetKnoten
extends Knoten {
    private static final long serialVersionUID = 1L;
    private List<NetzwerkInterface> netzwerkInterfaces = new LinkedList<NetzwerkInterface>();

    @Override
    public Port holeFreienPort() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnoten), holeFreienPort()");
        ListIterator<NetzwerkInterface> iter = this.getNetzwerkInterfaces().listIterator();
        while (iter.hasNext()) {
            NetzwerkInterface nic = iter.next();
            Port anschluss = nic.getPort();
            if (!anschluss.isPortFrei()) continue;
            return anschluss;
        }
        return null;
    }

    @Override
    protected List<Port> defineConnectedPorts() {
        ArrayList<Port> connectedPorts = new ArrayList<Port>();
        for (NetzwerkInterface nic : this.netzwerkInterfaces) {
            Verbindung connection = nic.getPort().getVerbindung();
            if (connection == null) continue;
            try {
                connectedPorts.add(connection.findConnectedPort(nic.getPort()));
            }
            catch (Exception e) {
                Main.debug.println(e.getMessage());
            }
        }
        return connectedPorts;
    }

    @Override
    protected boolean hasPort(Port portToLookup) {
        boolean result = false;
        for (NetzwerkInterface nic : this.netzwerkInterfaces) {
            if (!nic.getPort().equals(portToLookup)) continue;
            result = true;
            break;
        }
        return result;
    }

    public NetzwerkInterface getNetzwerkInterfaceByMac(String mac) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnoten), getNetzwerkInterfaceByMac(" + mac + ")");
        NetzwerkInterface rueckgabe = null;
        ListIterator<NetzwerkInterface> it = this.netzwerkInterfaces.listIterator();
        while (it.hasNext()) {
            NetzwerkInterface ni = it.next();
            if (!ni.getMac().equals(mac)) continue;
            rueckgabe = ni;
        }
        return rueckgabe;
    }

    public void removeNic(NetzwerkInterface nic) {
        this.netzwerkInterfaces.remove(nic);
    }

    public NetzwerkInterface getNetzwerkInterfaceByIp(String ip) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnoten), getNetzwerkInterfaceByIp(" + ip + ")");
        if (ip.equals("127.0.0.1")) {
            return this.netzwerkInterfaces.get(0);
        }
        NetzwerkInterface rueckgabe = null;
        ListIterator<NetzwerkInterface> it = this.netzwerkInterfaces.listIterator();
        while (it.hasNext()) {
            NetzwerkInterface ni = it.next();
            if (!ni.getIp().equals(ip)) continue;
            rueckgabe = ni;
        }
        return rueckgabe;
    }

    public List<NetzwerkInterface> getNetzwerkInterfaces() {
        return this.netzwerkInterfaces;
    }

    public void setNetzwerkInterfaces(List<NetzwerkInterface> netzwerkInterfaces) {
        this.netzwerkInterfaces = netzwerkInterfaces;
    }

    public int holeAnzahlAnschluesse() {
        return this.netzwerkInterfaces.size();
    }

    public void hinzuAnschluss() {
        this.netzwerkInterfaces.add(new NetzwerkInterface());
    }

    public void setzeAnzahlAnschluesse(int anzahlAnschluesse) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (InternetKnoten), setzeAnzahlAnschluesse(" + anzahlAnschluesse + ")");
        this.netzwerkInterfaces = new LinkedList<NetzwerkInterface>();
        for (int i = 0; i < anzahlAnschluesse; ++i) {
            this.netzwerkInterfaces.add(new NetzwerkInterface());
        }
    }
}

