/*
 * Decompiled with CFR 0.152.
 */
package filius.hardware;

import filius.Main;
import filius.hardware.Port;
import filius.rahmenprogramm.Information;
import java.io.Serializable;

public class NetzwerkInterface
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String mac;
    private String ip;
    private String subnetzMaske;
    private String gateway;
    private String dns;
    private Port anschluss;

    public NetzwerkInterface() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (NetzwerkInterface), constr: NetzwerkInterface()");
        this.setMac(Information.getInformation().holeFreieMACAdresse());
        this.setIp("192.168.0.10");
        this.setSubnetzMaske("255.255.255.0");
        this.setGateway("");
        this.setDns("");
        this.anschluss = new Port(this);
    }

    public Port getPort() {
        return this.anschluss;
    }

    public void setPort(Port port) {
        this.anschluss = port;
    }

    public String getDns() {
        return this.dns;
    }

    public void setDns(String dns) {
        this.dns = dns;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getMac() {
        return this.mac.toUpperCase();
    }

    public void setMac(String mac) {
        if (mac != null) {
            Information.getInformation().macHinzufuegen(mac);
            this.mac = mac;
        }
    }

    public String getSubnetzMaske() {
        return this.subnetzMaske;
    }

    public void setSubnetzMaske(String subnetzMaske) {
        this.subnetzMaske = subnetzMaske;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }
}

