/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.Main;
import filius.gui.netzwerksicht.JVermittlungsrechnerKonfiguration;
import filius.hardware.knoten.Knoten;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.vermittlungsschicht.Weiterleitungstabelle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class JWeiterleitungsTabelle
extends JTable
implements I18n {
    private LinkedList<Boolean> editableRows = null;
    private JVermittlungsrechnerKonfiguration konfig;
    private boolean standardEintraegeAnzeigen = true;

    public JWeiterleitungsTabelle(JVermittlungsrechnerKonfiguration konfig) {
        super(new DefaultTableModel(1, 4));
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + ", constr: JWeiterleitungsTabelle(" + konfig + ")");
        this.konfig = konfig;
        this.setRowHeight(20);
        this.setRowMargin(2);
        this.setDragEnabled(false);
        this.setSelectionMode(0);
        final JWeiterleitungsTabelle tabelle = this;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    JPopupMenu pmRechteMausTaste = new JPopupMenu();
                    final JMenuItem miLoeschen = new JMenuItem(I18n.messages.getString("jweiterleitungstabelle_msg1"));
                    miLoeschen.setActionCommand("del");
                    final JMenuItem miZeileHinzu = new JMenuItem(I18n.messages.getString("jweiterleitungstabelle_msg2"));
                    miZeileHinzu.setActionCommand("add");
                    ActionListener al = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (e.getActionCommand().equals(miZeileHinzu.getActionCommand())) {
                                JWeiterleitungsTabelle.this.neuerEintrag();
                            } else if (e.getActionCommand().equals(miLoeschen.getActionCommand())) {
                                JWeiterleitungsTabelle.this.markiertenEintragLoeschen();
                            }
                        }
                    };
                    miZeileHinzu.addActionListener(al);
                    miLoeschen.addActionListener(al);
                    pmRechteMausTaste.add(miLoeschen);
                    pmRechteMausTaste.add(miZeileHinzu);
                    pmRechteMausTaste.show(tabelle, e.getX(), e.getY());
                }
            }
        });
        TableColumnModel tcm = this.getColumnModel();
        for (int i = 0; i < this.getRoutingTabellenSpalten().length; ++i) {
            tcm.getColumn(i).setHeaderValue(this.getRoutingTabellenSpalten()[i]);
        }
    }

    public void aenderungenAnnehmen() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", aenderungenAnnehmen()");
        Pattern pattern = null;
        if (this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
        Vector<Vector> tableData = ((DefaultTableModel)this.getModel()).getDataVector();
        Weiterleitungstabelle tabelle = ((InternetKnotenBetriebssystem)((Knoten)this.konfig.holeHardware()).getSystemSoftware()).getWeiterleitungstabelle();
        tabelle.reset();
        for (int i = 0; i < tableData.size(); ++i) {
            if (!this.isCellEditable(i, 1)) continue;
            Vector rowData = tableData.elementAt(i);
            String[] routingEintrag = new String[rowData.size()];
            for (int j = 0; j < routingEintrag.length; ++j) {
                String tmpString = (String)rowData.elementAt(j);
                switch (j) {
                    case 0: {
                        pattern = EingabenUeberpruefung.musterIpAdresse;
                        break;
                    }
                    case 1: {
                        pattern = EingabenUeberpruefung.musterSubNetz;
                        break;
                    }
                    case 2: {
                        pattern = EingabenUeberpruefung.musterIpAdresse;
                        break;
                    }
                    case 3: {
                        pattern = EingabenUeberpruefung.musterIpAdresse;
                    }
                }
                routingEintrag[j] = EingabenUeberpruefung.isGueltig(tmpString, pattern) ? tmpString : "";
            }
            tabelle.addManuellenEintrag(routingEintrag[0], routingEintrag[1], routingEintrag[2], routingEintrag[3]);
        }
        this.updateAttribute();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.editableRows == null) {
            return true;
        }
        if (row >= this.editableRows.size()) {
            return true;
        }
        return this.editableRows.get(row);
    }

    @Override
    public TableCellEditor getCellEditor() {
        TableCellEditor editor = super.getCellEditor();
        if (editor != null) {
            editor.addCellEditorListener(this);
        }
        return editor;
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        super.editingCanceled(e);
        this.aenderungenAnnehmen();
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        super.editingStopped(e);
        this.aenderungenAnnehmen();
    }

    public void neuerEintrag() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", neuerEintrag()");
        Vector<String> eintrag = new Vector<String>();
        eintrag.add("");
        eintrag.add("");
        eintrag.add("");
        eintrag.add("");
        ((DefaultTableModel)this.getModel()).addRow(eintrag);
        this.editableRows.add(new Boolean(true));
        this.aenderungenAnnehmen();
    }

    public void markiertenEintragLoeschen() {
        if (this.getSelectedRow() > -1) {
            this.entferneEintrag(this.getSelectedRow());
            this.aenderungenAnnehmen();
        }
    }

    private void entferneEintrag(int row) {
        ((DefaultTableModel)this.getModel()).removeRow(row);
        this.editableRows.remove(row);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setEnabled(this.editableRows.get(row));
        return renderer;
    }

    private String[] getRoutingTabellenSpalten() {
        String[] cols = new String[]{messages.getString("jweiterleitungstabelle_msg3"), messages.getString("jweiterleitungstabelle_msg4"), messages.getString("jweiterleitungstabelle_msg5"), messages.getString("jweiterleitungstabelle_msg6")};
        return cols;
    }

    public void setzeAlleEintraegeAnzeigen(boolean flag) {
        this.standardEintraegeAnzeigen = flag;
    }

    public void updateAttribute() {
        Object[][] data;
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", updateAttribute()");
        Weiterleitungstabelle tabelle = ((InternetKnotenBetriebssystem)((Knoten)this.konfig.holeHardware()).getSystemSoftware()).getWeiterleitungstabelle();
        LinkedList<String[]> routingTabelle = tabelle.holeTabelle();
        ListIterator it = routingTabelle.listIterator();
        if (this.standardEintraegeAnzeigen) {
            this.editableRows = tabelle.holeManuelleEintraegeFlags();
            data = new String[routingTabelle.size()][4];
            int i = 0;
            while (it.hasNext()) {
                data[i] = (String[])it.next();
                ++i;
            }
        } else {
            ListIterator editableIt = tabelle.holeManuelleEintraegeFlags().listIterator();
            Vector<String[]> tmpData = new Vector<String[]>();
            while (it.hasNext() && editableIt.hasNext()) {
                if (((Boolean)editableIt.next()).booleanValue()) {
                    tmpData.add((String[])it.next());
                    continue;
                }
                it.next();
            }
            data = new String[tmpData.size()][4];
            this.editableRows = new LinkedList();
            for (int i = 0; i < data.length; ++i) {
                data[i] = (String[])tmpData.elementAt(i);
                this.editableRows.add(Boolean.TRUE);
            }
        }
        ((DefaultTableModel)this.getModel()).setDataVector(data, this.getRoutingTabellenSpalten());
        ((DefaultTableModel)this.getModel()).fireTableDataChanged();
    }
}

