/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.Main;
import filius.gui.GUIContainer;
import filius.gui.JMainFrame;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.gui.netzwerksicht.JConnectionsDialog;
import filius.gui.netzwerksicht.JFirewallDialog;
import filius.gui.netzwerksicht.JKonfiguration;
import filius.gui.netzwerksicht.JWeiterleitungsTabelle;
import filius.hardware.Hardware;
import filius.hardware.Kabel;
import filius.hardware.NetzwerkInterface;
import filius.hardware.Port;
import filius.hardware.Verbindung;
import filius.hardware.knoten.InternetKnoten;
import filius.hardware.knoten.Knoten;
import filius.hardware.knoten.LokalerKnoten;
import filius.hardware.knoten.Vermittlungsrechner;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.software.firewall.Firewall;
import filius.software.system.VermittlungsrechnerBetriebssystem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JVermittlungsrechnerKonfiguration
extends JKonfiguration
implements I18n {
    private static final long serialVersionUID = 1L;
    private JDialog changeBasicSettingsDialog;
    private JTextField name;
    private JTextField[] ipAdressen;
    private JTextField[] netzmasken;
    private JTextField[] macAdressen;
    private JTextField gateway;
    private JCheckBox rip;
    private JLabel[] verbundeneKomponente;
    private JWeiterleitungsTabelle weiterleitungstabelle;
    private JCheckBox alleEintraegeAnzeigen;
    private JTabbedPane tpNetzwerkKarten;
    private Kabel highlightedCable = null;

    protected JVermittlungsrechnerKonfiguration(Hardware hardware) {
        super(hardware);
    }

    @Override
    public void aenderungenAnnehmen() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JVermittlungsrechnerKonfiguration), aenderungenAnnehmen()");
        Vermittlungsrechner vRechner = (Vermittlungsrechner)this.holeHardware();
        VermittlungsrechnerBetriebssystem bs = (VermittlungsrechnerBetriebssystem)vRechner.getSystemSoftware();
        vRechner.setName(this.name.getText());
        bs.setStandardGateway(this.gateway.getText());
        bs.setRipEnabled(this.rip.isSelected());
        ListIterator<NetzwerkInterface> it = vRechner.getNetzwerkInterfaces().listIterator();
        int i = 0;
        while (it.hasNext()) {
            NetzwerkInterface nic = it.next();
            if (this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, this.ipAdressen[i])) {
                nic.setIp(this.ipAdressen[i].getText());
            } else {
                Main.debug.println("ERROR (" + this.hashCode() + "): IP-Adresse ungueltig " + this.ipAdressen[i].getText());
            }
            if (this.ueberpruefen(EingabenUeberpruefung.musterSubNetz, this.netzmasken[i])) {
                nic.setSubnetzMaske(this.netzmasken[i].getText());
            } else {
                Main.debug.println("ERROR (" + this.hashCode() + "): Netzmaske ungueltig " + this.netzmasken[i].getText());
            }
            ++i;
        }
        GUIContainer.getGUIContainer().updateViewport();
        this.updateAttribute();
    }

    private void showFirewallDialog() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JVermittlungsrechnerKonfiguration), firewallDialogAnzeigen()");
        Firewall firewall = ((VermittlungsrechnerBetriebssystem)((Vermittlungsrechner)this.holeHardware()).getSystemSoftware()).holeFirewall();
        JFirewallDialog firewallDialog = new JFirewallDialog(firewall, JMainFrame.getJMainFrame());
        firewallDialog.setBounds(100, 100, 850, 340);
        firewallDialog.setName(messages.getString("jvermittlungsrechnerkonfiguration_msg1"));
        firewallDialog.updateRuleTable();
        firewallDialog.setVisible(true);
    }

    @Override
    protected void initAttributEingabeBox(Box box, Box rightBox) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JVermittlungsrechnerKonfiguration), initAttributEingabeBox(" + box + ")");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JVermittlungsrechnerKonfiguration.this.aenderungenAnnehmen();
            }
        };
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                JVermittlungsrechnerKonfiguration.this.aenderungenAnnehmen();
            }
        };
        this.addFocusListener(focusListener);
        Box boxNetzwerkKarten = Box.createVerticalBox();
        boxNetzwerkKarten.setPreferredSize(new Dimension(440, 150));
        boxNetzwerkKarten.setAlignmentX(0.0f);
        boxNetzwerkKarten.setOpaque(false);
        this.tpNetzwerkKarten = new JTabbedPane();
        this.tpNetzwerkKarten.setOpaque(false);
        boxNetzwerkKarten.add(this.tpNetzwerkKarten);
        KeyAdapter ipAdresseKeyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JTextField tfQuelle = (JTextField)e.getSource();
                JVermittlungsrechnerKonfiguration.this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, tfQuelle);
            }
        };
        KeyAdapter netzmaskeKeyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JTextField tfQuelle = (JTextField)e.getSource();
                JVermittlungsrechnerKonfiguration.this.ueberpruefen(EingabenUeberpruefung.musterSubNetz, tfQuelle);
            }
        };
        Box vBox = Box.createVerticalBox();
        Box tempBox = Box.createHorizontalBox();
        tempBox.setMaximumSize(new Dimension(400, 40));
        JLabel tempLabel = new JLabel(messages.getString("jvermittlungsrechnerkonfiguration_msg2"));
        tempLabel.setPreferredSize(new Dimension(140, 20));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        tempBox.add(tempLabel);
        this.name = new JTextField(messages.getString("jvermittlungsrechnerkonfiguration_msg3"));
        this.name.setPreferredSize(new Dimension(160, 20));
        this.name.addActionListener(actionListener);
        this.name.addFocusListener(focusListener);
        tempBox.add(this.name);
        vBox.add(tempBox);
        vBox.add(Box.createVerticalStrut(5));
        tempBox = Box.createHorizontalBox();
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempLabel = new JLabel(messages.getString("jvermittlungsrechnerkonfiguration_msg9"));
        tempLabel.setPreferredSize(new Dimension(140, 20));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        tempBox.add(tempLabel);
        this.gateway = new JTextField();
        this.gateway.setPreferredSize(new Dimension(160, 20));
        this.gateway.addActionListener(actionListener);
        this.gateway.addFocusListener(focusListener);
        this.gateway.addKeyListener(ipAdresseKeyAdapter);
        tempBox.add(this.gateway);
        vBox.add(tempBox);
        vBox.add(Box.createVerticalStrut(5));
        tempBox = Box.createHorizontalBox();
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempLabel = new JLabel(messages.getString("jvermittlungsrechnerkonfiguration_msg26"));
        tempLabel.setPreferredSize(new Dimension(140, 20));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(20));
        this.rip = new JCheckBox();
        this.rip.setPreferredSize(new Dimension(160, 20));
        this.rip.addActionListener(actionListener);
        this.rip.addFocusListener(focusListener);
        this.rip.setOpaque(false);
        tempBox.add(this.rip);
        vBox.add(tempBox);
        vBox.add(Box.createVerticalStrut(5));
        tempBox = Box.createHorizontalBox();
        tempBox.setMaximumSize(new Dimension(400, 40));
        JButton btFirewall = new JButton(messages.getString("jvermittlungsrechnerkonfiguration_msg4"));
        btFirewall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JVermittlungsrechnerKonfiguration.this.showFirewallDialog();
            }
        });
        tempBox.add(btFirewall);
        tempBox.add(Box.createHorizontalStrut(20));
        JButton changeBasicSettingsButton = new JButton(messages.getString("jvermittlungsrechnerkonfiguration_msg23"));
        changeBasicSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JVermittlungsrechnerKonfiguration.this.showConnectionsDialog();
            }
        });
        tempBox.add(changeBasicSettingsButton);
        vBox.add(tempBox);
        this.tpNetzwerkKarten.addTab(messages.getString("jvermittlungsrechnerkonfiguration_msg17"), vBox);
        Vermittlungsrechner vRechner = (Vermittlungsrechner)this.holeHardware();
        List<NetzwerkInterface> nicListe = vRechner.getNetzwerkInterfaces();
        this.ipAdressen = new JTextField[nicListe.size()];
        this.netzmasken = new JTextField[nicListe.size()];
        this.macAdressen = new JTextField[nicListe.size()];
        this.verbundeneKomponente = new JLabel[nicListe.size()];
        ListIterator<NetzwerkInterface> it = nicListe.listIterator();
        int i = 0;
        while (it.hasNext()) {
            NetzwerkInterface tempNic = it.next();
            Box boxNic = Box.createVerticalBox();
            Box boxKomponente = Box.createHorizontalBox();
            boxKomponente.setMaximumSize(new Dimension(400, 40));
            Knoten tempKnoten = this.holeVerbundeneKomponente(tempNic);
            this.verbundeneKomponente[i] = tempKnoten == null ? new JLabel(messages.getString("jvermittlungsrechnerkonfiguration_msg5")) : new JLabel(messages.getString("jvermittlungsrechnerkonfiguration_msg6") + " " + tempKnoten.holeAnzeigeName());
            this.verbundeneKomponente[i].setPreferredSize(new Dimension(400, 10));
            boxKomponente.add(this.verbundeneKomponente[i]);
            Box boxIpAdresse = Box.createHorizontalBox();
            boxIpAdresse.setMaximumSize(new Dimension(400, 40));
            tempLabel = new JLabel(messages.getString("jvermittlungsrechnerkonfiguration_msg7"));
            tempLabel.setPreferredSize(new Dimension(120, 10));
            boxIpAdresse.add(tempLabel);
            this.ipAdressen[i] = new JTextField(tempNic.getIp());
            boxIpAdresse.add(this.ipAdressen[i]);
            Box boxSubnetz = Box.createHorizontalBox();
            boxSubnetz.setMaximumSize(new Dimension(400, 40));
            tempLabel = new JLabel(messages.getString("jvermittlungsrechnerkonfiguration_msg8"));
            tempLabel.setPreferredSize(new Dimension(120, 10));
            boxSubnetz.add(tempLabel);
            this.netzmasken[i] = new JTextField(tempNic.getSubnetzMaske());
            boxSubnetz.add(this.netzmasken[i]);
            Box boxMacAdresse = Box.createHorizontalBox();
            boxMacAdresse.setMaximumSize(new Dimension(400, 40));
            tempLabel = new JLabel(messages.getString("jvermittlungsrechnerkonfiguration_msg18"));
            tempLabel.setPreferredSize(new Dimension(120, 10));
            boxMacAdresse.add(tempLabel);
            this.macAdressen[i] = new JTextField(tempNic.getMac());
            this.macAdressen[i].setEnabled(false);
            boxMacAdresse.add(this.macAdressen[i]);
            boxNic.add(boxKomponente);
            boxNic.add(Box.createVerticalStrut(5));
            boxNic.add(boxIpAdresse);
            boxNic.add(Box.createVerticalStrut(5));
            boxNic.add(boxSubnetz);
            boxNic.add(Box.createVerticalStrut(5));
            boxNic.add(boxMacAdresse);
            if (tempKnoten == null) {
                this.tpNetzwerkKarten.addTab(messages.getString("jvermittlungsrechnerkonfiguration_msg10") + (i + 1), new ImageIcon(this.getClass().getResource("/gfx/allgemein/conn_fail.png")), boxNic);
            } else {
                this.tpNetzwerkKarten.addTab(messages.getString("jvermittlungsrechnerkonfiguration_msg10") + (i + 1), new ImageIcon(this.getClass().getResource("/gfx/allgemein/conn_ok.png")), boxNic);
            }
            ++i;
        }
        for (i = 0; i < this.ipAdressen.length; ++i) {
            this.ipAdressen[i].addKeyListener(ipAdresseKeyAdapter);
            this.ipAdressen[i].addActionListener(actionListener);
            this.ipAdressen[i].addFocusListener(focusListener);
            this.netzmasken[i].addKeyListener(netzmaskeKeyAdapter);
            this.netzmasken[i].addActionListener(actionListener);
            this.netzmasken[i].addFocusListener(focusListener);
        }
        this.tpNetzwerkKarten.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Verbindung conn;
                JTabbedPane pane = (JTabbedPane)arg0.getSource();
                int sel = pane.getSelectedIndex();
                if (JVermittlungsrechnerKonfiguration.this.highlightedCable != null) {
                    JVermittlungsrechnerKonfiguration.this.highlightedCable.setAktiv(false);
                }
                if (sel > 0 && sel < pane.getComponentCount() - 1 && (conn = ((Vermittlungsrechner)JVermittlungsrechnerKonfiguration.this.holeHardware()).getNetzwerkInterfaces().get(sel - 1).getPort().getVerbindung()) != null) {
                    conn.setAktiv(true);
                    JVermittlungsrechnerKonfiguration.this.highlightedCable = (Kabel)conn;
                }
                JVermittlungsrechnerKonfiguration.this.weiterleitungstabelle.aenderungenAnnehmen();
            }
        });
        this.weiterleitungstabelle = new JWeiterleitungsTabelle(this);
        JScrollPane spWeiterleitung = new JScrollPane(this.weiterleitungstabelle);
        spWeiterleitung.setPreferredSize(new Dimension(300, 120));
        spWeiterleitung.addFocusListener(focusListener);
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.alleEintraegeAnzeigen = new JCheckBox();
        this.alleEintraegeAnzeigen.setSelected(true);
        this.alleEintraegeAnzeigen.setText(messages.getString("jvermittlungsrechnerkonfiguration_msg11"));
        this.alleEintraegeAnzeigen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JVermittlungsrechnerKonfiguration.this.weiterleitungstabelle.setzeAlleEintraegeAnzeigen(JVermittlungsrechnerKonfiguration.this.alleEintraegeAnzeigen.isSelected());
                JVermittlungsrechnerKonfiguration.this.weiterleitungstabelle.updateAttribute();
            }
        });
        tempBox.add((Component)this.alleEintraegeAnzeigen, "North");
        JButton btNeuerEintrag = new JButton(messages.getString("jvermittlungsrechnerkonfiguration_msg12"));
        btNeuerEintrag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JVermittlungsrechnerKonfiguration.this.weiterleitungstabelle.neuerEintrag();
            }
        });
        tempBox.add(Box.createHorizontalStrut(50));
        tempBox.add(btNeuerEintrag);
        JButton btEintragLoeschen = new JButton(messages.getString("jvermittlungsrechnerkonfiguration_msg13"));
        btEintragLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JVermittlungsrechnerKonfiguration.this.weiterleitungstabelle.markiertenEintragLoeschen();
            }
        });
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(btEintragLoeschen);
        JButton btTabellenDialog = new JButton(messages.getString("jvermittlungsrechnerkonfiguration_msg14"));
        btTabellenDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog tabellenDialog = new JDialog((Frame)JMainFrame.getJMainFrame(), true);
                tabellenDialog.setTitle(I18n.messages.getString("jvermittlungsrechnerkonfiguration_msg15"));
                tabellenDialog.setSize(600, 400);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                tabellenDialog.setLocation(screenSize.width / 2 - 300, screenSize.height / 2 - 200);
                JWeiterleitungsTabelle tabelle = new JWeiterleitungsTabelle(JVermittlungsrechnerKonfiguration.this.getKonfiguration());
                tabelle.updateAttribute();
                JScrollPane scrollPane = new JScrollPane(tabelle);
                tabellenDialog.getContentPane().add(scrollPane);
                tabellenDialog.setVisible(true);
                JVermittlungsrechnerKonfiguration.this.weiterleitungstabelle.updateAttribute();
            }
        });
        tempBox.add(Box.createHorizontalStrut(50));
        tempBox.add(btTabellenDialog);
        Box boxWeiterleitung = Box.createVerticalBox();
        boxWeiterleitung.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        boxWeiterleitung.add(tempBox);
        boxWeiterleitung.add(spWeiterleitung);
        this.tpNetzwerkKarten.addTab(messages.getString("jvermittlungsrechnerkonfiguration_msg15"), boxWeiterleitung);
        box.add(boxNetzwerkKarten);
        this.updateAttribute();
    }

    private void showConnectionsDialog() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JVermittlungsrechnerKonfiguration), showBasicSettingsDialog()");
        GUIContainer.getGUIContainer().getProperty().minimieren();
        this.changeBasicSettingsDialog = new JConnectionsDialog((Frame)JMainFrame.getJMainFrame(), (Vermittlungsrechner)this.holeHardware());
        this.changeBasicSettingsDialog.setTitle(messages.getString("jvermittlungsrechnerkonfiguration_msg23"));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.changeBasicSettingsDialog.setLocation(screenSize.width / 2 - 300, screenSize.height / 2 - 200);
        this.changeBasicSettingsDialog.setSize(750, 530);
        this.changeBasicSettingsDialog.setResizable(false);
        this.changeBasicSettingsDialog.setVisible(true);
    }

    @Override
    public void doUnselectAction() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JVermittlungsrechnerKonfiguration), doUnselectAction()");
        if (this.highlightedCable != null) {
            this.highlightedCable.setAktiv(false);
            this.highlightedCable = null;
            this.tpNetzwerkKarten.setSelectedIndex(0);
        }
    }

    public void highlightConnCable() {
        if (this.highlightedCable != null) {
            this.highlightedCable.setAktiv(true);
        }
    }

    public JVermittlungsrechnerKonfiguration getKonfiguration() {
        return this;
    }

    @Override
    public void updateAttribute() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JVermittlungsrechnerKonfiguration), updateAttribute()");
        Vermittlungsrechner vRechner = (Vermittlungsrechner)this.holeHardware();
        VermittlungsrechnerBetriebssystem bs = (VermittlungsrechnerBetriebssystem)vRechner.getSystemSoftware();
        this.name.setText(vRechner.holeAnzeigeName());
        this.gateway.setText(bs.getStandardGateway());
        this.rip.setSelected(bs.isRipEnabled());
        this.tpNetzwerkKarten.setEnabledAt(this.tpNetzwerkKarten.getTabCount() - 1, !bs.isRipEnabled());
        ListIterator<NetzwerkInterface> it = vRechner.getNetzwerkInterfaces().listIterator();
        for (int i = 0; it.hasNext() && i < this.ipAdressen.length; ++i) {
            NetzwerkInterface nic = it.next();
            this.ipAdressen[i].setText(nic.getIp());
            this.netzmasken[i].setText(nic.getSubnetzMaske());
            Knoten tempKnoten = this.holeVerbundeneKomponente(nic);
            if (tempKnoten == null) {
                this.verbundeneKomponente[i].setText(messages.getString("jvermittlungsrechnerkonfiguration_msg16"));
                continue;
            }
            this.verbundeneKomponente[i].setText(messages.getString("jvermittlungsrechnerkonfiguration_msg6") + " " + tempKnoten.holeAnzeigeName());
        }
        vRechner = (Vermittlungsrechner)this.holeHardware();
        List<NetzwerkInterface> nicListe = vRechner.getNetzwerkInterfaces();
        it = nicListe.listIterator();
        int i = 0;
        while (it.hasNext()) {
            NetzwerkInterface tempNic = it.next();
            if (this.holeVerbundeneKomponente(tempNic) == null) {
                this.tpNetzwerkKarten.setIconAt(i + 1, new ImageIcon(this.getClass().getResource("/gfx/allgemein/conn_fail.png")));
            } else {
                this.tpNetzwerkKarten.setIconAt(i + 1, new ImageIcon(this.getClass().getResource("/gfx/allgemein/conn_ok.png")));
            }
            String tabtitle = tempNic.getIp() != null ? tempNic.getIp() : messages.getString("jvermittlungsrechnerkonfiguration_msg10") + (i + 1);
            this.tpNetzwerkKarten.setTitleAt(i + 1, tabtitle);
            ++i;
        }
        this.weiterleitungstabelle.updateAttribute();
    }

    private Knoten holeVerbundeneKomponente(NetzwerkInterface nic) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JVermittlungsrechnerKonfiguration), holeVerbundeneKomponente(" + nic + ")");
        if (nic.getPort().getVerbindung() == null) {
            return null;
        }
        Port lokalerAnschluss = nic.getPort();
        Port[] ports = lokalerAnschluss.getVerbindung().getAnschluesse();
        Port entfernterAnschluss = ports[0] == lokalerAnschluss ? ports[1] : ports[0];
        ListIterator<GUIKnotenItem> it1 = GUIContainer.getGUIContainer().getKnotenItems().listIterator();
        while (it1.hasNext()) {
            ListIterator<Object> it2;
            Knoten knoten = it1.next().getKnoten();
            if (knoten instanceof LokalerKnoten) {
                it2 = ((LokalerKnoten)knoten).getAnschluesse().listIterator();
                while (it2.hasNext()) {
                    if (it2.next() != entfernterAnschluss) continue;
                    return knoten;
                }
                continue;
            }
            if (knoten instanceof InternetKnoten) {
                it2 = ((InternetKnoten)knoten).getNetzwerkInterfaces().listIterator();
                while (it2.hasNext()) {
                    if (((NetzwerkInterface)it2.next()).getPort() != entfernterAnschluss) continue;
                    return knoten;
                }
                continue;
            }
            Main.debug.println("ERROR (" + this.hashCode() + "): Knotentyp unbekannt.");
        }
        return null;
    }
}

