/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.MenuSelectionManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class JDocuColorSelector
extends JMenu {
    private static final long serialVersionUID = 1L;
    private int sampleWidth = 30;
    private int sampleHeight = 30;
    protected Border standardBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, this.getBackground()), new MatteBorder(1, 1, 1, 1, Color.DARK_GRAY));
    protected Border selectedBorder = new MatteBorder(3, 3, 3, 3, new Color(0.48f, 0.73f, 0.98f));
    protected Border activeBorder = new MatteBorder(2, 2, 2, 2, Color.BLACK);
    private Color color;

    public JDocuColorSelector(String name, Color[] colors, int lineCount, Color selectedColor) {
        super(name);
        JPanel p = new JPanel();
        p.setBorder(new EmptyBorder(5, 5, 5, 5));
        p.setLayout(new GridLayout(lineCount, 1));
        for (int i = 0; i < colors.length; ++i) {
            boolean sameColor = colors[i].getRGB() == selectedColor.getRGB();
            ColorPane pn = new ColorPane(colors[i], sameColor);
            p.add(pn);
        }
        this.add(p);
    }

    public Color getColor() {
        return this.color;
    }

    public void triggerMenuResponse(Color color) {
        this.color = color;
        MenuSelectionManager.defaultManager().clearSelectedPath();
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
    }

    private class ColorPane
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = 1L;
        boolean selected;

        public ColorPane(Color c, boolean selected) {
            this.setBackground(c);
            this.selected = selected;
            this.setBorder(selected ? JDocuColorSelector.this.selectedBorder : JDocuColorSelector.this.standardBorder);
            this.addMouseListener(this);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(JDocuColorSelector.this.sampleWidth, JDocuColorSelector.this.sampleHeight);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JDocuColorSelector.this.triggerMenuResponse(this.getBackground());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setBorder(JDocuColorSelector.this.activeBorder);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setBorder(this.selected ? JDocuColorSelector.this.selectedBorder : JDocuColorSelector.this.standardBorder);
        }
    }
}

