/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.Main;
import filius.gui.anwendungssicht.JTableEditable;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.software.dhcp.DHCPAddressAssignment;
import filius.software.dhcp.DHCPServer;
import filius.software.system.Betriebssystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JDHCPKonfiguration
extends JDialog
implements I18n,
ItemListener {
    private static final long serialVersionUID = 1L;
    private DHCPServer server;
    private JTextField tfObergrenze;
    private JTextField tfUntergrenze;
    private JTextField tfNetzmaske;
    private JTextField tfGateway;
    private JTextField tfDNSServer;
    private JCheckBox cbAktiv;
    private JCheckBox cbUseInternal;
    private JTabbedPane tabbedPane;
    protected JTable staticAddressTable;

    public JDHCPKonfiguration(JFrame owner, String titel, Betriebssystem bs) {
        super(owner, titel, true);
        this.server = bs.getDHCPServer();
        this.setSize(380, 380);
        this.setResizable(false);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Point location = new Point(screen.width / 2 - 190, screen.height / 2 - 140);
        this.setLocation(location);
        this.initComponents();
    }

    private void initComponents() {
        final JDHCPKonfiguration config = this;
        SpringLayout layout = new SpringLayout();
        JPanel jpDhcp = new JPanel(layout);
        JLabel lbUntergrenze = new JLabel(messages.getString("jdhcpkonfiguration_msg1"));
        this.tfUntergrenze = new JTextField(this.server.getUntergrenze());
        this.tfUntergrenze.setPreferredSize(new Dimension(150, 25));
        this.tfUntergrenze.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JDHCPKonfiguration.this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, JDHCPKonfiguration.this.tfUntergrenze);
            }
        });
        JLabel lbObergrenze = new JLabel(messages.getString("jdhcpkonfiguration_msg2"));
        this.tfObergrenze = new JTextField(this.server.getObergrenze());
        this.tfObergrenze.setPreferredSize(new Dimension(150, 25));
        this.tfObergrenze.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JDHCPKonfiguration.this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, JDHCPKonfiguration.this.tfObergrenze);
            }
        });
        JLabel lbNetzmaske = new JLabel(messages.getString("jdhcpkonfiguration_msg3"));
        this.tfNetzmaske = new JTextField(this.server.getSubnetzmaske());
        this.tfNetzmaske.setPreferredSize(new Dimension(150, 25));
        this.tfNetzmaske.setEditable(false);
        JLabel lbGateway = new JLabel(messages.getString("jdhcpkonfiguration_msg4"));
        this.tfGateway = new JTextField(this.server.determineGatewayip());
        this.tfGateway.setPreferredSize(new Dimension(150, 25));
        this.tfGateway.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JDHCPKonfiguration.this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, JDHCPKonfiguration.this.tfGateway);
            }
        });
        this.tfGateway.setEditable(this.server.isOwnSettings());
        JLabel lbDNSServer = new JLabel(messages.getString("jdhcpkonfiguration_msg5"));
        this.tfDNSServer = new JTextField(this.server.determineDnsserverip());
        this.tfDNSServer.setPreferredSize(new Dimension(150, 25));
        this.tfDNSServer.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JDHCPKonfiguration.this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, JDHCPKonfiguration.this.tfDNSServer);
            }
        });
        this.tfDNSServer.setEditable(this.server.isOwnSettings());
        jpDhcp.add(lbUntergrenze);
        jpDhcp.add(lbObergrenze);
        jpDhcp.add(lbNetzmaske);
        JPanel borderPanel = new JPanel();
        borderPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY, 2));
        borderPanel.setOpaque(false);
        jpDhcp.add(borderPanel);
        jpDhcp.add(this.tfUntergrenze);
        jpDhcp.add(this.tfObergrenze);
        jpDhcp.add(this.tfNetzmaske);
        jpDhcp.add(lbGateway);
        jpDhcp.add(lbDNSServer);
        jpDhcp.add(this.tfGateway);
        jpDhcp.add(this.tfDNSServer);
        JButton btUebernehmen = new JButton(messages.getString("jdhcpkonfiguration_msg7"));
        btUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JDHCPKonfiguration.this.speichern();
                JDHCPKonfiguration.this.update();
                config.setVisible(false);
            }
        });
        btUebernehmen.setSize(new Dimension(50, 30));
        JLabel lbAktiv = new JLabel(messages.getString("jdhcpkonfiguration_msg6"));
        lbAktiv.setPreferredSize(new Dimension(200, 15));
        this.cbAktiv = new JCheckBox();
        this.cbAktiv.setSelected(this.server.isAktiv());
        JLabel lbUseInternal = new JLabel(messages.getString("jdhcpkonfiguration_msg8"));
        lbUseInternal.setToolTipText(messages.getString("jdhcpkonfiguration_msg9"));
        this.cbUseInternal = new JCheckBox();
        this.cbUseInternal.addItemListener(this);
        this.cbUseInternal.setToolTipText(messages.getString("jdhcpkonfiguration_msg9"));
        this.cbUseInternal.setSelected(this.server.isOwnSettings());
        jpDhcp.add(lbUseInternal);
        jpDhcp.add(this.cbUseInternal);
        jpDhcp.add(lbAktiv);
        jpDhcp.add(this.cbAktiv);
        layout.putConstraint("North", (Component)lbUntergrenze, 20, "North", (Component)this.getContentPane());
        layout.putConstraint("West", (Component)lbUntergrenze, 25, "West", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)lbObergrenze, 20, "South", (Component)lbUntergrenze);
        layout.putConstraint("West", (Component)lbObergrenze, 25, "West", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)lbNetzmaske, 20, "South", (Component)lbObergrenze);
        layout.putConstraint("West", (Component)lbNetzmaske, 25, "West", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)lbGateway, 30, "South", (Component)lbNetzmaske);
        layout.putConstraint("West", (Component)lbGateway, 30, "West", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)lbDNSServer, 20, "South", (Component)lbGateway);
        layout.putConstraint("West", (Component)lbDNSServer, 30, "West", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)this.tfUntergrenze, 0, "North", (Component)lbUntergrenze);
        layout.putConstraint("West", (Component)this.tfUntergrenze, 200, "West", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)this.tfObergrenze, 0, "North", (Component)lbObergrenze);
        layout.putConstraint("West", (Component)this.tfObergrenze, 200, "West", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)this.tfNetzmaske, 0, "North", (Component)lbNetzmaske);
        layout.putConstraint("West", (Component)this.tfNetzmaske, 200, "West", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)this.tfGateway, 0, "North", (Component)lbGateway);
        layout.putConstraint("West", (Component)this.tfGateway, 195, "West", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)this.tfDNSServer, 0, "North", (Component)lbDNSServer);
        layout.putConstraint("West", (Component)this.tfDNSServer, 195, "West", (Component)this.getContentPane());
        layout.putConstraint("East", (Component)lbUseInternal, 0, "East", (Component)this.tfDNSServer);
        layout.putConstraint("North", (Component)lbUseInternal, 10, "South", (Component)this.tfDNSServer);
        layout.putConstraint("East", (Component)this.cbUseInternal, 0, "West", (Component)lbUseInternal);
        layout.putConstraint("South", (Component)this.cbUseInternal, 4, "South", (Component)lbUseInternal);
        layout.putConstraint("North", (Component)this.cbAktiv, 25, "South", (Component)lbUseInternal);
        layout.putConstraint("West", (Component)this.cbAktiv, 25, "West", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)lbAktiv, 4, "North", (Component)this.cbAktiv);
        layout.putConstraint("West", (Component)lbAktiv, 4, "East", (Component)this.cbAktiv);
        layout.putConstraint("North", (Component)borderPanel, 10, "South", (Component)this.tfNetzmaske);
        layout.putConstraint("West", (Component)borderPanel, 25, "West", (Component)this.getContentPane());
        borderPanel.setPreferredSize(new Dimension(325, 105));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add(messages.getString("jdhcpkonfiguration_msg10"), jpDhcp);
        this.tabbedPane.setPreferredSize(new Dimension(360, 320));
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setSize(360, 40);
        buttonPanel.add((Component)btUebernehmen, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.tabbedPane.add(messages.getString("jdhcpkonfiguration_msg11"), this.createStaticConfigPanel());
        this.update();
    }

    private JPanel createStaticConfigPanel() {
        JPanel staticConfigPanel = new JPanel(new BorderLayout());
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(5));
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        JLabel macAddressLabel = new JLabel(messages.getString("jdhcpkonfiguration_msg12"));
        macAddressLabel.setPreferredSize(new Dimension(170, 25));
        hBox.add(macAddressLabel);
        hBox.add(Box.createHorizontalStrut(5));
        final JTextField macAddressTextField = new JTextField();
        macAddressTextField.setPreferredSize(new Dimension(275, 25));
        macAddressTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JDHCPKonfiguration.this.ueberpruefen(EingabenUeberpruefung.musterMacAddress, macAddressTextField);
            }
        });
        hBox.add(macAddressTextField);
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(5));
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        JLabel ipAddressLabel = new JLabel(messages.getString("jdhcpkonfiguration_msg13"));
        ipAddressLabel.setPreferredSize(new Dimension(170, 25));
        hBox.add(ipAddressLabel);
        hBox.add(Box.createHorizontalStrut(5));
        final JTextField ipAddressTextField = new JTextField();
        ipAddressTextField.setPreferredSize(new Dimension(275, 25));
        ipAddressTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JDHCPKonfiguration.this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, ipAddressTextField);
            }
        });
        hBox.add(ipAddressTextField);
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(5));
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        JButton addButton = new JButton(messages.getString("jdhcpkonfiguration_msg14"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (JDHCPKonfiguration.this.ueberpruefen(EingabenUeberpruefung.musterMacAddress, macAddressTextField) && JDHCPKonfiguration.this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, ipAddressTextField)) {
                    ((DefaultTableModel)JDHCPKonfiguration.this.staticAddressTable.getModel()).addRow(new Object[]{macAddressTextField.getText(), ipAddressTextField.getText()});
                    macAddressTextField.setText("");
                    ipAddressTextField.setText("");
                }
            }
        });
        hBox.add(addButton);
        hBox.add(Box.createHorizontalStrut(5));
        JButton removeButton = new JButton(messages.getString("jdhcpkonfiguration_msg15"));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int zeilenNummer = JDHCPKonfiguration.this.staticAddressTable.getSelectedRow();
                if (zeilenNummer != -1) {
                    int i;
                    ArrayList<String> macAddresses = new ArrayList<String>();
                    ArrayList<String> ipAddresses = new ArrayList<String>();
                    for (i = 0; i < JDHCPKonfiguration.this.staticAddressTable.getModel().getRowCount(); ++i) {
                        if (i == zeilenNummer) continue;
                        macAddresses.add((String)JDHCPKonfiguration.this.staticAddressTable.getModel().getValueAt(i, 0));
                        ipAddresses.add((String)JDHCPKonfiguration.this.staticAddressTable.getModel().getValueAt(i, 1));
                    }
                    ((DefaultTableModel)JDHCPKonfiguration.this.staticAddressTable.getModel()).setRowCount(0);
                    for (i = 0; i < macAddresses.size() && i < ipAddresses.size(); ++i) {
                        ((DefaultTableModel)JDHCPKonfiguration.this.staticAddressTable.getModel()).addRow(new Object[]{macAddresses.get(i), ipAddresses.get(i)});
                    }
                }
            }
        });
        hBox.add(removeButton);
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(5));
        DefaultTableModel tabellenModell = new DefaultTableModel(0, 2);
        this.staticAddressTable = new JTableEditable((TableModel)tabellenModell, false);
        this.staticAddressTable.setIntercellSpacing(new Dimension(5, 5));
        this.staticAddressTable.setRowHeight(30);
        this.staticAddressTable.setShowGrid(false);
        this.staticAddressTable.setFillsViewportHeight(true);
        this.staticAddressTable.setBackground(Color.WHITE);
        this.staticAddressTable.setShowHorizontalLines(true);
        TableColumnModel tcm = this.staticAddressTable.getColumnModel();
        tcm.getColumn(0).setHeaderValue(messages.getString("jdhcpkonfiguration_msg12"));
        tcm.getColumn(1).setHeaderValue(messages.getString("jdhcpkonfiguration_msg13"));
        JScrollPane scrollPane = new JScrollPane(this.staticAddressTable);
        vBox.add(scrollPane);
        staticConfigPanel.add((Component)vBox, "Center");
        return staticConfigPanel;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JDHCPKonfiguration) itemStateChanged(" + e + "); source=" + e.getItemSelectable());
        ItemSelectable source = e.getItemSelectable();
        if (source == this.cbUseInternal) {
            if (this.cbUseInternal.isSelected()) {
                this.server.setOwnSettings(true);
                this.tfGateway.setEditable(true);
                this.tfDNSServer.setEditable(true);
            } else {
                this.server.setOwnSettings(false);
                this.tfGateway.setEditable(false);
                this.tfDNSServer.setEditable(false);
            }
            this.tfGateway.setText(this.server.determineGatewayip());
            this.tfDNSServer.setText(this.server.determineDnsserverip());
        }
    }

    private void update() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JDHCPKonfiguration), update()");
        this.tfObergrenze.setText(this.server.getObergrenze());
        this.tfUntergrenze.setText(this.server.getUntergrenze());
        this.tfNetzmaske.setText(this.server.getSubnetzmaske());
        this.tfGateway.setText(this.server.determineGatewayip());
        this.tfDNSServer.setText(this.server.determineDnsserverip());
        this.cbUseInternal.setSelected(this.server.isOwnSettings());
        this.cbAktiv.setSelected(this.server.isAktiv());
        ((DefaultTableModel)this.staticAddressTable.getModel()).setRowCount(0);
        for (DHCPAddressAssignment entry : this.server.holeStaticAssignedAddresses()) {
            ((DefaultTableModel)this.staticAddressTable.getModel()).addRow(new Object[]{entry.getMAC(), entry.getIp()});
        }
    }

    public boolean ueberpruefen(Pattern pruefRegel, JTextField feld) {
        if (EingabenUeberpruefung.isGueltig(feld.getText(), pruefRegel)) {
            feld.setForeground(EingabenUeberpruefung.farbeRichtig);
            JTextField test = new JTextField();
            feld.setBorder(test.getBorder());
            return true;
        }
        feld.setForeground(EingabenUeberpruefung.farbeFalsch);
        feld.setForeground(EingabenUeberpruefung.farbeFalsch);
        feld.setBorder(BorderFactory.createLineBorder(EingabenUeberpruefung.farbeFalsch, 1));
        return false;
    }

    private void speichern() {
        if (this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, this.tfObergrenze)) {
            this.server.setObergrenze(this.tfObergrenze.getText());
        }
        if (this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, this.tfUntergrenze)) {
            this.server.setUntergrenze(this.tfUntergrenze.getText());
        }
        if (this.cbUseInternal.isSelected()) {
            this.server.setOwnSettings(true);
            if (this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, this.tfGateway)) {
                this.server.setGatewayip(this.tfGateway.getText());
            }
            if (this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, this.tfDNSServer)) {
                this.server.setDnsserverip(this.tfDNSServer.getText());
            }
        } else {
            this.server.setOwnSettings(false);
        }
        this.server.setAktiv(this.cbAktiv.isSelected());
        this.server.clearStaticAssignments();
        for (int i = 0; i < this.staticAddressTable.getRowCount(); ++i) {
            this.server.addStaticAssignment((String)this.staticAddressTable.getValueAt(i, 0), (String)this.staticAddressTable.getValueAt(i, 1));
        }
    }
}

