/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.nachrichtensicht;

import filius.Main;
import filius.gui.JMainFrame;
import filius.gui.nachrichtensicht.AggregatedExchangeDialog;
import filius.gui.nachrichtensicht.LauscherTableCellRenderer;
import filius.gui.nachrichtensicht.LauscherTableModel;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.SzenarioVerwaltung;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.rahmenprogramm.nachrichten.LauscherBeobachter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class AggregatedMessageTable
extends JTable
implements LauscherBeobachter,
I18n {
    private static final int EXPORT_MAX_LINES_PER_MESSAGE = 5;
    private static final long serialVersionUID = 1L;
    public static final int SCHICHT_SPALTE = 5;
    public static final int BEMERKUNG_SPALTE = 6;
    public static final int LFD_NR_SPALTE = 0;
    private String interfaceId;
    private JCheckBoxMenuItem checkbox;
    private AggregatedExchangeDialog dialog;
    private JScrollPane scrollPane = null;
    private boolean autoscroll = true;
    private JPopupMenu menu;

    public AggregatedMessageTable(AggregatedExchangeDialog dialog, String macAddress) {
        this.dialog = dialog;
        this.setinterfaceId(macAddress);
        this.initTableModel();
        this.setAutoResizeMode(3);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        String[] spalten = Lauscher.SPALTEN;
        for (int i = 0; i < spalten.length; ++i) {
            TableColumn col = new TableColumn();
            col.setHeaderValue(spalten[i]);
            col.setIdentifier(spalten[i]);
            col.setModelIndex(i);
            columnModel.addColumn(col);
        }
        this.setColumnModel(columnModel);
        this.setIntercellSpacing(new Dimension(0, 5));
        this.setRowHeight(25);
        this.setEnabled(true);
        this.setSelectionMode(0);
        this.setShowGrid(false);
        this.setColumnSelectionAllowed(false);
        this.setBackground(Color.DARK_GRAY);
        this.getTableHeader().setReorderingAllowed(false);
        this.setFillsViewportHeight(true);
        this.initTableColumnWidth();
        this.setDefaultRenderer(Object.class, new LauscherTableCellRenderer());
        this.initKontextMenue();
        this.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    AggregatedMessageTable.this.menu.setVisible(true);
                    AggregatedMessageTable.this.menu.show(AggregatedMessageTable.this.getTabelle(), e.getX(), e.getY());
                }
            }
        });
        this.update();
    }

    private void initTableModel() {
        LauscherTableModel tableModel = new LauscherTableModel();
        tableModel.addTableModelListener(this);
        tableModel.setColumnIdentifiers(Lauscher.SPALTEN);
        this.setModel(tableModel);
    }

    public void setScrollPane(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
    }

    private AggregatedMessageTable getTabelle() {
        return this;
    }

    private void initTableColumnWidth() {
        this.getColumnModel().getColumn(0).setMaxWidth(40);
        this.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.getColumnModel().getColumn(1).setMaxWidth(120);
        this.getColumnModel().getColumn(1).setPreferredWidth(90);
        this.getColumnModel().getColumn(2).setMaxWidth(180);
        this.getColumnModel().getColumn(2).setPreferredWidth(160);
        this.getColumnModel().getColumn(3).setMaxWidth(180);
        this.getColumnModel().getColumn(3).setPreferredWidth(160);
        this.getColumnModel().getColumn(4).setMaxWidth(100);
        this.getColumnModel().getColumn(4).setPreferredWidth(70);
        this.getColumnModel().getColumn(5).setMaxWidth(140);
        this.getColumnModel().getColumn(5).setPreferredWidth(100);
        this.getColumnModel().getColumn(6).setMaxWidth(Integer.MAX_VALUE);
        this.getColumnModel().getColumn(6).setPreferredWidth(460);
        this.getColumnModel().getColumn(6).setResizable(true);
    }

    private void initKontextMenue() {
        this.menu = new JPopupMenu();
        JMenuItem resetMenuItem = new JMenuItem(messages.getString("nachrichtentabelle_msg7"));
        resetMenuItem.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AggregatedMessageTable.this.menu.setVisible(false);
                Lauscher.getLauscher().reset();
            }
        });
        this.menu.add(resetMenuItem);
        JMenuItem exportMenuItem = new JMenuItem(messages.getString("nachrichtentabelle_msg9"));
        exportMenuItem.addMouseListener(new MouseInputAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void mousePressed(MouseEvent e) {
                AggregatedMessageTable.this.menu.setVisible(false);
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.getName().endsWith(".txt");
                    }

                    @Override
                    public String getDescription() {
                        return "Text file";
                    }
                });
                String path = SzenarioVerwaltung.getInstance().holePfad();
                if (path != null) {
                    File preselectedFile = new File(AggregatedMessageTable.this.dialog.getTabTitle(AggregatedMessageTable.this.interfaceId) + ".txt");
                    fileChooser.setSelectedFile(preselectedFile);
                }
                if (fileChooser.showSaveDialog(JMainFrame.getJMainFrame()) == 0 && fileChooser.getSelectedFile() != null) {
                    File outFile = fileChooser.getSelectedFile();
                    if (StringUtils.endsWith(outFile.getName(), ".txt")) {
                        outFile = new File(outFile.getParentFile(), outFile.getName() + ".txt");
                    }
                    FileOutputStream outputStream = null;
                    try {
                        outputStream = new FileOutputStream(fileChooser.getSelectedFile());
                        AggregatedMessageTable.this.writeToStream(outputStream);
                    }
                    catch (IOException iOException) {
                        IOUtils.closeQuietly(outputStream);
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(outputStream);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly(outputStream);
                }
            }
        });
        this.menu.add(exportMenuItem);
        this.checkbox = new JCheckBoxMenuItem(messages.getString("nachrichtentabelle_msg8"), this.autoscroll);
        this.checkbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AggregatedMessageTable.this.autoscroll != AggregatedMessageTable.this.checkbox.getState()) {
                    AggregatedMessageTable.this.menu.setVisible(false);
                    AggregatedMessageTable.this.autoscroll = AggregatedMessageTable.this.checkbox.getState();
                    AggregatedMessageTable.this.update();
                }
            }
        });
        this.menu.add(this.checkbox);
        this.menu.setVisible(false);
        this.dialog.getRootPane().getLayeredPane().add(this.menu);
    }

    private void setinterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
        Lauscher.getLauscher().addBeobachter(interfaceId, this);
    }

    @Override
    public synchronized void update() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (NachrichtenTabelle), update()");
        Object[][] daten = Lauscher.getLauscher().getDaten(this.interfaceId, true);
        if (daten.length == 0) {
            this.initTableModel();
            this.initTableColumnWidth();
        }
        int lastNo = -1;
        if (this.getModel().getRowCount() > 0) {
            lastNo = Integer.parseInt(this.getModel().getValueAt(this.getModel().getRowCount() - 1, 0).toString());
        }
        int currentNo = 1;
        int previousNo = 1;
        for (int i = 0; i < daten.length; ++i) {
            currentNo = Integer.parseInt(daten[i][0].toString());
            if (currentNo <= lastNo || currentNo == previousNo || currentNo <= previousNo || previousNo <= lastNo || i <= 0) continue;
            Object[] row = daten[i - 1];
            this.addRowData(row);
            previousNo = currentNo;
        }
        if (currentNo > lastNo && daten.length > 0) {
            this.addRowData(daten[daten.length - 1]);
        }
        ((DefaultTableModel)this.getModel()).fireTableDataChanged();
        if (this.getRowCount() > 0 && this.scrollPane != null && this.scrollPane.getViewport() != null && this.autoscroll) {
            this.scrollPane.getViewport().setViewPosition(new Point(0, this.getHeight()));
        }
    }

    private void addRowData(Object[] row) {
        Vector<Object> rowData = new Vector<Object>(row.length);
        for (int col = 0; col < row.length; ++col) {
            rowData.add(col, row[col]);
        }
        ((DefaultTableModel)this.getModel()).addRow(rowData);
    }

    @Override
    public synchronized void writeToStream(OutputStream outputStream) throws IOException {
        Object[] columnNames = this.getColumnHeader();
        StringBuilder tmplBuilder = new StringBuilder("| ");
        StringBuilder lineSeparatorBuilder = new StringBuilder("+");
        for (int colIdx = 0; colIdx < this.getColumnCount(); ++colIdx) {
            if (colIdx == 6) {
                tmplBuilder.append("%-40s | ");
                lineSeparatorBuilder.append(StringUtils.repeat('-', 42) + "+");
                continue;
            }
            if (colIdx == 0) {
                tmplBuilder.append("%-10s | ");
                lineSeparatorBuilder.append(StringUtils.repeat('-', 12) + "+");
                continue;
            }
            tmplBuilder.append("%-20s | ");
            lineSeparatorBuilder.append(StringUtils.repeat('-', 22) + "+");
        }
        tmplBuilder.append("\r\n");
        String rowTemplate = tmplBuilder.toString();
        lineSeparatorBuilder.append("\r\n");
        String lineSeparator = lineSeparatorBuilder.toString();
        outputStream.write(lineSeparator.replace('-', '=').getBytes("UTF8"));
        outputStream.write(String.format(rowTemplate, columnNames).getBytes("UTF8"));
        outputStream.write(lineSeparator.replace('-', '=').getBytes("UTF8"));
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            String[] values = new String[this.getColumnCount()];
            for (int columnIndex = 0; columnIndex < this.getColumnCount(); ++columnIndex) {
                values[columnIndex] = this.getModel().getValueAt(rowIndex, columnIndex).toString();
            }
            List<String[]> lineData = AggregatedMessageTable.prepareDataArrays(values, 40);
            for (Object[] objectArray : lineData) {
                outputStream.write(String.format(rowTemplate, objectArray).getBytes("UTF8"));
            }
            outputStream.write(lineSeparator.getBytes("UTF8"));
        }
    }

    public Object[] getColumnHeader() {
        Object[] columnNames = new Object[this.getColumnCount()];
        for (int colIdx = 0; colIdx < this.getColumnCount(); ++colIdx) {
            columnNames[colIdx] = this.getColumnName(colIdx);
        }
        return columnNames;
    }

    static List<String[]> prepareDataArrays(String[] values, int maxRemarkLength) {
        List<Object> remarks = Collections.emptyList();
        Object[] data = new String[values.length];
        for (int columnIndex = 0; columnIndex < values.length; ++columnIndex) {
            if (columnIndex == 6) {
                if (!StringUtils.isNoneBlank(values[columnIndex])) continue;
                remarks = AggregatedMessageTable.splitString(values[columnIndex].toString(), maxRemarkLength);
                data[columnIndex] = (String)remarks.get(0);
                continue;
            }
            data[columnIndex] = values[columnIndex];
        }
        ArrayList<String[]> lineData = new ArrayList<String[]>();
        lineData.add((String[])data);
        for (int i = 1; i < remarks.size() && i < 5; ++i) {
            data = new String[values.length];
            Arrays.fill(data, "");
            data[6] = (String)remarks.get(i);
            lineData.add((String[])data);
        }
        if (remarks.size() > 5) {
            data = new String[values.length];
            Arrays.fill(data, "");
            data[6] = "...";
            lineData.add((String[])data);
        }
        return lineData;
    }

    static List<String> splitString(String text, int maxLength) {
        String normalizedText = StringUtils.normalizeSpace(text);
        String[] tokens = normalizedText.split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        int currentLength = 0;
        StringBuilder lineBuilder = new StringBuilder();
        for (String token : tokens) {
            if (currentLength + token.length() <= maxLength) {
                lineBuilder.append(token).append(" ");
                currentLength += token.length() + 1;
                continue;
            }
            if (token.length() > maxLength) {
                if (currentLength > 0) {
                    lines.add(lineBuilder.toString().trim());
                }
                String[] parts = token.split("(?<=\\G.{" + maxLength + "})");
                for (int i = 0; i < parts.length - 1; ++i) {
                    lines.add(parts[i]);
                }
                lineBuilder = new StringBuilder(parts[parts.length - 1]).append(" ");
                currentLength = parts[parts.length - 1].length() + 1;
                continue;
            }
            lines.add(lineBuilder.toString().trim());
            lineBuilder = new StringBuilder(token).append(" ");
            currentLength = token.length() + 1;
        }
        lines.add(lineBuilder.toString().trim());
        return lines;
    }
}

