/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.nachrichtensicht;

import filius.gui.nachrichtensicht.AggregatedMessageTable;
import filius.gui.nachrichtensicht.ExchangeDialog;
import filius.hardware.knoten.Host;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.system.SystemSoftware;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class AggregatedExchangeDialog
extends JDialog
implements ExchangeDialog,
I18n {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabbedPane;
    private static AggregatedExchangeDialog instance = null;
    private Hashtable<String, JPanel> openedTabs = new Hashtable();
    private Hashtable<String, InternetKnotenBetriebssystem> systems = new Hashtable();
    private Hashtable<String, AggregatedMessageTable> tabellen = new Hashtable();

    public static AggregatedExchangeDialog getInstance(Frame owner) {
        if (instance == null) {
            instance = new AggregatedExchangeDialog(owner);
        }
        return instance;
    }

    @Override
    public void reset() {
        if (instance != null) {
            instance.setVisible(false);
        }
        instance = null;
    }

    public AggregatedExchangeDialog() {
    }

    private AggregatedExchangeDialog(Frame owner) {
        super(owner);
        ((JFrame)owner).getLayeredPane().setLayer(this, JLayeredPane.PALETTE_LAYER);
        this.setTitle(messages.getString("lauscherdialog_msg1"));
        int screenHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        int screenWidth = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setBounds(screenWidth / 2, screenHeight / 10, screenWidth / 2, 4 * screenHeight / 5);
        Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/gfx/allgemein/nachrichtenfenster_icon.png"));
        this.setIconImage(image);
        this.setModal(false);
        this.setDefaultCloseOperation(1);
        this.tabbedPane = new JTabbedPane();
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.setVisible(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                AggregatedExchangeDialog.this.updateTabTitle();
                AggregatedExchangeDialog.this.clearUnavailableComponents();
            }
        });
    }

    @Override
    public void addTable(SystemSoftware system, String identifier) {
        final MessageDetailsPanel detailsPanel = new MessageDetailsPanel(identifier);
        if (this.openedTabs.get(identifier) == null) {
            final AggregatedMessageTable tabelle = new AggregatedMessageTable(this, identifier);
            tabelle.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (tabelle.getSelectedRow() >= 0) {
                        detailsPanel.update(tabelle.getValueAt(tabelle.getSelectedRow(), 0));
                    } else {
                        detailsPanel.clear();
                    }
                }
            });
            JPanel panel = new JPanel(new BorderLayout());
            JScrollPane scrollPane = new JScrollPane(tabelle);
            tabelle.setScrollPane(scrollPane);
            JSplitPane splitPane = new JSplitPane();
            splitPane.setOrientation(0);
            splitPane.setTopComponent(scrollPane);
            splitPane.setBottomComponent(new JScrollPane(detailsPanel));
            panel.add((Component)splitPane, "Center");
            this.tabbedPane.add(panel);
            this.tabbedPane.setSelectedComponent(panel);
            TabTitle title = new TabTitle(this, identifier);
            this.tabbedPane.setTabComponentAt(this.tabbedPane.getSelectedIndex(), title);
            this.openedTabs.put(identifier, panel);
            this.systems.put(identifier, (InternetKnotenBetriebssystem)system);
            this.tabellen.put(identifier, tabelle);
            this.updateTabTitle();
        } else {
            this.tabbedPane.setSelectedComponent(this.openedTabs.get(identifier));
            this.tabellen.get(identifier).update();
        }
    }

    private void updateTabTitle() {
        block0: for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            for (String identifier : this.openedTabs.keySet()) {
                if (!this.tabbedPane.getComponentAt(i).equals(this.openedTabs.get(identifier))) continue;
                SystemSoftware system = this.systems.get(identifier);
                String ipAddress = ((InternetKnoten)system.getKnoten()).getNetzwerkInterfaceByMac(identifier).getIp();
                String tabTitle = system.getKnoten() instanceof Host && ((Host)system.getKnoten()).isUseIPAsName() ? ipAddress : system.getKnoten().holeAnzeigeName() + " - " + ipAddress;
                TabTitle titlePanel = (TabTitle)this.tabbedPane.getTabComponentAt(i);
                titlePanel.setTitle(tabTitle);
                continue block0;
            }
        }
    }

    private void clearUnavailableComponents() {
        for (Map.Entry<String, InternetKnotenBetriebssystem> system : this.systems.entrySet()) {
            if (system.getValue().isStarted()) continue;
            this.removeTable(system.getKey());
        }
    }

    private void removeTable(String mac) {
        this.removeTable(mac, this.openedTabs.get(mac));
    }

    @Override
    public void removeTable(String mac, JPanel panel) {
        if (mac != null) {
            this.openedTabs.remove(mac);
            this.tabellen.remove(mac);
            this.tabbedPane.remove(panel);
        }
    }

    public String getTabTitle(String interfaceId) {
        String title = interfaceId.replaceAll(":", "-");
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            Component tab = this.tabbedPane.getComponentAt(i);
            if (tab != this.openedTabs.get(interfaceId)) continue;
            title = ((TabTitle)this.tabbedPane.getTabComponentAt(i)).getTitle();
            break;
        }
        return title;
    }

    private class MessageDetailsPanel
    extends JPanel {
        private String macAddress;

        public MessageDetailsPanel(String macAddress) {
            this.macAddress = macAddress;
            this.setLayout(new BorderLayout());
            this.setBackground(Color.WHITE);
        }

        public void clear() {
            this.removeAll();
            this.updateUI();
        }

        public void update(Object messageNo) {
            if (messageNo != null) {
                int dataSetNo;
                Object[][] daten = Lauscher.getLauscher().getDaten(this.macAddress, false);
                int number = Integer.parseInt(messageNo.toString());
                int currNo = 0;
                for (dataSetNo = 0; dataSetNo < daten.length && (currNo = Integer.parseInt(daten[dataSetNo][0].toString())) != number; ++dataSetNo) {
                }
                Object[] dataSet = daten[dataSetNo];
                DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(I18n.messages.getString("rp_lauscher_msg1") + ": " + dataSet[0] + " / " + I18n.messages.getString("rp_lauscher_msg2") + ": " + dataSet[1]);
                while (dataSetNo < daten.length && Integer.parseInt(daten[dataSetNo][0].toString()) == number) {
                    DefaultMutableTreeNode dateNode;
                    dataSet = daten[dataSetNo];
                    DefaultMutableTreeNode layerNode = new DefaultMutableTreeNode(dataSet[5], true);
                    if (dataSet[2] != null && !dataSet[2].toString().isEmpty()) {
                        String srcLabel = String.format("%-15s", I18n.messages.getString("rp_lauscher_msg3") + ": ");
                        dateNode = new DefaultMutableTreeNode(srcLabel + dataSet[2]);
                        layerNode.add(dateNode);
                    }
                    if (dataSet[3] != null && !dataSet[3].toString().isEmpty()) {
                        String destLabel = String.format("%-15s", I18n.messages.getString("rp_lauscher_msg4") + ": ");
                        dateNode = new DefaultMutableTreeNode(destLabel + dataSet[3]);
                        layerNode.add(dateNode);
                    }
                    if (dataSet[4] != null && !dataSet[4].toString().isEmpty()) {
                        String protocolLabel = String.format("%-15s", I18n.messages.getString("rp_lauscher_msg5") + ": ");
                        dateNode = new DefaultMutableTreeNode(protocolLabel + dataSet[4]);
                        layerNode.add(dateNode);
                    }
                    if (dataSet[6] != null && !dataSet[6].toString().isEmpty()) {
                        String contentLabel = String.format("%-15s", I18n.messages.getString("rp_lauscher_msg7") + ": ");
                        if (dataSet[6].toString().contains("\n")) {
                            DefaultMutableTreeNode labelNode = new DefaultMutableTreeNode(contentLabel);
                            dateNode = new DefaultMutableTreeNode(dataSet[6]);
                            labelNode.add(dateNode);
                            layerNode.add(labelNode);
                        } else {
                            dateNode = new DefaultMutableTreeNode(contentLabel + dataSet[6]);
                            layerNode.add(dateNode);
                        }
                    }
                    rootNode.add(layerNode);
                    ++dataSetNo;
                }
                JTree detailsTree = new JTree(rootNode);
                for (int i = 0; i < detailsTree.getRowCount(); ++i) {
                    detailsTree.expandRow(i);
                }
                detailsTree.setCellRenderer(new MultiLineCellRenderer());
                this.removeAll();
                this.add((Component)detailsTree, "West");
                this.updateUI();
            }
        }
    }

    private class TabTitle
    extends JPanel {
        private JLabel label;

        TabTitle(final AggregatedExchangeDialog parent, final String identifier) {
            this.setOpaque(false);
            this.label = new JLabel();
            this.add((Component)this.label, "West");
            JButton btnClose = new JButton("X");
            btnClose.setUI(new BasicButtonUI());
            btnClose.setForeground(Color.GRAY);
            btnClose.setBorder(BorderFactory.createEmptyBorder());
            btnClose.setPreferredSize(new Dimension(18, 18));
            btnClose.setToolTipText(I18n.messages.getString("buttontabcomponent_msg1"));
            this.add((Component)btnClose, "East");
            btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    parent.removeTable(identifier);
                    if (parent.openedTabs.size() == 0) {
                        parent.setVisible(false);
                    }
                }
            });
        }

        void setTitle(String title) {
            this.label.setText(title);
        }

        String getTitle() {
            return this.label.getText();
        }
    }

    class MultiLineCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected JLabel icon;
        protected TreeTextArea text;

        public MultiLineCellRenderer() {
            this.setLayout(new BoxLayout(this, 2));
            this.icon = new JLabel(){

                @Override
                public void setBackground(Color color) {
                    if (color instanceof ColorUIResource) {
                        color = null;
                    }
                    super.setBackground(color);
                }
            };
            this.add(this.icon);
            this.add(Box.createHorizontalStrut(4));
            this.text = new TreeTextArea();
            this.add(this.text);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
            this.setEnabled(tree.isEnabled());
            this.text.setText(stringValue);
            this.text.setSelect(isSelected);
            this.text.setFocus(hasFocus);
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension iconD = this.icon.getPreferredSize();
            Dimension textD = this.text.getPreferredSize();
            int height = iconD.height < textD.height ? textD.height : iconD.height;
            return new Dimension(iconD.width + textD.width, height);
        }

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        class TreeTextArea
        extends JTextArea {
            Dimension preferredSize;

            TreeTextArea() {
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
                this.setOpaque(true);
                Font font = this.getFont();
                this.setFont(new Font("Monospaced", 1, font.getSize()));
            }

            @Override
            public void setBackground(Color color) {
                if (color instanceof ColorUIResource) {
                    color = null;
                }
                super.setBackground(color);
            }

            @Override
            public void setPreferredSize(Dimension d) {
                if (d != null) {
                    this.preferredSize = d;
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }

            @Override
            public void setText(String str) {
                Font font = this.getFont();
                FontMetrics fm = this.getToolkit().getFontMetrics(font);
                BufferedReader br = new BufferedReader(new StringReader(str));
                int maxWidth = 0;
                int lines = 0;
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        int width = SwingUtilities.computeStringWidth(fm, line);
                        if (maxWidth < width) {
                            maxWidth = width;
                        }
                        ++lines;
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                lines = lines < 1 ? 1 : lines;
                int height = fm.getHeight() * lines;
                this.setPreferredSize(new Dimension(maxWidth + 12, height));
                super.setText(str);
            }

            void setSelect(boolean isSelected) {
                Color bColor = isSelected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground");
                super.setBackground(bColor);
            }

            void setFocus(boolean hasFocus) {
                if (hasFocus) {
                    Color lineColor = UIManager.getColor("Tree.selectionBorderColor");
                    this.setBorder(BorderFactory.createLineBorder(lineColor));
                } else {
                    this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                }
            }
        }
    }
}

