/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.hardware.knoten.Host;
import filius.hardware.knoten.Knoten;
import filius.hardware.knoten.Notebook;
import filius.hardware.knoten.Rechner;
import filius.software.system.Betriebssystem;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class GUIDesktopWindow
extends JFrame
implements Observer {
    private static final long serialVersionUID = 1L;
    private GUIDesktopPanel desktopPanel;

    public GUIDesktopWindow(Betriebssystem bs) {
        bs.addObserver(this);
        String imageFile = null;
        Knoten hardware = bs.getKnoten();
        if (hardware instanceof Rechner) {
            imageFile = "gfx/hardware/server.png";
        } else if (hardware instanceof Notebook) {
            imageFile = "gfx/hardware/laptop.png";
        }
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/" + imageFile));
        this.setIconImage(icon.getImage());
        this.setSize(640, 480);
        this.setResizable(false);
        this.desktopPanel = new GUIDesktopPanel(bs);
        this.getContentPane().add(this.desktopPanel);
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        this.updateTitle();
        if (flag) {
            this.toFront();
        }
    }

    private void updateTitle() {
        Host host = (Host)this.desktopPanel.getBetriebssystem().getKnoten();
        String title = host.isUseIPAsName() ? this.desktopPanel.getBetriebssystem().getKnoten().holeAnzeigeName() : this.desktopPanel.getBetriebssystem().getKnoten().holeAnzeigeName() + " - " + this.desktopPanel.getBetriebssystem().holeIPAdresse();
        this.setTitle(title);
    }

    public Betriebssystem getBetriebssystem() {
        return this.desktopPanel.getBetriebssystem();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateTitle();
    }

    public static enum Mode {
        ROW(0),
        COLUMN(1),
        STACK(2);

        private final int value;

        private Mode(int mode) {
            this.value = mode;
        }

        public static Mode getMode(int value) {
            if (value == Mode.ROW.value) {
                return ROW;
            }
            if (value == Mode.COLUMN.value) {
                return COLUMN;
            }
            return STACK;
        }
    }
}

