/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.Main;
import filius.gui.CloseableBrowserTabbedPaneUI;
import filius.gui.anwendungssicht.DMTNFileChooser;
import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.rahmenprogramm.I18n;
import filius.software.system.Betriebssystem;
import filius.software.system.Datei;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ListIterator;
import java.util.Observable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;

public class GUIApplicationTextEditorWindow
extends GUIApplicationWindow {
    private static final long serialVersionUID = 1L;
    private JTextArea editorField;
    private JPanel backPanel;
    private GUIApplicationWindow diesesFenster = this;
    private Datei aktuelleDatei = null;
    private String original = "";
    private DefaultMutableTreeNode arbeitsVerzeichnis;
    private JTabbedPane tpTabs;

    public GUIApplicationTextEditorWindow(GUIDesktopPanel desktop, String appName) {
        super(desktop, appName);
        this.setTitle(messages.getString("texteditor_msg1"));
        this.editorField = new JTextArea("");
        this.editorField.setEditable(true);
        this.editorField.setFont(new Font("Courier New", 0, 11));
        this.arbeitsVerzeichnis = this.holeAnwendung().getSystemSoftware().getDateisystem().getArbeitsVerzeichnis();
        String dateiName = this.holeParameter()[0];
        if (!dateiName.equals("")) {
            Datei datei;
            if (this.arbeitsVerzeichnis == null) {
                this.arbeitsVerzeichnis = this.holeAnwendung().getSystemSoftware().getDateisystem().getRoot();
            }
            if ((datei = this.holeAnwendung().getSystemSoftware().getDateisystem().holeDatei(this.arbeitsVerzeichnis, dateiName)) != null) {
                this.setTitle(dateiName);
                this.editorField.setText(datei.getDateiInhalt());
                this.original = datei.getDateiInhalt();
                this.aktuelleDatei = datei;
            }
        }
        JScrollPane tpPane = new JScrollPane(this.editorField);
        tpPane.setBorder(null);
        this.tpTabs = new JTabbedPane();
        this.tpTabs.setUI(new CloseableBrowserTabbedPaneUI());
        Box editorBox = Box.createHorizontalBox();
        editorBox.add(tpPane);
        editorBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tabVerhalten();
        this.backPanel = new JPanel(new BorderLayout());
        this.backPanel.add((Component)editorBox, "Center");
        this.getContentPane().add(this.backPanel);
        JMenuBar mb = new JMenuBar();
        JMenu menuDatei = new JMenu(messages.getString("texteditor_msg2"));
        menuDatei.add(new AbstractAction(messages.getString("texteditor_msg3")){
            private static final long serialVersionUID = 4307765243000198382L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUIApplicationTextEditorWindow.this.neu();
            }
        });
        menuDatei.add(new AbstractAction(messages.getString("texteditor_msg4")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUIApplicationTextEditorWindow.this.oeffnen();
            }
        });
        menuDatei.add(new AbstractAction(messages.getString("texteditor_msg5")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUIApplicationTextEditorWindow.this.speichern();
            }
        });
        menuDatei.add(new AbstractAction(messages.getString("texteditor_msg6")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUIApplicationTextEditorWindow.this.speichernUnter();
            }
        });
        menuDatei.addSeparator();
        menuDatei.add(new AbstractAction(messages.getString("texteditor_msg7")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUIApplicationTextEditorWindow.this.beenden();
            }
        });
        mb.add(menuDatei);
        this.setJMenuBar(mb);
        this.pack();
    }

    public void speichern() {
        if (this.aktuelleDatei != null) {
            this.original = this.editorField.getText();
            this.aktuelleDatei.setDateiInhalt(this.original);
        } else {
            this.speichernUnter();
        }
    }

    public void speichernUnter() {
        DMTNFileChooser fc = new DMTNFileChooser((Betriebssystem)this.holeAnwendung().getSystemSoftware());
        int rueckgabe = fc.saveDialog();
        if (rueckgabe == 1) {
            String dateiNameNeu = fc.getAktuellerDateiname();
            Datei tmpFile = new Datei(dateiNameNeu, messages.getString("texteditor_msg8"), this.editorField.getText());
            this.holeAnwendung().getSystemSoftware().getDateisystem().speicherDatei(fc.getAktuellerOrdner(), tmpFile);
            this.changeCurrentFile(tmpFile);
        }
    }

    public void changeCurrentFile(Datei tmpFile) {
        if (this.aktuelleDatei != null) {
            this.aktuelleDatei.deleteObserver(this);
        }
        this.aktuelleDatei = tmpFile;
        this.updateFromFile();
        if (this.aktuelleDatei != null) {
            this.aktuelleDatei.addObserver(this);
        }
    }

    public void oeffnen() {
        DMTNFileChooser fc = new DMTNFileChooser((Betriebssystem)this.holeAnwendung().getSystemSoftware());
        int rueckgabe = fc.openDialog();
        if (rueckgabe == 1) {
            String aktuellerDateiname = fc.getAktuellerDateiname();
            Datei tmpFile = this.holeAnwendung().getSystemSoftware().getDateisystem().holeDatei(fc.getAktuellerOrdner(), aktuellerDateiname);
            this.changeCurrentFile(tmpFile);
        } else {
            Main.debug.println("ERROR (" + this.hashCode() + "): Fehler beim oeffnen einer Datei");
        }
    }

    private void updateFromFile() {
        if (this.aktuelleDatei != null) {
            this.setTitle(this.aktuelleDatei.getName());
            this.original = this.aktuelleDatei.getDateiInhalt();
            this.editorField.setText(this.original);
        } else {
            Main.debug.println("ERROR (" + this.hashCode() + "): Fehler beim oeffnen einer Datei: keine Datei ausgewaehlt");
        }
    }

    public void beenden() {
        if (this.original != this.editorField.getText() && JOptionPane.showConfirmDialog(this, messages.getString("texteditor_msg9"), messages.getString("texteditor_msg10"), 0) == 0) {
            this.speichern();
        }
        this.diesesFenster.doDefaultCloseAction();
    }

    @Override
    public void starten(String[] param) {
        String dateiName = this.holeParameter()[0];
        if (!dateiName.equals("")) {
            Datei datei;
            this.arbeitsVerzeichnis = this.holeAnwendung().getSystemSoftware().getDateisystem().getArbeitsVerzeichnis();
            if (this.arbeitsVerzeichnis == null) {
                this.arbeitsVerzeichnis = this.holeAnwendung().getSystemSoftware().getDateisystem().getRoot();
            }
            if ((datei = this.holeAnwendung().getSystemSoftware().getDateisystem().holeDatei(this.arbeitsVerzeichnis, dateiName)) != null) {
                this.editorField = new JTextArea();
                this.editorField.setFont(new Font("Courier New", 0, 11));
                this.setTitle(dateiName);
                this.editorField.setText(datei.getDateiInhalt());
                this.original = datei.getDateiInhalt();
                this.aktuelleDatei = datei;
                JScrollPane tpPane = new JScrollPane(this.editorField);
                tpPane.setBorder(null);
                this.tpTabs.addTab(datei.getName(), tpPane);
                this.tpTabs.setSelectedIndex(this.tpTabs.getTabCount() - 1);
            }
        }
    }

    public void tabVerhalten() {
        this.tpTabs.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getButton() == 3) {
                    JPopupMenu popmen = new JPopupMenu();
                    final JMenuItem miTabsSchliessen = new JMenuItem(I18n.messages.getString("texteditor_msg11"));
                    miTabsSchliessen.setActionCommand("tabsschliessen");
                    final JMenuItem miAndereTabsSchliessen = new JMenuItem(I18n.messages.getString("texteditor_msg12"));
                    miAndereTabsSchliessen.setActionCommand("anderetabsschliessen");
                    ActionListener al = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (e.getActionCommand().equals(miTabsSchliessen.getActionCommand())) {
                                while (GUIApplicationTextEditorWindow.this.tpTabs.getTabCount() > 0) {
                                    GUIApplicationTextEditorWindow.this.tpTabs.remove(GUIApplicationTextEditorWindow.this.tpTabs.getTabCount() - 1);
                                }
                            }
                            if (e.getActionCommand().equals(miAndereTabsSchliessen.getActionCommand())) {
                                Component komponente = GUIApplicationTextEditorWindow.this.tpTabs.getSelectedComponent();
                                String tmpTitel = GUIApplicationTextEditorWindow.this.tpTabs.getTitleAt(GUIApplicationTextEditorWindow.this.tpTabs.getSelectedIndex());
                                while (GUIApplicationTextEditorWindow.this.tpTabs.getTabCount() > 0) {
                                    GUIApplicationTextEditorWindow.this.tpTabs.remove(GUIApplicationTextEditorWindow.this.tpTabs.getTabCount() - 1);
                                }
                                if (komponente != null) {
                                    GUIApplicationTextEditorWindow.this.tpTabs.addTab(tmpTitel, komponente);
                                    GUIApplicationTextEditorWindow.this.tpTabs.setSelectedComponent(komponente);
                                }
                            }
                        }
                    };
                    miTabsSchliessen.addActionListener(al);
                    miAndereTabsSchliessen.addActionListener(al);
                    popmen.add(miTabsSchliessen);
                    popmen.add(miAndereTabsSchliessen);
                    popmen.setVisible(true);
                    GUIApplicationTextEditorWindow.this.zeigePopupMenu(popmen, me.getX(), me.getY());
                }
                if (me.getButton() == 1) {
                    int abfrage;
                    boolean treffer = false;
                    Rectangle aktuellesRect = null;
                    CloseableBrowserTabbedPaneUI tpui = (CloseableBrowserTabbedPaneUI)GUIApplicationTextEditorWindow.this.tpTabs.getUI();
                    ListIterator it = tpui.getButton_positionen().listIterator();
                    while (it.hasNext()) {
                        Rectangle rect = (Rectangle)it.next();
                        if (!rect.intersects(new Rectangle(me.getX(), me.getY(), 1, 1))) continue;
                        treffer = true;
                        aktuellesRect = rect;
                    }
                    if (treffer && (abfrage = GUIApplicationTextEditorWindow.this.showConfirmDialog(I18n.messages.getString("texteditor_msg13"))) == 0) {
                        tpui.getButton_positionen().remove(aktuellesRect);
                        GUIApplicationTextEditorWindow.this.tpTabs.remove(GUIApplicationTextEditorWindow.this.tpTabs.getSelectedIndex());
                    }
                    if (me.getClickCount() == 2) {
                        GUIApplicationTextEditorWindow.this.neu();
                    }
                }
            }
        });
    }

    public void neu() {
        this.editorField.setText("");
        this.setTitle(messages.getString("texteditor_msg1"));
        this.changeCurrentFile(null);
    }

    public void updateUnchangedTextFromFile() {
        if (this.original != null && this.editorField != null && this.aktuelleDatei != null && this.original.equals(this.editorField.getText())) {
            this.original = this.aktuelleDatei.getDateiInhalt();
            this.editorField.setText(this.original);
        }
    }

    @Override
    public void update(Observable observable, Object arg1) {
        if (observable == this.aktuelleDatei) {
            this.updateUnchangedTextFromFile();
        }
    }
}

