/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.Main;
import filius.exception.CreateAccountException;
import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.gui.anwendungssicht.JTableEditable;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.software.email.EmailKonto;
import filius.software.email.EmailServer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class GUIApplicationEmailServerWindow
extends GUIApplicationWindow {
    private static final long serialVersionUID = 1L;
    private JPanel listPanel;
    private JPanel formPanel;
    private JPanel backPanel;
    private JPanel logPanel;
    private JScrollPane scrolly;
    private JScrollPane sPane;
    private JTabbedPane tabby;
    private JButton addButton;
    private JButton deleteButton;
    private JButton startStopButton;
    private JTextField benutzernameField;
    private JTextField domainField;
    private JLabel benutzernameLabel;
    private JLabel nameLabel;
    private JLabel passwortLabel;
    private JLabel domainLabel;
    private JTable kontenListenTabelle;
    private int markierteZeile;
    private JTextArea logArea;
    private JPasswordField passwortField;

    public GUIApplicationEmailServerWindow(GUIDesktopPanel desktop, String appName) {
        super(desktop, appName);
        ((EmailServer)this.holeAnwendung()).kontenLaden();
        this.initialisiereKomponenten();
    }

    private void initialisiereKomponenten() {
        this.startStopButton = new JButton(messages.getString("emailserver_msg1"));
        this.startStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (GUIApplicationEmailServerWindow.this.startStopButton.getText().equals(I18n.messages.getString("emailserver_msg1"))) {
                    ((EmailServer)GUIApplicationEmailServerWindow.this.holeAnwendung()).setAktiv(true);
                    GUIApplicationEmailServerWindow.this.updateLog(I18n.messages.getString("emailserver_msg2"));
                } else {
                    ((EmailServer)GUIApplicationEmailServerWindow.this.holeAnwendung()).setAktiv(false);
                    GUIApplicationEmailServerWindow.this.updateLog(I18n.messages.getString("emailserver_msg3"));
                }
                GUIApplicationEmailServerWindow.this.aktualisiere();
            }
        });
        this.domainLabel = new JLabel(messages.getString("emailserver_msg4"));
        this.domainField = new JTextField();
        this.domainField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((EmailServer)GUIApplicationEmailServerWindow.this.holeAnwendung()).setMailDomain(GUIApplicationEmailServerWindow.this.domainField.getText());
                GUIApplicationEmailServerWindow.this.aktualisiere();
            }
        });
        this.domainField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                ((EmailServer)GUIApplicationEmailServerWindow.this.holeAnwendung()).setMailDomain(GUIApplicationEmailServerWindow.this.domainField.getText());
                GUIApplicationEmailServerWindow.this.aktualisiere();
            }

            @Override
            public void focusGained(FocusEvent arg0) {
            }
        });
        Box obenBox = Box.createHorizontalBox();
        obenBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        obenBox.add(this.startStopButton);
        obenBox.add(Box.createHorizontalStrut(10));
        obenBox.add(this.domainLabel);
        obenBox.add(Box.createHorizontalStrut(3));
        obenBox.add(this.domainField);
        obenBox.add(Box.createHorizontalStrut(3));
        this.tabby = new JTabbedPane();
        this.tabby.setTabPlacement(2);
        this.deleteButton = new JButton(messages.getString("emailserver_msg8"));
        this.deleteButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                EmailKonto mailAccount = ((EmailServer)GUIApplicationEmailServerWindow.this.holeAnwendung()).getListeBenutzerkonten().get(GUIApplicationEmailServerWindow.this.markierteZeile);
                int Auswahl = GUIApplicationEmailServerWindow.this.showOptionDialog(I18n.messages.getString("emailserver_msg11") + mailAccount.getBenutzername().toString() + I18n.messages.getString("emailserver_msg12"), I18n.messages.getString("emailserver_msg13"), 1, 3, null, null, null);
                if (Auswahl == 0) {
                    ((EmailServer)GUIApplicationEmailServerWindow.this.holeAnwendung()).kontoLoeschen(mailAccount);
                    GUIApplicationEmailServerWindow.this.updatekontenListenTabelle();
                }
            }
        });
        DefaultTableModel kontenListenTabelleModell = new DefaultTableModel(0, 2);
        this.kontenListenTabelle = new JTableEditable((TableModel)kontenListenTabelleModell, false);
        this.kontenListenTabelle.setDragEnabled(false);
        this.kontenListenTabelle.setIntercellSpacing(new Dimension(5, 5));
        this.kontenListenTabelle.setRowHeight(30);
        this.kontenListenTabelle.setShowGrid(false);
        this.kontenListenTabelle.setFillsViewportHeight(true);
        this.kontenListenTabelle.setBackground(Color.WHITE);
        this.kontenListenTabelle.setShowHorizontalLines(true);
        TableColumnModel tcm = this.kontenListenTabelle.getColumnModel();
        tcm = this.kontenListenTabelle.getColumnModel();
        tcm.getColumn(0).setHeaderValue(messages.getString("emailserver_msg14"));
        tcm.getColumn(1).setHeaderValue(messages.getString("emailserver_msg15"));
        this.scrolly = new JScrollPane(this.kontenListenTabelle);
        this.scrolly.setPreferredSize(new Dimension(200, 300));
        Box listenBox = Box.createHorizontalBox();
        listenBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        listenBox.add(this.scrolly);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonBox.add(this.deleteButton);
        this.listPanel = new JPanel(new BorderLayout());
        this.listPanel.add((Component)listenBox, "Center");
        this.listPanel.add((Component)buttonBox, "South");
        this.benutzernameLabel = new JLabel(messages.getString("emailserver_msg16"));
        this.benutzernameLabel.setPreferredSize(new Dimension(120, 25));
        this.nameLabel = new JLabel(messages.getString("emailserver_msg17"));
        this.nameLabel.setPreferredSize(new Dimension(120, 25));
        this.passwortLabel = new JLabel(messages.getString("emailserver_msg18"));
        this.passwortLabel.setPreferredSize(new Dimension(120, 25));
        this.benutzernameField = new JTextField();
        this.benutzernameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationEmailServerWindow.this.gueltigkeitPruefen(GUIApplicationEmailServerWindow.this.benutzernameField, EingabenUeberpruefung.musterEmailBenutzername);
            }
        });
        this.passwortField = new JPasswordField();
        Box benutzerBox = Box.createHorizontalBox();
        benutzerBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        benutzerBox.add(this.benutzernameLabel);
        benutzerBox.add(Box.createHorizontalStrut(2));
        benutzerBox.add(this.benutzernameField);
        benutzerBox.setPreferredSize(new Dimension(250, 30));
        Box passwortBox = Box.createHorizontalBox();
        passwortBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        passwortBox.add(this.passwortLabel);
        passwortBox.add(Box.createHorizontalStrut(2));
        passwortBox.add(this.passwortField);
        passwortBox.setPreferredSize(new Dimension(250, 30));
        Box addButtonBox = Box.createHorizontalBox();
        this.addButton = new JButton(messages.getString("emailserver_msg19"));
        this.addButton.setPreferredSize(new Dimension(120, 25));
        this.addButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!GUIApplicationEmailServerWindow.this.benutzernameField.getText().equals("") && !new String(GUIApplicationEmailServerWindow.this.passwortField.getPassword()).equals("")) {
                    if (EingabenUeberpruefung.isGueltig(GUIApplicationEmailServerWindow.this.benutzernameField.getText(), EingabenUeberpruefung.musterKeineLeerzeichen)) {
                        try {
                            ((EmailServer)GUIApplicationEmailServerWindow.this.holeAnwendung()).benutzerHinzufuegen(GUIApplicationEmailServerWindow.this.benutzernameField.getText(), new String(GUIApplicationEmailServerWindow.this.passwortField.getPassword()), I18n.messages.getString("emailserver_msg20"), I18n.messages.getString("emailserver_msg21"));
                            GUIApplicationEmailServerWindow.this.showMessageDialog(I18n.messages.getString("emailserver_msg22") + " " + GUIApplicationEmailServerWindow.this.benutzernameField.getText() + " " + I18n.messages.getString("emailserver_msg23"));
                            GUIApplicationEmailServerWindow.this.benutzernameField.setText("");
                            GUIApplicationEmailServerWindow.this.passwortField.setText("");
                        }
                        catch (CreateAccountException e1) {
                            e1.printStackTrace(Main.debug);
                        }
                    } else {
                        GUIApplicationEmailServerWindow.this.showMessageDialog(I18n.messages.getString("emailserver_msg24"));
                    }
                } else {
                    GUIApplicationEmailServerWindow.this.showMessageDialog(I18n.messages.getString("emailserver_msg25"));
                }
            }
        });
        addButtonBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        addButtonBox.add(this.addButton);
        Box formBox = Box.createVerticalBox();
        formBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        formBox.add(benutzerBox);
        formBox.add(passwortBox);
        formBox.add(addButtonBox);
        Box dummyBox = Box.createHorizontalBox();
        dummyBox.setPreferredSize(new Dimension(1, 100));
        formBox.add(dummyBox);
        this.formPanel = new JPanel(new BorderLayout());
        this.formPanel.add((Component)formBox, "North");
        this.logArea = new JTextArea();
        this.sPane = new JScrollPane(this.logArea);
        Box logBox = Box.createHorizontalBox();
        logBox.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        logBox.add(this.sPane);
        this.logPanel = new JPanel(new BorderLayout());
        this.logPanel.add((Component)logBox, "Center");
        this.backPanel = new JPanel(new BorderLayout());
        this.tabby.addTab(messages.getString("emailserver_msg26"), this.formPanel);
        this.tabby.addTab(messages.getString("emailserver_msg27"), this.listPanel);
        this.tabby.addTab(messages.getString("emailserver_msg28"), this.logPanel);
        this.backPanel.add((Component)obenBox, "North");
        this.backPanel.add((Component)this.tabby, "Center");
        this.getContentPane().add(this.backPanel);
        this.pack();
        this.aktualisiere();
    }

    private void aktualisiere() {
        EmailServer server = (EmailServer)this.holeAnwendung();
        if (server.isAktiv()) {
            this.startStopButton.setText(messages.getString("emailserver_msg29"));
            this.domainField.setEnabled(false);
        } else {
            this.startStopButton.setText(messages.getString("emailserver_msg1"));
            this.domainField.setEnabled(true);
        }
        this.domainField.setText(server.getMailDomain());
        this.updatekontenListenTabelle();
    }

    private void updatekontenListenTabelle() {
        DefaultTableModel tabellenModell = (DefaultTableModel)this.kontenListenTabelle.getModel();
        tabellenModell.setRowCount(0);
        for (EmailKonto tmpKonto : ((EmailServer)this.holeAnwendung()).getListeBenutzerkonten()) {
            Vector<String> v = new Vector<String>();
            v.add(tmpKonto.getBenutzername() + "@" + ((EmailServer)this.holeAnwendung()).getMailDomain());
            v.add(Integer.toString(tmpKonto.getNachrichten().size()));
            tabellenModell.addRow(v);
        }
        this.kontenListenTabelle.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                GUIApplicationEmailServerWindow.this.markierteZeile = GUIApplicationEmailServerWindow.this.kontenListenTabelle.getSelectedRow();
            }
        });
    }

    private void gueltigkeitPruefen(JTextField feld, Pattern pruefRegel) {
        if (EingabenUeberpruefung.isGueltig(feld.getText(), pruefRegel)) {
            feld.setForeground(EingabenUeberpruefung.farbeRichtig);
            JTextField temp = new JTextField();
            feld.setBorder(temp.getBorder());
        } else {
            feld.setForeground(EingabenUeberpruefung.farbeFalsch);
            feld.setBorder(BorderFactory.createLineBorder(EingabenUeberpruefung.farbeFalsch, 1));
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.updatekontenListenTabelle();
        if (arg1 instanceof String) {
            this.updateLog(arg1);
        }
    }

    private void updateLog(Object arg1) {
        this.logArea.append(arg1.toString() + "\n");
        Main.debug.println("GUIApplicationWebServerWindow: update() aufgerufen.");
    }
}

