/*
 * Decompiled with CFR 0.152.
 */
package filius.gui;

import filius.Main;
import filius.gui.GUIContainer;
import filius.gui.GUIErrorHandler;
import filius.gui.JMarkerPanel;
import filius.gui.nachrichtensicht.ExchangeDialog;
import filius.gui.netzwerksicht.GUIKabelItem;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.gui.netzwerksicht.GUINetworkPanel;
import filius.gui.netzwerksicht.JCablePanel;
import filius.gui.netzwerksicht.JKonfiguration;
import filius.gui.netzwerksicht.JSidebarButton;
import filius.gui.netzwerksicht.JVermittlungsrechnerKonfiguration;
import filius.hardware.Kabel;
import filius.hardware.NetzwerkInterface;
import filius.hardware.Port;
import filius.hardware.knoten.InternetKnoten;
import filius.hardware.knoten.Knoten;
import filius.hardware.knoten.Modem;
import filius.hardware.knoten.Notebook;
import filius.hardware.knoten.Rechner;
import filius.hardware.knoten.Switch;
import filius.hardware.knoten.Vermittlungsrechner;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.SzenarioVerwaltung;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.system.SwitchFirmware;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class GUIEvents
implements I18n {
    private int auswahlx;
    private int auswahly;
    private int auswahlx2;
    private int auswahly2;
    private int mausposx;
    private int mausposy;
    private int startPosX;
    private int startPosY;
    private int shiftX;
    private int shiftY;
    private GUIKabelItem neuesKabel;
    private static GUIEvents ref;
    private JSidebarButton aktiveslabel = null;
    private boolean aufmarkierung = false;
    private List<GUIKnotenItem> markedlist = new LinkedList<GUIKnotenItem>();
    private GUIKnotenItem loeschitem;
    private GUIKnotenItem aktivesItem;
    private GUIKnotenItem ziel2;
    private JSidebarButton loeschlabel;
    private JCablePanel kabelPanelVorschau;

    private GUIEvents() {
    }

    public static GUIEvents getGUIEvents() {
        if (ref == null) {
            ref = new GUIEvents();
        }
        return ref;
    }

    public void mausReleased() {
        GUIContainer c = GUIContainer.getGUIContainer();
        List<GUIKnotenItem> itemlist = c.getKnotenItems();
        JMarkerPanel auswahl = c.getAuswahl();
        JMarkerPanel markierung = c.getMarkierung();
        SzenarioVerwaltung.getInstance().setzeGeaendert();
        if (auswahl.isVisible()) {
            int minx = 999999;
            int miny = 999999;
            int maxx = 0;
            int maxy = 0;
            this.markedlist = new LinkedList<GUIKnotenItem>();
            for (GUIKnotenItem tempitem : itemlist) {
                int tx = tempitem.getImageLabel().getX();
                int twidth = tempitem.getImageLabel().getWidth();
                int ty = tempitem.getImageLabel().getY();
                int theight = tempitem.getImageLabel().getHeight();
                int itemPosX = tx + twidth / 2;
                int itemPosY = ty + theight / 2;
                if (itemPosX < auswahl.getX() || itemPosX > auswahl.getX() + auswahl.getWidth() || itemPosY < auswahl.getY() || itemPosY > auswahl.getY() + auswahl.getHeight()) continue;
                minx = Math.min(tx, minx);
                maxx = Math.max(tx + twidth, maxx);
                miny = Math.min(ty, miny);
                maxy = Math.max(ty + theight, maxy);
                this.markedlist.add(tempitem);
            }
            if (!this.markedlist.isEmpty()) {
                markierung.setBounds(minx, miny, maxx - minx, maxy - miny);
                markierung.setVisible(true);
            }
            auswahl.setVisible(false);
        }
    }

    public void mausDragged(MouseEvent e) {
        if (GUIContainer.getGUIContainer().getKabelvorschau().isVisible()) {
            return;
        }
        GUIContainer c = GUIContainer.getGUIContainer();
        JMarkerPanel auswahl = c.getAuswahl();
        JSidebarButton dragVorschau = c.getDragVorschau();
        SzenarioVerwaltung.getInstance().setzeGeaendert();
        if (!c.isMarkerVisible()) {
            if (this.aktiveslabel != null && !dragVorschau.isVisible()) {
                int neuX = e.getX() + this.shiftX;
                if (neuX < 0) {
                    neuX = 0;
                } else {
                    int maxX = GUIContainer.getGUIContainer().getWidth() - this.aktiveslabel.getWidth();
                    if (neuX > maxX) {
                        neuX = maxX - 1;
                    }
                }
                int neuY = e.getY() + this.shiftY;
                if (neuY < 0) {
                    neuY = 0;
                } else {
                    int maxY = GUIContainer.getGUIContainer().getHeight() - this.aktiveslabel.getHeight();
                    if (neuY > maxY) {
                        neuY = maxY - 1;
                    }
                }
                this.aktiveslabel.setLocation(neuX, neuY);
                c.updateCables();
            } else {
                this.mausposx = e.getX();
                this.mausposy = e.getY();
                if (!auswahl.isVisible()) {
                    this.auswahlx = this.mausposx;
                    this.auswahly = this.mausposy;
                    this.auswahlx2 = this.auswahlx;
                    this.auswahly2 = this.auswahly;
                    auswahl.setBounds(this.auswahlx, this.auswahly, this.auswahlx2 - this.auswahlx, this.auswahly2 - this.auswahly);
                    auswahl.setVisible(true);
                } else {
                    this.auswahlx2 = this.mausposx;
                    this.auswahly2 = this.mausposy;
                    auswahl.setBounds(this.auswahlx, this.auswahly, this.auswahlx2 - this.auswahlx, this.auswahly2 - this.auswahly);
                    if (this.mausposx < this.auswahlx) {
                        auswahl.setBounds(this.auswahlx2, this.auswahly, this.auswahlx - this.auswahlx2, this.auswahly2 - this.auswahly);
                    }
                    if (this.mausposy < this.auswahly) {
                        auswahl.setBounds(this.auswahlx, this.auswahly2, this.auswahlx2 - this.auswahlx, this.auswahly - this.auswahly2);
                    }
                    if (this.mausposy < this.auswahly && this.mausposx < this.auswahlx) {
                        auswahl.setBounds(this.auswahlx2, this.auswahly2, this.auswahlx - this.auswahlx2, this.auswahly - this.auswahly2);
                    }
                }
            }
        } else if (!dragVorschau.isVisible()) {
            if (this.aufmarkierung && this.markedlist.size() > 0 && e.getX() >= 0 && e.getX() <= c.getWidth() && e.getY() >= 0 && e.getY() <= c.getHeight()) {
                int verschiebungx = this.startPosX - e.getX();
                this.startPosX = e.getX();
                int verschiebungy = this.startPosY - e.getY();
                this.startPosY = e.getY();
                c.moveMarker(-verschiebungx, -verschiebungy, this.markedlist);
            } else {
                Main.debug.println("Out of Boundaries!");
            }
        }
    }

    public void mausPressedDesignMode(MouseEvent e) {
        GUIContainer c = GUIContainer.getGUIContainer();
        JMarkerPanel auswahl = c.getAuswahl();
        SzenarioVerwaltung.getInstance().setzeGeaendert();
        if (this.neuesKabel == null) {
            this.neuesKabel = new GUIKabelItem();
        }
        this.updateAktivesItem(e.getX(), e.getY());
        if (GUIContainer.getGUIContainer().getMarkierung().inBounds(e.getX(), e.getY())) {
            if (GUIContainer.getGUIContainer().getMarkierung().isVisible()) {
                this.aufmarkierung = true;
                this.startPosX = e.getX();
                this.startPosY = e.getY();
            }
        } else {
            this.aufmarkierung = false;
            GUIContainer.getGUIContainer().getMarkierung().setVisible(false);
            auswahl.setBounds(0, 0, 0, 0);
        }
        if (e.getButton() == 3) {
            if (this.aktivesItem != null && this.aktiveslabel != null) {
                GUIContainer.getGUIContainer().getProperty().minimieren();
                GUIContainer.getGUIContainer().setProperty(null);
                if (!c.getKabelvorschau().isVisible()) {
                    this.kontextMenueEntwurfsmodus(this.aktiveslabel, e.getX(), e.getY());
                } else {
                    this.resetAndHideCablePreview();
                }
            } else {
                GUIKabelItem cableItem = this.findClickedCable(e);
                if (!(this.kabelPanelVorschau != null && this.kabelPanelVorschau.isVisible() || GUIContainer.getGUIContainer().getActiveSite() != 1 || cableItem == null)) {
                    this.contextMenuCable(cableItem, e.getX(), e.getY());
                } else {
                    this.resetAndHideCablePreview();
                }
            }
        } else if (e.getButton() == 1) {
            if (this.aktivesItem != null && this.aktiveslabel != null) {
                if (GUIContainer.getGUIContainer().getKabelvorschau().isVisible()) {
                    GUIContainer.getGUIContainer().getProperty().minimieren();
                    if (this.aktivesItem.getKnoten() instanceof Knoten) {
                        Knoten quellKnoten;
                        Port anschluss;
                        Knoten tempKnoten = this.aktivesItem.getKnoten();
                        boolean success = true;
                        if (this.aktivesItem.getKnoten() instanceof Knoten && (anschluss = (tempKnoten = this.aktivesItem.getKnoten()).holeFreienPort()) == null) {
                            success = false;
                            GUIErrorHandler.getGUIErrorHandler().DisplayError(messages.getString("guievents_msg1"));
                        }
                        if (success && this.neuesKabel.getKabelpanel().getZiel1() != null && tempKnoten.checkConnected(quellKnoten = this.neuesKabel.getKabelpanel().getZiel1().getKnoten())) {
                            success = false;
                            GUIErrorHandler.getGUIErrorHandler().DisplayError(messages.getString("guievents_msg12"));
                        }
                        if (success) {
                            this.processCableConnection(e.getX(), e.getY());
                        }
                    }
                } else {
                    if (GUIContainer.getGUIContainer().getKabelvorschau().isVisible()) {
                        this.resetAndHideCablePreview();
                    }
                    c.setProperty(this.aktivesItem);
                    if (e.getClickCount() == 2) {
                        GUIContainer.getGUIContainer().getProperty().maximieren();
                    }
                    if (!this.aktiveslabel.isSelektiert()) {
                        this.aktiveslabel.setSelektiert(true);
                        this.shiftX = this.aktiveslabel.getX() - e.getX();
                        this.shiftY = this.aktiveslabel.getY() - e.getY();
                    }
                }
            } else {
                auswahl.setVisible(false);
                GUIContainer.getGUIContainer().getProperty().minimieren();
                GUIContainer.getGUIContainer().setProperty(null);
            }
        }
    }

    public void cancelMultipleSelection() {
        this.aufmarkierung = false;
        GUIContainer.getGUIContainer().getMarkierung().setVisible(false);
        GUIContainer.getGUIContainer().getAuswahl().setBounds(0, 0, 0, 0);
    }

    public void processCableConnection(int currentPosX, int currentPosY) {
        if (this.neuesKabel.getKabelpanel().getZiel1() == null) {
            this.connectCableToFirstComponent(currentPosX, currentPosY);
        } else {
            if (this.neuesKabel.getKabelpanel().getZiel2() == null && this.neuesKabel.getKabelpanel().getZiel1() != this.aktivesItem) {
                this.connectCableToSecondComponent(this.aktivesItem);
            }
            int posX = currentPosX;
            int posY = currentPosY;
            this.resetAndShowCablePreview(posX, posY);
        }
    }

    private void connectCableToFirstComponent(int currentPosX, int currentPosY) {
        this.neuesKabel.getKabelpanel().setZiel1(this.aktivesItem);
        GUIContainer.getGUIContainer().getKabelvorschau().setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/ziel2.png")));
        this.kabelPanelVorschau = new JCablePanel();
        GUIContainer.getGUIContainer().getDesignpanel().add(this.kabelPanelVorschau);
        this.kabelPanelVorschau.setZiel1(this.aktivesItem);
        GUIContainer.getGUIContainer().setZiel2Label(new JSidebarButton());
        this.ziel2 = new GUIKnotenItem();
        this.ziel2.setImageLabel(GUIContainer.getGUIContainer().getZiel2Label());
        GUIContainer.getGUIContainer().getZiel2Label().setBounds(currentPosX, currentPosY, 8, 8);
        this.kabelPanelVorschau.setZiel2(this.ziel2);
        this.kabelPanelVorschau.setVisible(true);
        GUIContainer.getGUIContainer().setKabelPanelVorschau(this.kabelPanelVorschau);
    }

    private GUIKabelItem findClickedCable(MouseEvent e) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", clickedCable(" + e + ")");
        int xPos = e.getX() + GUIContainer.getGUIContainer().getXOffset();
        int yPos = e.getY() + GUIContainer.getGUIContainer().getYOffset();
        for (GUIKabelItem tempitem : GUIContainer.getGUIContainer().getCableItems()) {
            if (!tempitem.getKabelpanel().clicked(xPos, yPos)) continue;
            return tempitem;
        }
        return null;
    }

    private void updateAktivesItem(int posX, int posY) {
        this.aktiveslabel = null;
        this.aktivesItem = null;
        if (!GUIContainer.getGUIContainer().isMarkerVisible()) {
            for (GUIKnotenItem tempitem : GUIContainer.getGUIContainer().getKnotenItems()) {
                JSidebarButton templabel = tempitem.getImageLabel();
                templabel.setSelektiert(false);
                templabel.revalidate();
                templabel.updateUI();
                if (!templabel.inBounds(posX, posY)) continue;
                this.aktivesItem = tempitem;
                this.aktiveslabel = tempitem.getImageLabel();
            }
        }
    }

    public GUIKnotenItem getActiveItem() {
        return this.aktivesItem;
    }

    public void setNewItemActive(GUIKnotenItem item) {
        this.aktivesItem = item;
    }

    private void connectCableToSecondComponent(GUIKnotenItem tempitem) {
        Switch sw;
        Vermittlungsrechner r;
        Modem vrOut;
        GUIContainer c = GUIContainer.getGUIContainer();
        GUINetworkPanel draftpanel = c.getDesignpanel();
        Port anschluss1 = null;
        Port anschluss2 = null;
        this.neuesKabel.getKabelpanel().setZiel2(tempitem);
        draftpanel.remove(this.kabelPanelVorschau);
        this.ziel2 = null;
        draftpanel.add(this.neuesKabel.getKabelpanel());
        this.neuesKabel.getKabelpanel().updateBounds();
        draftpanel.updateUI();
        c.getCableItems().add(this.neuesKabel);
        if (this.neuesKabel.getKabelpanel().getZiel1().getKnoten() instanceof Modem) {
            vrOut = (Modem)this.neuesKabel.getKabelpanel().getZiel1().getKnoten();
            anschluss1 = vrOut.getErstenAnschluss();
        } else if (this.neuesKabel.getKabelpanel().getZiel1().getKnoten() instanceof Vermittlungsrechner) {
            r = (Vermittlungsrechner)this.neuesKabel.getKabelpanel().getZiel1().getKnoten();
            anschluss1 = r.holeFreienPort();
        } else if (this.neuesKabel.getKabelpanel().getZiel1().getKnoten() instanceof Switch) {
            sw = (Switch)this.neuesKabel.getKabelpanel().getZiel1().getKnoten();
            anschluss1 = ((SwitchFirmware)sw.getSystemSoftware()).getKnoten().holeFreienPort();
        } else if (this.neuesKabel.getKabelpanel().getZiel1().getKnoten() instanceof InternetKnoten) {
            NetzwerkInterface nic1 = ((InternetKnoten)this.neuesKabel.getKabelpanel().getZiel1().getKnoten()).getNetzwerkInterfaces().get(0);
            anschluss1 = nic1.getPort();
        }
        if (this.neuesKabel.getKabelpanel().getZiel2().getKnoten() instanceof Modem) {
            vrOut = (Modem)this.neuesKabel.getKabelpanel().getZiel2().getKnoten();
            anschluss2 = vrOut.getErstenAnschluss();
        } else if (this.neuesKabel.getKabelpanel().getZiel2().getKnoten() instanceof Vermittlungsrechner) {
            r = (Vermittlungsrechner)this.neuesKabel.getKabelpanel().getZiel2().getKnoten();
            anschluss2 = r.holeFreienPort();
        } else if (this.neuesKabel.getKabelpanel().getZiel2().getKnoten() instanceof Switch) {
            sw = (Switch)this.neuesKabel.getKabelpanel().getZiel2().getKnoten();
            anschluss2 = ((SwitchFirmware)sw.getSystemSoftware()).getKnoten().holeFreienPort();
        } else if (this.neuesKabel.getKabelpanel().getZiel2().getKnoten() instanceof InternetKnoten) {
            NetzwerkInterface nic2 = ((InternetKnoten)this.neuesKabel.getKabelpanel().getZiel2().getKnoten()).getNetzwerkInterfaces().get(0);
            anschluss2 = nic2.getPort();
        }
        this.neuesKabel.setDasKabel(new Kabel());
        this.neuesKabel.getDasKabel().setAnschluesse(new Port[]{anschluss1, anschluss2});
        this.resetAndHideCablePreview();
    }

    public void resetAndHideCablePreview() {
        this.resetCableTool();
        this.hideCableToolPanel();
    }

    private void hideCableToolPanel() {
        GUIContainer.getGUIContainer().getKabelvorschau().setVisible(false);
    }

    private void resetCableTool() {
        this.neuesKabel = new GUIKabelItem();
        GUIContainer.getGUIContainer().getKabelvorschau().setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/ziel1.png")));
        this.ziel2 = null;
        if (this.kabelPanelVorschau != null) {
            this.kabelPanelVorschau.setVisible(false);
        }
    }

    public void resetAndShowCablePreview(int currentPosX, int currentPosY) {
        this.resetCableTool();
        this.showCableToolPanel(currentPosX, currentPosY);
        this.cancelMultipleSelection();
    }

    private void showCableToolPanel(int currentPosX, int currentPosY) {
        JSidebarButton cablePreview = GUIContainer.getGUIContainer().getKabelvorschau();
        cablePreview.setBounds(currentPosX, currentPosY, cablePreview.getWidth(), cablePreview.getHeight());
        cablePreview.setVisible(true);
    }

    public void kontextMenueAktionsmodus(final GUIKnotenItem knotenItem, int posX, int posY) {
        if (knotenItem != null && knotenItem.getKnoten() instanceof InternetKnoten) {
            JPopupMenu popmen = new JPopupMenu();
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("desktopanzeigen")) {
                        GUIContainer.getGUIContainer().showDesktop(knotenItem);
                    }
                    if (e.getActionCommand().startsWith("datenaustausch")) {
                        String macAddress = e.getActionCommand().substring(15);
                        GUIEvents.this.datenAustauschAnzeigen(knotenItem, macAddress);
                    }
                }
            };
            JMenuItem pmVROUTKonf = new JMenuItem(messages.getString("guievents_msg2"));
            pmVROUTKonf.setActionCommand("vroutkonf");
            pmVROUTKonf.addActionListener(al);
            JMenuItem pmDesktopAnzeigen = new JMenuItem(messages.getString("guievents_msg3"));
            pmDesktopAnzeigen.setActionCommand("desktopanzeigen");
            pmDesktopAnzeigen.addActionListener(al);
            if (knotenItem.getKnoten() instanceof Rechner || knotenItem.getKnoten() instanceof Notebook) {
                popmen.add(pmDesktopAnzeigen);
            }
            InternetKnoten node = (InternetKnoten)knotenItem.getKnoten();
            for (NetzwerkInterface nic : node.getNetzwerkInterfaces()) {
                JMenuItem pmDatenAustauschAnzeigen = new JMenuItem(messages.getString("guievents_msg4") + " (" + nic.getIp() + ")");
                pmDatenAustauschAnzeigen.setActionCommand("datenaustausch-" + nic.getMac());
                pmDatenAustauschAnzeigen.addActionListener(al);
                popmen.add(pmDatenAustauschAnzeigen);
            }
            knotenItem.getImageLabel().add(popmen);
            popmen.setVisible(true);
            popmen.show(knotenItem.getImageLabel(), posX, posY);
        }
    }

    private void datenAustauschAnzeigen(GUIKnotenItem item, String macAddress) {
        ExchangeDialog exchangeDialog = GUIContainer.getGUIContainer().getExchangeDialog();
        if (item.getKnoten() instanceof InternetKnoten) {
            InternetKnotenBetriebssystem bs = (InternetKnotenBetriebssystem)((InternetKnoten)item.getKnoten()).getSystemSoftware();
            exchangeDialog.addTable(bs, macAddress);
            ((JDialog)((Object)exchangeDialog)).setVisible(true);
        }
    }

    private void kontextMenueEntwurfsmodus(JSidebarButton templabel, int posX, int posY) {
        this.updateAktivesItem(posX, posY);
        if (this.aktivesItem != null) {
            String textKabelEntfernen = this.aktivesItem.getKnoten() instanceof Rechner || this.aktivesItem.getKnoten() instanceof Notebook ? messages.getString("guievents_msg5") : messages.getString("guievents_msg6");
            final JMenuItem pmShowConfig = new JMenuItem(messages.getString("guievents_msg11"));
            pmShowConfig.setActionCommand("showconfig");
            final JMenuItem pmKabelEntfernen = new JMenuItem(textKabelEntfernen);
            pmKabelEntfernen.setActionCommand("kabelentfernen");
            final JMenuItem pmLoeschen = new JMenuItem(messages.getString("guievents_msg7"));
            pmLoeschen.setActionCommand("del");
            JPopupMenu popmen = new JPopupMenu();
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand() == pmLoeschen.getActionCommand()) {
                        GUIEvents.this.itemLoeschen(GUIEvents.this.loeschlabel, GUIEvents.this.loeschitem);
                    } else if (e.getActionCommand() == pmKabelEntfernen.getActionCommand()) {
                        GUIEvents.this.kabelEntfernen();
                    } else if (e.getActionCommand() == pmShowConfig.getActionCommand()) {
                        GUIContainer.getGUIContainer().setProperty(GUIEvents.this.aktivesItem);
                        GUIContainer.getGUIContainer().getProperty().maximieren();
                    }
                }
            };
            pmLoeschen.addActionListener(al);
            pmKabelEntfernen.addActionListener(al);
            pmShowConfig.addActionListener(al);
            popmen.add(pmShowConfig);
            popmen.add(pmKabelEntfernen);
            popmen.add(pmLoeschen);
            GUIContainer.getGUIContainer().getDesignpanel().add(popmen);
            popmen.setVisible(true);
            popmen.show(GUIContainer.getGUIContainer().getDesignpanel(), posX, posY);
            this.loeschlabel = templabel;
            this.loeschitem = this.aktivesItem;
        }
    }

    private void contextMenuCable(final GUIKabelItem cable, int posX, int posY) {
        final JMenuItem pmRemoveCable = new JMenuItem(messages.getString("guievents_msg5"));
        pmRemoveCable.setActionCommand("removecable");
        JPopupMenu popmen = new JPopupMenu();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() == pmRemoveCable.getActionCommand()) {
                    GUIEvents.this.removeSingleCable(cable);
                }
            }
        };
        pmRemoveCable.addActionListener(al);
        popmen.add(pmRemoveCable);
        GUIContainer.getGUIContainer().getDesignpanel().add(popmen);
        popmen.setVisible(true);
        popmen.show(GUIContainer.getGUIContainer().getDesignpanel(), posX, posY);
    }

    public void itemLoeschen(JSidebarButton loeschlabel, GUIKnotenItem loeschitem) {
        loeschlabel.setVisible(false);
        GUIContainer.getGUIContainer().setProperty(null);
        ListIterator<GUIKabelItem> iteratorAlleKabel = GUIContainer.getGUIContainer().getCableItems().listIterator();
        GUIKabelItem kabel = new GUIKabelItem();
        LinkedList<GUIKabelItem> loeschKabel = new LinkedList<GUIKabelItem>();
        while (iteratorAlleKabel.hasNext()) {
            kabel = iteratorAlleKabel.next();
            if (!kabel.getKabelpanel().getZiel1().equals(loeschitem) && !kabel.getKabelpanel().getZiel2().equals(loeschitem)) continue;
            loeschKabel.add(kabel);
        }
        ListIterator iteratorLoeschKabel = loeschKabel.listIterator();
        while (iteratorLoeschKabel.hasNext()) {
            kabel = (GUIKabelItem)iteratorLoeschKabel.next();
            this.removeSingleCable(kabel);
        }
        GUIContainer.getGUIContainer().removeNodeItem(loeschitem);
        GUIContainer.getGUIContainer().getDesignpanel().remove(loeschlabel);
        GUIContainer.getGUIContainer().getDesignpanel().updateUI();
        GUIContainer.getGUIContainer().updateViewport();
    }

    private void removeSingleCable(GUIKabelItem cable) {
        Main.debug.println("INVOKED filius.gui.GUIEvents, removeSingleCable(" + cable + ")");
        if (cable == null) {
            return;
        }
        JVermittlungsrechnerKonfiguration ziel1konf = null;
        JVermittlungsrechnerKonfiguration ziel2konf = null;
        if (JKonfiguration.getInstance(cable.getKabelpanel().getZiel1().getKnoten()) instanceof JVermittlungsrechnerKonfiguration) {
            ziel1konf = (JVermittlungsrechnerKonfiguration)JKonfiguration.getInstance(cable.getKabelpanel().getZiel1().getKnoten());
        }
        if (JKonfiguration.getInstance(cable.getKabelpanel().getZiel2().getKnoten()) instanceof JVermittlungsrechnerKonfiguration) {
            ziel2konf = (JVermittlungsrechnerKonfiguration)JKonfiguration.getInstance(cable.getKabelpanel().getZiel2().getKnoten());
        }
        cable.getDasKabel().anschluesseTrennen();
        GUIContainer.getGUIContainer().getCableItems().remove(cable);
        GUIContainer.getGUIContainer().getDesignpanel().remove(cable.getKabelpanel());
        GUIContainer.getGUIContainer().updateViewport();
        if (ziel1konf != null) {
            ziel1konf.updateAttribute();
        }
        if (ziel2konf != null) {
            ziel2konf.updateAttribute();
        }
    }

    private void kabelEntfernen() {
        ListIterator<GUIKabelItem> iteratorAlleKabel = GUIContainer.getGUIContainer().getCableItems().listIterator();
        GUIKabelItem tempKabel = null;
        LinkedList<GUIKabelItem> loeschListe = new LinkedList<GUIKabelItem>();
        while (iteratorAlleKabel.hasNext()) {
            tempKabel = iteratorAlleKabel.next();
            if (tempKabel.getKabelpanel().getZiel1().equals(this.loeschitem)) {
                loeschListe.add(tempKabel);
            }
            if (!tempKabel.getKabelpanel().getZiel2().equals(this.loeschitem)) continue;
            loeschListe.add(tempKabel);
            this.ziel2 = this.loeschitem;
        }
        ListIterator iteratorLoeschKabel = loeschListe.listIterator();
        while (iteratorLoeschKabel.hasNext()) {
            tempKabel = (GUIKabelItem)iteratorLoeschKabel.next();
            this.removeSingleCable(tempKabel);
        }
        GUIContainer.getGUIContainer().updateViewport();
    }
}

