/*
 * Decompiled with CFR 0.152.
 */
package filius;

import filius.gui.GUIContainer;
import filius.gui.JMainFrame;
import filius.gui.SplashScreen;
import filius.hardware.Verbindung;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.rahmenprogramm.SzenarioVerwaltung;
import filius.rahmenprogramm.TeeOutputStream;
import java.awt.Rectangle;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Main
implements I18n {
    private static final String FRANCAIS = "Fran\u00e7ais";
    private static final String ENGLISH = "English";
    private static final String DEUTSCH = "Deutsch";
    public static PrintStream debug = System.out;

    public static void starten(String szenarioDatei) {
        debug.println("INVOKED (static) filius.Main, starten(" + szenarioDatei + ")");
        try {
            Information.getInformation().loadIni();
        }
        catch (IOException e1) {
            debug.println("ini could not be read: " + e1.getMessage());
        }
        String konfigPfad = Information.getInformation().getArbeitsbereichPfad() + "konfig.xml";
        if (!new File(konfigPfad).exists() && null == Information.getInformation().getLocale()) {
            Object[] possibleValues = new String[]{DEUTSCH, ENGLISH, FRANCAIS};
            String selectedValue = (String)JOptionPane.showInputDialog(null, "", "Sprache/Language/Langue", 1, null, possibleValues, possibleValues[0]);
            if (selectedValue == null) {
                Information.getInformation().setLocale(Locale.GERMANY);
            } else if (ENGLISH.equals(selectedValue)) {
                Information.getInformation().setLocale(Locale.UK);
            } else if (FRANCAIS.equals(selectedValue)) {
                Information.getInformation().setLocale(Locale.FRANCE);
            } else {
                Information.getInformation().setLocale(Locale.GERMANY);
            }
        } else {
            try {
                XMLDecoder xmldec = new XMLDecoder(new BufferedInputStream(new FileInputStream(konfigPfad)));
                Object[] programmKonfig = (Object[])xmldec.readObject();
                if (programmKonfig != null) {
                    if (programmKonfig.length >= 4) {
                        JMainFrame.getJMainFrame().setBounds((Rectangle)programmKonfig[0]);
                        if (szenarioDatei == null) {
                            szenarioDatei = (String)programmKonfig[1];
                        }
                        if (programmKonfig[2] != null && programmKonfig[3] != null && null == Information.getInformation().getLocale()) {
                            Information.getInformation().setLocale(new Locale((String)programmKonfig[2], (String)programmKonfig[3]));
                        }
                    }
                    if (programmKonfig.length >= 5) {
                        Information.getInformation().setLastOpenedDirectory((String)programmKonfig[4]);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(debug);
            }
        }
        UIManager.put("OptionPane.cancelButtonText", messages.getString("main_dlg_CANCEL"));
        UIManager.put("OptionPane.noButtonText", messages.getString("main_dlg_NO"));
        UIManager.put("OptionPane.okButtonText", messages.getString("main_dlg_OK"));
        UIManager.put("OptionPane.yesButtonText", messages.getString("main_dlg_YES"));
        SplashScreen splashScreen = new SplashScreen("gfx/allgemein/splashscreen.png", null);
        splashScreen.setVisible(true);
        splashScreen.setAlwaysOnTop(true);
        GUIContainer.getGUIContainer().initialisieren();
        long splashTime = System.currentTimeMillis();
        if (szenarioDatei != null) {
            try {
                SzenarioVerwaltung.getInstance().laden(szenarioDatei, GUIContainer.getGUIContainer().getKnotenItems(), GUIContainer.getGUIContainer().getCableItems(), GUIContainer.getGUIContainer().getDocuItems());
            }
            catch (Exception e) {
                e.printStackTrace(debug);
            }
        }
        GUIContainer.getGUIContainer().setProperty(null);
        GUIContainer.getGUIContainer().updateViewport();
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GUIContainer.getGUIContainer().updateCables();
        splashTime = System.currentTimeMillis() - splashTime;
        debug.println("Splash Screen shown for " + splashTime + " ms");
        if (splashTime < 1000L) {
            try {
                Thread.sleep(1000L - splashTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        splashScreen.setAlwaysOnTop(false);
        splashScreen.setVisible(false);
    }

    public static void beenden() {
        debug.println("INVOKED (static) filius.Main, beenden()");
        boolean abbruch = false;
        GUIContainer.getGUIContainer().getMenu().selectMode(1);
        if (SzenarioVerwaltung.getInstance().istGeaendert()) {
            int entscheidung = JOptionPane.showConfirmDialog(JMainFrame.getJMainFrame(), messages.getString("main_msg1"), messages.getString("main_msg2"), 0);
            abbruch = entscheidung != 0;
        }
        if (!abbruch) {
            Object[] programmKonfig = new Object[]{JMainFrame.getJMainFrame().getBounds(), SzenarioVerwaltung.getInstance().holePfad(), Information.getInformation().getLocale().getLanguage(), Information.getInformation().getLocale().getCountry(), Information.getInformation().getLastOpenedDirectory()};
            String applicationConfigPath = Information.getInformation().getArbeitsbereichPfad() + "konfig.xml";
            try (FileOutputStream fos = new FileOutputStream(applicationConfigPath);
                 XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(fos));){
                encoder.writeObject(programmKonfig);
            }
            catch (Exception e) {
                e.printStackTrace(debug);
            }
            SzenarioVerwaltung.loescheVerzeichnisInhalt(Information.getInformation().getTempPfad());
            System.exit(0);
        }
    }

    private static boolean loggen(String logDateiPfad, boolean ausgabeKommandozeile) {
        PrintStream kommandozeile = null;
        if (ausgabeKommandozeile) {
            kommandozeile = System.out;
        }
        if (logDateiPfad != null) {
            try {
                debug = new PrintStream(new TeeOutputStream(new FileOutputStream(logDateiPfad), kommandozeile));
                System.out.println("Ausgaben werden in Datei '" + logDateiPfad + "' protokolliert.");
                System.setErr(debug);
            }
            catch (FileNotFoundException e) {
                System.err.println("Error: logging could not be realised due to FileNotFoundException:\n\t'" + e.toString() + "'");
                debug = new PrintStream(new TeeOutputStream(null, kommandozeile));
            }
            catch (Exception e) {
                System.err.println("Error: logging could not be realised; reason not specified:\n\t'" + e.toString() + "'");
                debug = new PrintStream(new TeeOutputStream(null, kommandozeile));
            }
        } else {
            debug = new PrintStream(new TeeOutputStream(null, kommandozeile));
        }
        return true;
    }

    public static void main(String[] args) {
        block27: {
            String currWD = Information.initArbeitsbereichPfad;
            boolean log = false;
            String newWD = null;
            String argsString = "";
            boolean nativeLookAndFeel = false;
            boolean verbose = false;
            if (args != null && args.length >= 1) {
                for (int i = 0; i < args.length; ++i) {
                    argsString = argsString + args[i] + " ";
                    if (args[i].equals("-l")) {
                        log = true;
                    }
                    if (args[i].equals("-wd")) {
                        if (args.length > i + 1 && !args[i + 1].startsWith("-")) {
                            currWD = newWD = args[++i].trim();
                        } else {
                            System.err.println("Parameter '-wd' ohne Argument verwendet! Korrekte Verwendung (Beispiel):  '-wd /home/user'\n");
                            System.err.println("Parameter '-wd' without content! Correct usage (example):  '-wd /home/user'\n");
                            Main.showUsageInformation();
                            System.exit(1);
                        }
                    }
                    if (args[i].equals("-n")) {
                        nativeLookAndFeel = true;
                    }
                    if (args[i].equals("-h")) {
                        Main.showUsageInformation();
                        System.exit(0);
                    }
                    if (args[i].equals("-s")) {
                        Information.setLowResolution(true);
                    }
                    if (args[i].equals("-v")) {
                        verbose = true;
                    }
                    if (!args[i].equals("-r")) continue;
                    if (args.length > i + 1 && !args[i + 1].startsWith("-")) {
                        try {
                            int rtt = Integer.parseInt(args[++i]);
                            Verbindung.setRTTfactor(rtt);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Ungueltige Round-Trip-Time " + args[i] + ". Ganzzahl erwartet.\n");
                            Main.showUsageInformation();
                            System.exit(1);
                        }
                        continue;
                    }
                    System.err.println("Parameter '-r' ohne Argument verwendet! Korrekte Verwendung (Beispiel):  '-r 2'\n");
                    Main.showUsageInformation();
                    System.exit(1);
                }
                if (currWD.isEmpty() || !currWD.substring(currWD.length() - 1).equals(System.getProperty("file.separator"))) {
                    if (Information.getInformation(currWD + System.getProperty("file.separator")) == null) {
                        System.exit(6);
                    } else if (Information.getInformation(currWD) == null) {
                        System.exit(6);
                    }
                }
                if (log) {
                    log = Main.loggen(Information.getInformation().getArbeitsbereichPfad() + "filius.log", verbose);
                } else {
                    Main.loggen(null, verbose);
                }
            } else {
                if (Information.getInformation(currWD) == null) {
                    System.exit(6);
                }
                Main.loggen(null, false);
            }
            Main.showUsageInformation();
            debug.println("------------------------------------------------------");
            debug.println("\tJava Version: " + System.getProperty("java.version"));
            debug.println("\tJava Directory: " + System.getProperty("java.home"));
            debug.println("\tFILIUS Version: " + Information.getVersion());
            debug.println("\tParameters: '" + argsString.trim() + "'");
            debug.println("\tFILIUS Installation: " + Information.getInformation().getProgrammPfad());
            debug.println("\tFILIUS Working Directory: " + Information.getInformation().getArbeitsbereichPfad());
            debug.println("\tFILIUS Temp Directory: " + Information.getInformation().getTempPfad());
            debug.println("------------------------------------------------------\n");
            if (nativeLookAndFeel) {
                Main.activateNativeLookAndFeel();
            }
            if (args != null && (args.length >= 1 && !log || args.length >= 2 && log)) {
                try {
                    File file = new File(args[args.length - 1]);
                    if (file.exists()) {
                        Main.starten(file.getAbsolutePath());
                        break block27;
                    }
                    Main.starten(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Main.starten(null);
                }
            } else {
                Main.starten(null);
            }
        }
    }

    public static void activateNativeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static void showUsageInformation() {
        StringBuffer usage = new StringBuffer();
        usage.append("\nAufruf:\n");
        usage.append("\tfilius [Optionen] [Pfad zu Projektdatei]\n\n");
        usage.append("Verwenden Sie Filius mit folgenden Optionen:\n");
        usage.append("\t-h   Anzeige dieser Hilfe-Information\n");
        usage.append("\t-v   Ausgabe detaillierter Informationen zu Programmausfuehrung\n");
        usage.append("\t-wd  Pfad zu Arbeitsverzeichnis, in dem durch das Programm Daten\n\t     zur Laufzeit abgelegt werden koennen\n");
        usage.append("\t-l   Loggen der Programmausgabe in Datei (filius.log)\n");
        usage.append("\t-r   Setzen eines Faktors zur Erhoehung der erlaubten\n\t     Round-Trip-Time in Filius (kann erforderlich sein, um Fehler\n\t     bei Ausfuehrung auf langsamer Hardware zu vermeiden)\n\t     Gueltige Werte sind 1 (Vorgabe) bis 5.\n");
        usage.append("\t-n   Darstellung mit betriebssystemspezifischem Look & Feel\n");
        usage.append("\t-s   Darstellung fuer niedrige Bildschirmaufloesung (kleiner\n\t     1024x768) anpassen\n");
        System.out.println(usage.toString());
    }
}

