/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms.implementations;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithmSpi;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public abstract class SignatureBaseRSA
extends SignatureAlgorithmSpi {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureBaseRSA.class);
    private Signature signatureAlgorithm;

    @Override
    public abstract String engineGetURI();

    public SignatureBaseRSA() throws XMLSignatureException {
        String string = JCEMapper.translateURItoJCEID(this.engineGetURI());
        LOG.debug("Created SignatureRSA using {}", string);
        String string2 = JCEMapper.getProviderId();
        try {
            this.signatureAlgorithm = string2 == null ? Signature.getInstance(string) : Signature.getInstance(string, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{string, noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Object[] objectArray = new Object[]{string, noSuchProviderException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.setParameter(algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException(invalidAlgorithmParameterException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws XMLSignatureException {
        try {
            return this.signatureAlgorithm.verify(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected void engineInitVerify(Key key) throws XMLSignatureException {
        if (!(key instanceof PublicKey)) {
            String string = null;
            if (key != null) {
                string = key.getClass().getName();
            }
            String string2 = PublicKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this.signatureAlgorithm.initVerify((PublicKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            Signature signature = this.signatureAlgorithm;
            try {
                this.signatureAlgorithm = Signature.getInstance(this.signatureAlgorithm.getAlgorithm());
            }
            catch (Exception exception) {
                LOG.debug("Exception when reinstantiating Signature: {}", exception);
                this.signatureAlgorithm = signature;
            }
            throw new XMLSignatureException(invalidKeyException);
        }
    }

    @Override
    protected byte[] engineSign() throws XMLSignatureException {
        try {
            return this.signatureAlgorithm.sign();
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected void engineInitSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string = null;
            if (key != null) {
                string = key.getClass().getName();
            }
            String string2 = PrivateKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            if (secureRandom == null) {
                this.signatureAlgorithm.initSign((PrivateKey)key);
            } else {
                this.signatureAlgorithm.initSign((PrivateKey)key, secureRandom);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
    }

    @Override
    protected void engineInitSign(Key key) throws XMLSignatureException {
        this.engineInitSign(key, (SecureRandom)null);
    }

    @Override
    protected void engineUpdate(byte[] byArray) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected void engineUpdate(byte by) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(by);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(byArray, n, n2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected String engineGetJCEAlgorithmString() {
        return this.signatureAlgorithm.getAlgorithm();
    }

    @Override
    protected String engineGetJCEProviderName() {
        return this.signatureAlgorithm.getProvider().getName();
    }

    @Override
    protected void engineSetHMACOutputLength(int n) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.HMACOutputLengthOnlyForHMAC");
    }

    @Override
    protected void engineInitSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseAlgorithmParameterSpecOnRSA");
    }

    public static class SignatureRSASHA3_512MGF1
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA3_384MGF1
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA3_256MGF1
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA3_224MGF1
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA512MGF1
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA384MGF1
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA256MGF1
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA224MGF1
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA1MGF1
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1";
        }
    }

    public static class SignatureRSAMD5
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-md5";
        }
    }

    public static class SignatureRSARIPEMD160
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160";
        }
    }

    public static class SignatureRSASHA512
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
        }
    }

    public static class SignatureRSASHA384
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
        }
    }

    public static class SignatureRSASHA256
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        }
    }

    public static class SignatureRSASHA224
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha224";
        }
    }

    public static class SignatureRSASHA1
    extends SignatureBaseRSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
    }
}

