/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.html.simpleparser;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocListener;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.TextElementArray;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.text.html.simpleparser.CellWrapper;
import com.itextpdf.text.html.simpleparser.ChainedProperties;
import com.itextpdf.text.html.simpleparser.ElementFactory;
import com.itextpdf.text.html.simpleparser.HTMLTagProcessor;
import com.itextpdf.text.html.simpleparser.HTMLTagProcessors;
import com.itextpdf.text.html.simpleparser.ImageProcessor;
import com.itextpdf.text.html.simpleparser.ImageProvider;
import com.itextpdf.text.html.simpleparser.ImageStore;
import com.itextpdf.text.html.simpleparser.LinkProcessor;
import com.itextpdf.text.html.simpleparser.StyleSheet;
import com.itextpdf.text.html.simpleparser.TableWrapper;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.draw.LineSeparator;
import com.itextpdf.text.xml.simpleparser.SimpleXMLDocHandler;
import com.itextpdf.text.xml.simpleparser.SimpleXMLParser;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class HTMLWorker
implements SimpleXMLDocHandler,
DocListener {
    private static Logger LOGGER = LoggerFactory.getLogger(HTMLWorker.class);
    protected DocListener document;
    protected Map<String, HTMLTagProcessor> tags;
    private StyleSheet style = new StyleSheet();
    protected Stack<Element> stack = new Stack();
    protected Paragraph currentParagraph;
    private final ChainedProperties chain = new ChainedProperties();
    public static final String IMG_PROVIDER = "img_provider";
    public static final String IMG_PROCESSOR = "img_interface";
    public static final String IMG_STORE = "img_static";
    public static final String IMG_BASEURL = "img_baseurl";
    public static final String FONT_PROVIDER = "font_factory";
    public static final String LINK_PROVIDER = "alink_interface";
    private Map<String, Object> providers = new HashMap<String, Object>();
    private final ElementFactory factory = new ElementFactory();
    private final Stack<boolean[]> tableState = new Stack();
    private boolean pendingTR = false;
    private boolean pendingTD = false;
    private boolean pendingLI = false;
    private boolean insidePRE = false;
    protected boolean skipText = false;
    protected java.util.List<Element> objectList;

    public HTMLWorker(DocListener document) {
        this(document, null, null);
    }

    public HTMLWorker(DocListener document, Map<String, HTMLTagProcessor> tags, StyleSheet style) {
        this.document = document;
        this.setSupportedTags(tags);
        this.setStyleSheet(style);
    }

    public void setSupportedTags(Map<String, HTMLTagProcessor> tags) {
        if (tags == null) {
            tags = new HTMLTagProcessors();
        }
        this.tags = tags;
    }

    public void setStyleSheet(StyleSheet style) {
        if (style == null) {
            style = new StyleSheet();
        }
        this.style = style;
    }

    public void parse(Reader reader) throws IOException {
        LOGGER.info("Please note, there is a more extended version of the HTMLWorker available in the iText XMLWorker");
        SimpleXMLParser.parse(this, null, reader, true);
    }

    @Override
    public void startDocument() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        this.style.applyStyle("body", attrs);
        this.chain.addToChain("body", attrs);
    }

    @Override
    public void startElement(String tag, Map<String, String> attrs) {
        HTMLTagProcessor htmlTag = this.tags.get(tag);
        if (htmlTag == null) {
            return;
        }
        this.style.applyStyle(tag, attrs);
        StyleSheet.resolveStyleAttribute(attrs, this.chain);
        try {
            htmlTag.startElement(this, tag, attrs);
        }
        catch (DocumentException e) {
            throw new ExceptionConverter(e);
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    @Override
    public void text(String content) {
        if (this.skipText) {
            return;
        }
        if (this.currentParagraph == null) {
            this.currentParagraph = this.createParagraph();
        }
        if (!this.insidePRE) {
            if (content.trim().length() == 0 && content.indexOf(32) < 0) {
                return;
            }
            content = HtmlUtilities.eliminateWhiteSpace(content);
        }
        Chunk chunk = this.createChunk(content);
        this.currentParagraph.add(chunk);
    }

    @Override
    public void endElement(String tag) {
        HTMLTagProcessor htmlTag = this.tags.get(tag);
        if (htmlTag == null) {
            return;
        }
        try {
            htmlTag.endElement(this, tag);
        }
        catch (DocumentException e) {
            throw new ExceptionConverter(e);
        }
    }

    @Override
    public void endDocument() {
        try {
            for (int k = 0; k < this.stack.size(); ++k) {
                this.document.add((Element)this.stack.elementAt(k));
            }
            if (this.currentParagraph != null) {
                this.document.add(this.currentParagraph);
            }
            this.currentParagraph = null;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void newLine() {
        if (this.currentParagraph == null) {
            this.currentParagraph = new Paragraph();
        }
        this.currentParagraph.add(this.createChunk("\n"));
    }

    public void carriageReturn() throws DocumentException {
        if (this.currentParagraph == null) {
            return;
        }
        if (this.stack.empty()) {
            this.document.add(this.currentParagraph);
        } else {
            Element obj = this.stack.pop();
            if (obj instanceof TextElementArray) {
                TextElementArray current = (TextElementArray)obj;
                current.add(this.currentParagraph);
            }
            this.stack.push(obj);
        }
        this.currentParagraph = null;
    }

    public void flushContent() {
        this.pushToStack(this.currentParagraph);
        this.currentParagraph = new Paragraph();
    }

    public void pushToStack(Element element) {
        if (element != null) {
            this.stack.push(element);
        }
    }

    public void updateChain(String tag, Map<String, String> attrs) {
        this.chain.addToChain(tag, attrs);
    }

    public void updateChain(String tag) {
        this.chain.removeChain(tag);
    }

    public void setProviders(Map<String, Object> providers) {
        if (providers == null) {
            return;
        }
        this.providers = providers;
        FontProvider ff = null;
        if (providers != null) {
            ff = (FontProvider)providers.get(FONT_PROVIDER);
        }
        if (ff != null) {
            this.factory.setFontProvider(ff);
        }
    }

    public Chunk createChunk(String content) {
        return this.factory.createChunk(content, this.chain);
    }

    public Paragraph createParagraph() {
        return this.factory.createParagraph(this.chain);
    }

    public List createList(String tag) {
        return this.factory.createList(tag, this.chain);
    }

    public ListItem createListItem() {
        return this.factory.createListItem(this.chain);
    }

    public LineSeparator createLineSeparator(Map<String, String> attrs) {
        return this.factory.createLineSeparator(attrs, this.currentParagraph.getLeading() / 2.0f);
    }

    public Image createImage(Map<String, String> attrs) throws DocumentException, IOException {
        String src = attrs.get("src");
        if (src == null) {
            return null;
        }
        Image img = this.factory.createImage(src, attrs, this.chain, this.document, (ImageProvider)this.providers.get(IMG_PROVIDER), (ImageStore)this.providers.get(IMG_STORE), (String)this.providers.get(IMG_BASEURL));
        return img;
    }

    public CellWrapper createCell(String tag) {
        return new CellWrapper(tag, this.chain);
    }

    public void processLink() {
        Paragraph tmp;
        String href;
        LinkProcessor i;
        if (this.currentParagraph == null) {
            this.currentParagraph = new Paragraph();
        }
        if (!((i = (LinkProcessor)this.providers.get(LINK_PROVIDER)) != null && i.process(this.currentParagraph, this.chain) || (href = this.chain.getProperty("href")) == null)) {
            for (Chunk ck : this.currentParagraph.getChunks()) {
                ck.setAnchor(href);
            }
        }
        if (this.stack.isEmpty()) {
            this.currentParagraph = tmp = new Paragraph(new Phrase(this.currentParagraph));
        } else {
            tmp = (Paragraph)this.stack.pop();
            tmp.add(new Phrase(this.currentParagraph));
            this.currentParagraph = tmp;
        }
    }

    public void processList() throws DocumentException {
        if (this.stack.empty()) {
            return;
        }
        Element obj = this.stack.pop();
        if (!(obj instanceof List)) {
            this.stack.push(obj);
            return;
        }
        if (this.stack.empty()) {
            this.document.add(obj);
        } else {
            ((TextElementArray)this.stack.peek()).add(obj);
        }
    }

    public void processListItem() throws DocumentException {
        if (this.stack.empty()) {
            return;
        }
        Element obj = this.stack.pop();
        if (!(obj instanceof ListItem)) {
            this.stack.push(obj);
            return;
        }
        if (this.stack.empty()) {
            this.document.add(obj);
            return;
        }
        ListItem item = (ListItem)obj;
        Element list = this.stack.pop();
        if (!(list instanceof List)) {
            this.stack.push(list);
            return;
        }
        ((List)list).add(item);
        item.adjustListSymbolFont();
        this.stack.push(list);
    }

    public void processImage(Image img, Map<String, String> attrs) throws DocumentException {
        ImageProcessor processor = (ImageProcessor)this.providers.get(IMG_PROCESSOR);
        if (processor == null || !processor.process(img, attrs, this.chain, this.document)) {
            String align = attrs.get("align");
            if (align != null) {
                this.carriageReturn();
            }
            if (this.currentParagraph == null) {
                this.currentParagraph = this.createParagraph();
            }
            this.currentParagraph.add(new Chunk(img, 0.0f, 0.0f, true));
            this.currentParagraph.setAlignment(HtmlUtilities.alignmentValue(align));
            if (align != null) {
                this.carriageReturn();
            }
        }
    }

    public void processTable() throws DocumentException {
        TableWrapper table = (TableWrapper)this.stack.pop();
        PdfPTable tb = table.createTable();
        tb.setSplitRows(true);
        if (this.stack.empty()) {
            this.document.add(tb);
        } else {
            ((TextElementArray)this.stack.peek()).add(tb);
        }
    }

    public void processRow() {
        Element obj;
        ArrayList<PdfPCell> row = new ArrayList<PdfPCell>();
        ArrayList<Float> cellWidths = new ArrayList<Float>();
        boolean percentage = false;
        float totalWidth = 0.0f;
        int zeroWidth = 0;
        TableWrapper table = null;
        do {
            if (!((obj = this.stack.pop()) instanceof CellWrapper)) continue;
            CellWrapper cell = (CellWrapper)obj;
            float width = cell.getWidth();
            cellWidths.add(new Float(width));
            percentage |= cell.isPercentage();
            if (width == 0.0f) {
                ++zeroWidth;
            } else {
                totalWidth += width;
            }
            row.add(cell.getCell());
        } while (!(obj instanceof TableWrapper));
        table = (TableWrapper)obj;
        table.addRow(row);
        if (cellWidths.size() > 0) {
            totalWidth = 100.0f - totalWidth;
            Collections.reverse(cellWidths);
            float[] widths = new float[cellWidths.size()];
            boolean hasZero = false;
            for (int i = 0; i < widths.length; ++i) {
                widths[i] = ((Float)cellWidths.get(i)).floatValue();
                if (widths[i] == 0.0f && percentage && zeroWidth > 0) {
                    widths[i] = totalWidth / (float)zeroWidth;
                }
                if (widths[i] != 0.0f) continue;
                hasZero = true;
                break;
            }
            if (!hasZero) {
                table.setColWidths(widths);
            }
        }
        this.stack.push(table);
    }

    public void pushTableState() {
        this.tableState.push(new boolean[]{this.pendingTR, this.pendingTD});
    }

    public void popTableState() {
        boolean[] state = this.tableState.pop();
        this.pendingTR = state[0];
        this.pendingTD = state[1];
    }

    public boolean isPendingTR() {
        return this.pendingTR;
    }

    public void setPendingTR(boolean pendingTR) {
        this.pendingTR = pendingTR;
    }

    public boolean isPendingTD() {
        return this.pendingTD;
    }

    public void setPendingTD(boolean pendingTD) {
        this.pendingTD = pendingTD;
    }

    public boolean isPendingLI() {
        return this.pendingLI;
    }

    public void setPendingLI(boolean pendingLI) {
        this.pendingLI = pendingLI;
    }

    public boolean isInsidePRE() {
        return this.insidePRE;
    }

    public void setInsidePRE(boolean insidePRE) {
        this.insidePRE = insidePRE;
    }

    public boolean isSkipText() {
        return this.skipText;
    }

    public void setSkipText(boolean skipText) {
        this.skipText = skipText;
    }

    public static java.util.List<Element> parseToList(Reader reader, StyleSheet style) throws IOException {
        return HTMLWorker.parseToList(reader, style, null);
    }

    public static java.util.List<Element> parseToList(Reader reader, StyleSheet style, HashMap<String, Object> providers) throws IOException {
        return HTMLWorker.parseToList(reader, style, null, providers);
    }

    public static java.util.List<Element> parseToList(Reader reader, StyleSheet style, Map<String, HTMLTagProcessor> tags, HashMap<String, Object> providers) throws IOException {
        HTMLWorker worker = new HTMLWorker(null, tags, style);
        worker.document = worker;
        worker.setProviders(providers);
        worker.objectList = new ArrayList<Element>();
        worker.parse(reader);
        return worker.objectList;
    }

    @Override
    public boolean add(Element element) throws DocumentException {
        this.objectList.add(element);
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean newPage() {
        return true;
    }

    @Override
    public void open() {
    }

    @Override
    public void resetPageCount() {
    }

    @Override
    public boolean setMarginMirroring(boolean marginMirroring) {
        return false;
    }

    @Override
    public boolean setMarginMirroringTopBottom(boolean marginMirroring) {
        return false;
    }

    @Override
    public boolean setMargins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        return true;
    }

    @Override
    public void setPageCount(int pageN) {
    }

    @Override
    public boolean setPageSize(Rectangle pageSize) {
        return true;
    }

    @Deprecated
    public void setInterfaceProps(HashMap<String, Object> providers) {
        this.setProviders(providers);
    }

    @Deprecated
    public Map<String, Object> getInterfaceProps() {
        return this.providers;
    }
}

